/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import org.hyperic.sigar.Mem;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Swap;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class Free
extends SigarCommandBase {
    public Free(Shell shell) {
        super(shell);
    }

    public Free() {
    }

    public String getUsageShort() {
        return "Display information about free and used memory";
    }

    private static Long format(long value) {
        return new Long(value / 1024L);
    }

    public void output(String[] args) throws SigarException {
        Mem mem = this.sigar.getMem();
        Swap swap = this.sigar.getSwap();
        Object[] header = new Object[]{"total", "used", "free"};
        Object[] memRow = new Object[]{Free.format(mem.getTotal()), Free.format(mem.getUsed()), Free.format(mem.getFree())};
        Object[] actualRow = new Object[]{Free.format(mem.getActualUsed()), Free.format(mem.getActualFree())};
        Object[] swapRow = new Object[]{Free.format(swap.getTotal()), Free.format(swap.getUsed()), Free.format(swap.getFree())};
        this.printf("%18s %10s %10s", header);
        this.printf("Mem:    %10ld %10ld %10ld", memRow);
        if (mem.getUsed() != mem.getActualUsed() || mem.getFree() != mem.getActualFree()) {
            this.printf("-/+ buffers/cache: %10ld %10d", actualRow);
        }
        this.printf("Swap:   %10ld %10ld %10ld", swapRow);
        this.printf("RAM:    %10ls", new Object[]{mem.getRam() + "MB"});
    }

    public static void main(String[] args) throws Exception {
        new Free().processCommand(args);
    }
}

