/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import org.hyperic.sigar.Sigar;

public class NetServices {
    private static NetServices instance;
    private Sigar sigar = new Sigar();

    private NetServices() {
    }

    protected void finalize() {
        this.sigar.close();
    }

    private static NetServices getInstance() {
        if (instance == null) {
            instance = new NetServices();
        }
        return instance;
    }

    private static String getServiceName(int protocol, long port) {
        return NetServices.getInstance().sigar.getNetServicesName(protocol, port);
    }

    public static String getName(String protocol, long port) {
        if (protocol.equals("tcp")) {
            return NetServices.getTcpName(port);
        }
        if (protocol.equals("udp")) {
            return NetServices.getUdpName(port);
        }
        return String.valueOf(port);
    }

    public static String getTcpName(long port) {
        return NetServices.getServiceName(16, port);
    }

    public static String getUdpName(long port) {
        return NetServices.getServiceName(32, port);
    }
}

