/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.util;

import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.google.common.collect.Iterators;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.ThriftClient;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.thrift.TException;

public class SmartThriftClient
implements ThriftClient {
    final String keyspace;
    final Metadata metadata;
    final StressSettings settings;
    final ConcurrentHashMap<InetAddress, ConcurrentLinkedQueue<Client>> cache = new ConcurrentHashMap();
    final AtomicInteger queryIdCounter = new AtomicInteger();
    final ConcurrentHashMap<Integer, String> queryStrings = new ConcurrentHashMap();
    final ConcurrentHashMap<String, Integer> queryIds = new ConcurrentHashMap();
    final Set<InetAddress> whiteset;
    final List<InetAddress> whitelist;
    private final AtomicInteger roundrobin = new AtomicInteger();

    public SmartThriftClient(StressSettings settings, String keyspace, Metadata metadata) {
        this.metadata = metadata;
        this.keyspace = keyspace;
        this.settings = settings;
        if (!settings.node.isWhiteList) {
            this.whiteset = null;
            this.whitelist = null;
        } else {
            this.whiteset = settings.node.resolveAllSpecified();
            this.whitelist = Arrays.asList(this.whiteset.toArray(new InetAddress[0]));
        }
    }

    private Integer getId(String query) {
        Integer r = this.queryIds.get(query);
        if (r != null) {
            return r;
        }
        r = this.queryIdCounter.incrementAndGet();
        if (this.queryIds.putIfAbsent(query, r) == null) {
            this.queryStrings.put(r, query);
            return r;
        }
        return this.queryIds.get(query);
    }

    private Client get(ByteBuffer pk) {
        Client tclient;
        ConcurrentLinkedQueue newQ;
        ConcurrentLinkedQueue<Client> q;
        Set hosts = this.metadata.getReplicas(Metadata.quote((String)this.keyspace), pk);
        InetAddress address = null;
        if (hosts.size() > 0) {
            int pos = this.roundrobin.incrementAndGet() % hosts.size();
            for (int i = 0; address == null && i < hosts.size(); ++i) {
                if (pos < 0) {
                    pos = -pos;
                }
                Host host = (Host)Iterators.get(hosts.iterator(), (int)((pos + i) % hosts.size()));
                if (this.whiteset != null && !this.whiteset.contains(host.getAddress())) continue;
                address = host.getAddress();
            }
        }
        if (address == null) {
            address = this.whitelist.get(ThreadLocalRandom.current().nextInt(this.whitelist.size()));
        }
        if ((q = this.cache.get(address)) == null && (q = this.cache.putIfAbsent(address, newQ = new ConcurrentLinkedQueue())) == null) {
            q = newQ;
        }
        if ((tclient = q.poll()) != null) {
            return tclient;
        }
        return new Client(this.settings.getRawThriftClient(address.getHostAddress()), address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batch_mutate(Map<ByteBuffer, Map<String, List<Mutation>>> record, ConsistencyLevel consistencyLevel) throws TException {
        for (Map.Entry<ByteBuffer, Map<String, List<Mutation>>> e : record.entrySet()) {
            Client client = this.get(e.getKey());
            try {
                client.client.batch_mutate(Collections.singletonMap(e.getKey(), e.getValue()), consistencyLevel);
            }
            finally {
                this.cache.get(client.server).add(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ColumnOrSuperColumn> get_slice(ByteBuffer key, ColumnParent parent, SlicePredicate predicate, ConsistencyLevel consistencyLevel) throws TException {
        Client client = this.get(key);
        try {
            List list = client.client.get_slice(key, parent, predicate, consistencyLevel);
            return list;
        }
        finally {
            this.cache.get(client.server).add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level) throws TException {
        Client client = this.get(key);
        try {
            client.client.insert(key, column_parent, column, consistency_level);
        }
        finally {
            this.cache.get(client.server).add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqlResult execute_cql_query(String query, ByteBuffer key, Compression compression) throws TException {
        Client client = this.get(key);
        try {
            CqlResult cqlResult = client.client.execute_cql_query(ByteBufferUtil.bytes((String)query), compression);
            return cqlResult;
        }
        finally {
            this.cache.get(client.server).add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqlResult execute_cql3_query(String query, ByteBuffer key, Compression compression, ConsistencyLevel consistency) throws TException {
        Client client = this.get(key);
        try {
            CqlResult cqlResult = client.client.execute_cql3_query(ByteBufferUtil.bytes((String)query), compression, consistency);
            return cqlResult;
        }
        finally {
            this.cache.get(client.server).add(client);
        }
    }

    @Override
    public Integer prepare_cql3_query(String query, Compression compression) throws TException {
        return this.getId(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqlResult execute_prepared_cql3_query(int queryId, ByteBuffer key, List<ByteBuffer> values, ConsistencyLevel consistency) throws TException {
        Client client = this.get(key);
        try {
            CqlResult cqlResult = client.client.execute_prepared_cql3_query(client.get(queryId, true).intValue(), values, consistency);
            return cqlResult;
        }
        finally {
            this.cache.get(client.server).add(client);
        }
    }

    @Override
    public Integer prepare_cql_query(String query, Compression compression) throws TException {
        return this.getId(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqlResult execute_prepared_cql_query(int queryId, ByteBuffer key, List<ByteBuffer> values) throws TException {
        Client client = this.get(key);
        try {
            CqlResult cqlResult = client.client.execute_prepared_cql_query(client.get(queryId, true).intValue(), values);
            return cqlResult;
        }
        finally {
            this.cache.get(client.server).add(client);
        }
    }

    @Override
    public Map<ByteBuffer, List<ColumnOrSuperColumn>> multiget_slice(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws TException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<KeySlice> get_range_slices(ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level) throws TException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<KeySlice> get_indexed_slices(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws TException {
        throw new UnsupportedOperationException();
    }

    final class Client {
        final Cassandra.Client client;
        final InetAddress server;
        final Map<Integer, Integer> queryMap = new HashMap<Integer, Integer>();

        Client(Cassandra.Client client, InetAddress server) {
            this.client = client;
            this.server = server;
        }

        Integer get(Integer id, boolean cql3) throws TException {
            Integer serverId = this.queryMap.get(id);
            if (serverId != null) {
                return serverId;
            }
            this.prepare(id, cql3);
            return this.queryMap.get(id);
        }

        void prepare(Integer id, boolean cql3) throws TException {
            String query;
            while (null == (query = SmartThriftClient.this.queryStrings.get(id))) {
            }
            if (cql3) {
                Integer serverId = this.client.prepare_cql3_query((ByteBuffer)ByteBufferUtil.bytes((String)query), (Compression)Compression.NONE).itemId;
                this.queryMap.put(id, serverId);
            } else {
                Integer serverId = this.client.prepare_cql_query((ByteBuffer)ByteBufferUtil.bytes((String)query), (Compression)Compression.NONE).itemId;
                this.queryMap.put(id, serverId);
            }
        }
    }
}

