/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class UnavailableException
extends QueryExecutionException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;
    private final ConsistencyLevel consistency;
    private final int required;
    private final int alive;

    public UnavailableException(ConsistencyLevel consistency, int required, int alive) {
        this(null, consistency, required, alive);
    }

    public UnavailableException(InetSocketAddress address, ConsistencyLevel consistency, int required, int alive) {
        super(String.format("Not enough replicas available for query at consistency %s (%d required but only %d alive)", new Object[]{consistency, required, alive}));
        this.address = address;
        this.consistency = consistency;
        this.required = required;
        this.alive = alive;
    }

    private UnavailableException(InetSocketAddress address, String message, Throwable cause, ConsistencyLevel consistency, int required, int alive) {
        super(message, cause);
        this.address = address;
        this.consistency = consistency;
        this.required = required;
        this.alive = alive;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public int getRequiredReplicas() {
        return this.required;
    }

    public int getAliveReplicas() {
        return this.alive;
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public UnavailableException copy() {
        return new UnavailableException(this.getAddress(), this.getMessage(), this, this.consistency, this.required, this.alive);
    }

    public UnavailableException copy(InetSocketAddress address) {
        return new UnavailableException(address, this.getMessage(), this, this.consistency, this.required, this.alive);
    }
}

