/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.DriverException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class BusyConnectionException
extends DriverException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;

    public BusyConnectionException(InetSocketAddress address) {
        super(String.format("[%s] Connection has run out of stream IDs", address.getAddress()));
        this.address = address;
    }

    public BusyConnectionException(InetSocketAddress address, Throwable cause) {
        super(String.format("[%s] Connection has run out of stream IDs", address.getAddress()), cause);
        this.address = address;
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public BusyConnectionException copy() {
        return new BusyConnectionException(this.address, (Throwable)this);
    }
}

