/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DriverThrowables;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public abstract class AbstractSession
implements Session {
    @Override
    public ResultSet execute(String query) {
        return this.execute(new SimpleStatement(query));
    }

    @Override
    public ResultSet execute(String query, Object ... values) {
        return this.execute(new SimpleStatement(query, values));
    }

    @Override
    public ResultSet execute(String query, Map<String, Object> values) {
        return this.execute(new SimpleStatement(query, values));
    }

    @Override
    public ResultSet execute(Statement statement) {
        return this.executeAsync(statement).getUninterruptibly();
    }

    @Override
    public ResultSetFuture executeAsync(String query) {
        return this.executeAsync(new SimpleStatement(query));
    }

    @Override
    public ResultSetFuture executeAsync(String query, Map<String, Object> values) {
        return this.executeAsync(new SimpleStatement(query, values));
    }

    @Override
    public ResultSetFuture executeAsync(String query, Object ... values) {
        return this.executeAsync(new SimpleStatement(query, values));
    }

    @Override
    public PreparedStatement prepare(String query) {
        try {
            return (PreparedStatement)Uninterruptibles.getUninterruptibly(this.prepareAsync(query));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public PreparedStatement prepare(RegularStatement statement) {
        try {
            return (PreparedStatement)Uninterruptibles.getUninterruptibly(this.prepareAsync(statement));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ListenableFuture<PreparedStatement> prepareAsync(String query) {
        return this.prepareAsync(query, null);
    }

    @Override
    public ListenableFuture<PreparedStatement> prepareAsync(final RegularStatement statement) {
        if (statement.hasValues()) {
            throw new IllegalArgumentException("A statement to prepare should not have values");
        }
        ListenableFuture<PreparedStatement> prepared = this.prepareAsync(statement.getQueryString(), statement.getOutgoingPayload());
        return Futures.transform(prepared, (Function)new Function<PreparedStatement, PreparedStatement>(){

            public PreparedStatement apply(PreparedStatement prepared) {
                CodecRegistry codecRegistry;
                ProtocolVersion protocolVersion = AbstractSession.this.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
                ByteBuffer routingKey = statement.getRoutingKey(protocolVersion, codecRegistry = AbstractSession.this.getCluster().getConfiguration().getCodecRegistry());
                if (routingKey != null) {
                    prepared.setRoutingKey(routingKey);
                }
                prepared.setConsistencyLevel(statement.getConsistencyLevel());
                if (statement.isTracing()) {
                    prepared.enableTracing();
                }
                prepared.setRetryPolicy(statement.getRetryPolicy());
                prepared.setOutgoingPayload(statement.getOutgoingPayload());
                prepared.setIdempotent(statement.isIdempotent());
                return prepared;
            }
        });
    }

    protected abstract ListenableFuture<PreparedStatement> prepareAsync(String var1, Map<String, ByteBuffer> var2);

    @Override
    public void close() {
        try {
            this.closeAsync().get();
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

