/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.thrift.util.mem;

import com.thinkaurelius.thrift.util.mem.Buffer;
import java.io.IOException;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class FastMemoryOutputTransport
extends TTransport {
    protected Buffer buf;
    protected int count;
    protected int streamPos = 0;

    public boolean isOpen() {
        return true;
    }

    public void open() throws TTransportException {
    }

    public FastMemoryOutputTransport(int size, boolean useHeapBasedAllocation) {
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        this.buf = Buffer.allocate(size, useHeapBasedAllocation);
    }

    public void close() {
        this.buf.free();
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        throw new UnsupportedOperationException();
    }

    private void expand(int i) {
        if (this.count + i <= this.buf.size()) {
            return;
        }
        this.buf.reallocate((this.count + i) * 2);
    }

    public int size() {
        return this.count;
    }

    public int streamTo(TNonblockingTransport transport) throws IOException {
        int bytesWritten = this.buf.writeTo(transport, this.streamPos, this.count - this.streamPos);
        this.streamPos += bytesWritten;
        return bytesWritten;
    }

    public boolean isFullyStreamed() {
        return this.count - this.streamPos == 0;
    }

    public String toString() {
        return this.buf.toString();
    }

    public void write(byte[] buffer, int offset, int len) {
        if (offset < 0 || offset > buffer.length || len < 0 || len > buffer.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.expand(len);
        int i = this.count;
        for (int j = offset; j < offset + len; ++j) {
            this.buf.put(i, buffer[j]);
            ++i;
        }
        this.count += len;
    }
}

