/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;

public class MD5Digest {
    public final byte[] bytes;
    private final int hashCode;

    private MD5Digest(byte[] bytes) {
        this.bytes = bytes;
        this.hashCode = Arrays.hashCode(bytes);
    }

    public static MD5Digest wrap(byte[] digest) {
        return new MD5Digest(digest);
    }

    public static MD5Digest compute(byte[] toHash) {
        return new MD5Digest(FBUtilities.threadLocalMD5Digest().digest(toHash));
    }

    public static MD5Digest compute(String toHash) {
        try {
            return MD5Digest.compute(toHash.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof MD5Digest)) {
            return false;
        }
        MD5Digest that = (MD5Digest)o;
        return FBUtilities.compareUnsigned(this.bytes, that.bytes, 0, 0, this.bytes.length, that.bytes.length) == 0;
    }

    public String toString() {
        return Hex.bytesToHex(this.bytes);
    }
}

