/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import org.apache.cassandra.exceptions.ExceptionCode;
import org.apache.cassandra.exceptions.TransportException;

public class ProtocolException
extends RuntimeException
implements TransportException {
    private final Integer attemptedLowProtocolVersion;

    public ProtocolException(String msg) {
        this(msg, (Integer)null);
    }

    public ProtocolException(String msg, Integer attemptedLowProtocolVersion) {
        super(msg);
        this.attemptedLowProtocolVersion = attemptedLowProtocolVersion;
    }

    @Override
    public ExceptionCode code() {
        return ExceptionCode.PROTOCOL_ERROR;
    }

    public Integer getAttemptedLowProtocolVersion() {
        return this.attemptedLowProtocolVersion;
    }

    public boolean isSilent() {
        return false;
    }

    public static ProtocolException toSilentException(ProtocolException e) {
        return new Silent(e);
    }

    private static class Silent
    extends ProtocolException {
        public Silent(ProtocolException cause) {
            super(cause.getMessage(), cause.attemptedLowProtocolVersion);
        }

        @Override
        public boolean isSilent() {
            return true;
        }
    }
}

