/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
final class ConnectionLimitHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionLimitHandler.class);
    private static final AttributeKey<InetAddress> addressAttributeKey = AttributeKey.valueOf((String)"address");
    private final ConcurrentMap<InetAddress, AtomicLong> connectionsPerClient = new ConcurrentHashMap<InetAddress, AtomicLong>();
    private final AtomicLong counter = new AtomicLong(0L);

    ConnectionLimitHandler() {
    }

    private static InetAddress setRemoteAddressAttribute(Channel channel) {
        Attribute addressAttribute = channel.attr(addressAttributeKey);
        SocketAddress remoteAddress = channel.remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            addressAttribute.setIfAbsent((Object)((InetSocketAddress)remoteAddress).getAddress());
        } else {
            logger.warn("Remote address of unknown type: {}, skipping per-IP connection limits", remoteAddress.getClass());
        }
        return (InetAddress)addressAttribute.get();
    }

    private static InetAddress getRemoteAddressAttribute(Channel channel) {
        Attribute addressAttribute = channel.attr(addressAttributeKey);
        return (InetAddress)addressAttribute.get();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        long count = this.counter.incrementAndGet();
        long limit = DatabaseDescriptor.getNativeTransportMaxConcurrentConnections();
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        if (count > limit) {
            logger.warn("Exceeded maximum native connection limit of {} by using {} connections", (Object)limit, (Object)count);
            ctx.close();
        } else {
            long perIpLimit = DatabaseDescriptor.getNativeTransportMaxConcurrentConnectionsPerIp();
            if (perIpLimit > 0L) {
                AtomicLong old;
                InetAddress address = ConnectionLimitHandler.setRemoteAddressAttribute(ctx.channel());
                if (address == null) {
                    ctx.close();
                    return;
                }
                AtomicLong perIpCount = (AtomicLong)this.connectionsPerClient.get(address);
                if (perIpCount == null && (old = this.connectionsPerClient.putIfAbsent(address, perIpCount = new AtomicLong(0L))) != null) {
                    perIpCount = old;
                }
                if (perIpCount.incrementAndGet() > perIpLimit) {
                    logger.warn("Exceeded maximum native connection limit per ip of {} by using {} connections", (Object)perIpLimit, (Object)perIpCount);
                    ctx.close();
                    return;
                }
            }
            ctx.fireChannelActive();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        AtomicLong count;
        this.counter.decrementAndGet();
        InetAddress address = ConnectionLimitHandler.getRemoteAddressAttribute(ctx.channel());
        AtomicLong atomicLong = count = address == null ? null : (AtomicLong)this.connectionsPerClient.get(address);
        if (count != null && count.decrementAndGet() <= 0L) {
            this.connectionsPerClient.remove(address);
        }
        ctx.fireChannelInactive();
    }
}

