/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="upgradesstables", description="Rewrite sstables (for the requested tables) that are not on the current version (thus upgrading them to said current version)")
public class UpgradeSSTable
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace> <tables>...]", description="The keyspace followed by one or many tables")
    private List<String> args = new ArrayList<String>();
    @Option(title="include_all", name={"-a", "--include-all-sstables"}, description="Use -a to include all sstables, even those already on the current version")
    private boolean includeAll = false;
    @Option(title="jobs", name={"-j", "--jobs"}, description="Number of sstables to upgrade simultanously, set to 0 to use all available compaction threads")
    private int jobs = 2;

    @Override
    public void execute(NodeProbe probe) {
        List<String> keyspaces = this.parseOptionalKeyspace(this.args, probe);
        String[] tableNames = this.parseOptionalTables(this.args);
        for (String keyspace : keyspaces) {
            try {
                probe.upgradeSSTables(probe.output().out, keyspace, !this.includeAll, this.jobs, tableNames);
            }
            catch (Exception e) {
                throw new RuntimeException("Error occurred during enabling auto-compaction", e);
            }
        }
    }
}

