/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import org.apache.cassandra.gms.EchoMessage;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoVerbHandler
implements IVerbHandler<EchoMessage> {
    private static final Logger logger = LoggerFactory.getLogger(EchoVerbHandler.class);

    @Override
    public void doVerb(MessageIn<EchoMessage> message, int id) {
        if (!StorageService.instance.isShutdown()) {
            logger.trace("Sending a EchoMessage reply {}", (Object)message.from);
            MessageOut<EchoMessage> echoMessage = new MessageOut<EchoMessage>(MessagingService.Verb.REQUEST_RESPONSE, EchoMessage.instance, EchoMessage.serializer);
            MessagingService.instance().sendReply(echoMessage, id, message.from);
        } else {
            logger.trace("Not sending EchoMessage reply to {} - we are shutdown", (Object)message.from);
        }
    }
}

