/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.Ec2MetadataServiceConnector;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ec2Snitch
extends AbstractNetworkTopologySnitch {
    protected static final Logger logger = LoggerFactory.getLogger(Ec2Snitch.class);
    @VisibleForTesting
    public static final String ZONE_NAME_QUERY = "/latest/meta-data/placement/availability-zone";
    private static final String DEFAULT_DC = "UNKNOWN-DC";
    private static final String DEFAULT_RACK = "UNKNOWN-RACK";
    private Map<InetAddress, Map<String, String>> savedEndpoints;
    protected String ec2zone;
    protected String ec2region;
    protected final Ec2MetadataServiceConnector connector;

    public Ec2Snitch() throws IOException, ConfigurationException {
        this(new SnitchProperties());
    }

    public Ec2Snitch(SnitchProperties props) throws IOException, ConfigurationException {
        this(props, Ec2MetadataServiceConnector.create(props));
    }

    @VisibleForTesting
    public Ec2Snitch(SnitchProperties props, Ec2MetadataServiceConnector connector) throws IOException {
        this.connector = connector;
        String az = connector.apiCall(ZONE_NAME_QUERY);
        String[] splits = az.split("-");
        this.ec2zone = splits[splits.length - 1];
        this.ec2region = az.substring(0, az.length() - 1);
        if (this.ec2region.endsWith("1")) {
            this.ec2region = az.substring(0, az.length() - 3);
        }
        String datacenterSuffix = new SnitchProperties().get("dc_suffix", "");
        this.ec2region = this.ec2region.concat(datacenterSuffix);
        logger.info("EC2Snitch using region: {}, zone: {}.", (Object)this.ec2region, (Object)this.ec2zone);
    }

    @Override
    public String getRack(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return this.ec2zone;
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.RACK) == null) {
            if (this.savedEndpoints == null) {
                this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
            }
            if (this.savedEndpoints.containsKey(endpoint)) {
                return this.savedEndpoints.get(endpoint).get("rack");
            }
            return DEFAULT_RACK;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.RACK).value;
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return this.ec2region;
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.DC) == null) {
            if (this.savedEndpoints == null) {
                this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
            }
            if (this.savedEndpoints.containsKey(endpoint)) {
                return this.savedEndpoints.get(endpoint).get("data_center");
            }
            return DEFAULT_DC;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.DC).value;
    }
}

