/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAck;
import org.apache.cassandra.gms.GossipDigestAck2;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipDigestAckVerbHandler
implements IVerbHandler<GossipDigestAck> {
    private static final Logger logger = LoggerFactory.getLogger(GossipDigestAckVerbHandler.class);

    @Override
    public void doVerb(MessageIn<GossipDigestAck> message, int id) {
        InetAddress from = message.from;
        if (logger.isTraceEnabled()) {
            logger.trace("Received a GossipDigestAckMessage from {}", (Object)from);
        }
        if (!Gossiper.instance.isEnabled() && !Gossiper.instance.isInShadowRound()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Ignoring GossipDigestAckMessage because gossip is disabled");
            }
            return;
        }
        GossipDigestAck gDigestAckMessage = (GossipDigestAck)message.payload;
        List<GossipDigest> gDigestList = gDigestAckMessage.getGossipDigestList();
        Map<InetAddress, EndpointState> epStateMap = gDigestAckMessage.getEndpointStateMap();
        logger.trace("Received ack with {} digests and {} states", (Object)gDigestList.size(), (Object)epStateMap.size());
        if (Gossiper.instance.isInShadowRound()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Finishing shadow round with {}", (Object)from);
            }
            Gossiper.instance.finishShadowRound(epStateMap);
            return;
        }
        if (epStateMap.size() > 0) {
            if (System.nanoTime() - Gossiper.instance.firstSynSendAt < 0L || Gossiper.instance.firstSynSendAt == 0L) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Ignoring unrequested GossipDigestAck from {}", (Object)from);
                }
                return;
            }
            Gossiper.instance.notifyFailureDetector(epStateMap);
            Gossiper.instance.applyStateLocally(epStateMap);
        }
        HashMap<InetAddress, EndpointState> deltaEpStateMap = new HashMap<InetAddress, EndpointState>();
        for (GossipDigest gDigest : gDigestList) {
            InetAddress addr = gDigest.getEndpoint();
            EndpointState localEpStatePtr = Gossiper.instance.getStateForVersionBiggerThan(addr, gDigest.getMaxVersion());
            if (localEpStatePtr == null) continue;
            deltaEpStateMap.put(addr, localEpStatePtr);
        }
        MessageOut<GossipDigestAck2> gDigestAck2Message = new MessageOut<GossipDigestAck2>(MessagingService.Verb.GOSSIP_DIGEST_ACK2, new GossipDigestAck2(deltaEpStateMap), GossipDigestAck2.serializer);
        if (logger.isTraceEnabled()) {
            logger.trace("Sending a GossipDigestAck2Message to {}", (Object)from);
        }
        MessagingService.instance().sendOneWay(gDigestAck2Message, from);
    }
}

