/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigestAck2;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;

class GossipDigestAck2Serializer
implements IVersionedSerializer<GossipDigestAck2> {
    GossipDigestAck2Serializer() {
    }

    @Override
    public void serialize(GossipDigestAck2 ack2, DataOutputPlus out, int version) throws IOException {
        out.writeInt(ack2.epStateMap.size());
        for (Map.Entry<InetAddress, EndpointState> entry : ack2.epStateMap.entrySet()) {
            InetAddress ep = entry.getKey();
            CompactEndpointSerializationHelper.serialize(ep, out);
            EndpointState.serializer.serialize(entry.getValue(), out, version);
        }
    }

    @Override
    public GossipDigestAck2 deserialize(DataInputPlus in, int version) throws IOException {
        int size = in.readInt();
        HashMap<InetAddress, EndpointState> epStateMap = new HashMap<InetAddress, EndpointState>(size);
        for (int i = 0; i < size; ++i) {
            InetAddress ep = CompactEndpointSerializationHelper.deserialize(in);
            EndpointState epState = EndpointState.serializer.deserialize(in, version);
            epStateMap.put(ep, epState);
        }
        return new GossipDigestAck2(epStateMap);
    }

    @Override
    public long serializedSize(GossipDigestAck2 ack2, int version) {
        long size = TypeSizes.sizeof(ack2.epStateMap.size());
        for (Map.Entry<InetAddress, EndpointState> entry : ack2.epStateMap.entrySet()) {
            size += (long)CompactEndpointSerializationHelper.serializedSize(entry.getKey()) + EndpointState.serializer.serializedSize(entry.getValue(), version);
        }
        return size;
    }
}

