/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewBuilder
extends CompactionInfo.Holder {
    private final ColumnFamilyStore baseCfs;
    private final View view;
    private final UUID compactionId;
    private final CountDownLatch completed = new CountDownLatch(1);
    private volatile Token prevToken = null;
    private static final Logger logger = LoggerFactory.getLogger(ViewBuilder.class);

    public ViewBuilder(ColumnFamilyStore baseCfs, View view) {
        this.baseCfs = baseCfs;
        this.view = view;
        this.compactionId = UUIDGen.getTimeUUID();
    }

    private void buildKey(DecoratedKey key) {
        AtomicLong noBase = new AtomicLong(Long.MAX_VALUE);
        ReadQuery selectQuery = this.view.getReadQuery();
        if (!selectQuery.selectsKey(key)) {
            logger.trace("Skipping {}, view query filters", (Object)key);
            return;
        }
        int nowInSec = FBUtilities.nowInSeconds();
        SinglePartitionReadCommand command = this.view.getSelectStatement().internalReadForView(key, nowInSec);
        UnfilteredRowIterator empty = UnfilteredRowIterators.noRowsIterator(this.baseCfs.metadata, key, Rows.EMPTY_STATIC_ROW, DeletionTime.LIVE, false);
        try (ReadOrderGroup orderGroup = command.startOrderGroup();
             UnfilteredRowIterator data = UnfilteredPartitionIterators.getOnlyElement(command.executeLocally(orderGroup), command);){
            Iterator<Collection<Mutation>> mutations = this.baseCfs.keyspace.viewManager.forTable(this.baseCfs.metadata).generateViewUpdates(Collections.singleton(this.view), data, empty, nowInSec, true);
            mutations.forEachRemaining(m -> StorageProxy.mutateMV(key.getKey(), m, true, noBase));
        }
    }

    public void run() {
        Token lastToken;
        logger.debug("Starting view builder for {}.{}", (Object)this.baseCfs.metadata.ksName, (Object)this.view.name);
        String ksname = this.baseCfs.metadata.ksName;
        String viewName = this.view.name;
        if (SystemKeyspace.isViewBuilt(ksname, viewName)) {
            logger.debug("View already marked built for {}.{}", (Object)this.baseCfs.metadata.ksName, (Object)this.view.name);
            this.completed.countDown();
            return;
        }
        Collection<Range<Token>> ranges = StorageService.instance.getLocalRanges(this.baseCfs.metadata.ksName);
        Pair<Integer, Token> buildStatus = SystemKeyspace.getViewBuildStatus(ksname, viewName);
        if (buildStatus == null) {
            logger.debug("Starting new view build. flushing base table {}.{}", (Object)this.baseCfs.metadata.ksName, (Object)this.baseCfs.name);
            lastToken = null;
            SystemKeyspace.beginViewBuild(ksname, viewName, 0);
        } else {
            lastToken = (Token)buildStatus.right;
            logger.debug("Resuming view build from token {}. flushing base table {}.{}", new Object[]{lastToken, this.baseCfs.metadata.ksName, this.baseCfs.name});
        }
        this.baseCfs.forceBlockingFlush();
        Function<org.apache.cassandra.db.lifecycle.View, Iterable<SSTableReader>> function = org.apache.cassandra.db.lifecycle.View.selectFunction(SSTableSet.CANONICAL);
        this.prevToken = lastToken;
        long keysBuilt = 0L;
        try (Refs<SSTableReader> sstables = this.baseCfs.selectAndReference(function).refs;
             ReducingKeyIterator iter = new ReducingKeyIterator(sstables);){
            while (!this.isStopRequested() && iter.hasNext()) {
                DecoratedKey key = iter.next();
                Token token = key.getToken();
                if (lastToken != null && lastToken.compareTo(token) >= 0) continue;
                for (Range range : ranges) {
                    if (!range.contains(token)) continue;
                    this.buildKey(key);
                    ++keysBuilt;
                    if (this.prevToken != null && this.prevToken.compareTo(token) == 0) continue;
                    SystemKeyspace.updateViewBuildStatus(ksname, viewName, key.getToken());
                    this.prevToken = token;
                }
                lastToken = null;
            }
            if (!this.isStopRequested()) {
                logger.debug("Marking view({}.{}) as built covered {} keys ", new Object[]{ksname, viewName, keysBuilt});
                SystemKeyspace.finishViewBuildStatus(ksname, viewName);
            } else {
                logger.debug("Stopped build for view({}.{}) after covering {} keys", new Object[]{ksname, viewName, keysBuilt});
            }
        }
        catch (Exception e) {
            ViewBuilder builder = new ViewBuilder(this.baseCfs, this.view);
            ScheduledExecutors.nonPeriodicTasks.schedule(() -> CompactionManager.instance.submitViewBuilder(builder), 5L, TimeUnit.MINUTES);
            logger.warn("Materialized View failed to complete, sleeping 5 minutes before restarting", (Throwable)e);
        }
        this.completed.countDown();
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        long rangesCompleted = 0L;
        long rangesTotal = 0L;
        Token lastToken = this.prevToken;
        for (Range<Token> range : StorageService.instance.getLocalRanges(this.baseCfs.keyspace.getName())) {
            ++rangesTotal;
            if (lastToken == null || lastToken.compareTo(range.right) <= 0) continue;
            ++rangesCompleted;
        }
        return new CompactionInfo(this.baseCfs.metadata, OperationType.VIEW_BUILD, rangesCompleted, rangesTotal, CompactionInfo.Unit.RANGES, this.compactionId);
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    void waitForCompletion() {
        try {
            this.completed.await();
        }
        catch (InterruptedException ie) {
            throw new AssertionError((Object)ie);
        }
    }
}

