/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.Roles;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.RoleName;
import org.apache.cassandra.cql3.statements.AuthenticationStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;

public class DropRoleStatement
extends AuthenticationStatement {
    private final RoleResource role;
    private final boolean ifExists;

    public DropRoleStatement(RoleName name, boolean ifExists) {
        this.role = RoleResource.role(name.getName());
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        super.checkPermission(state, Permission.DROP, this.role);
        if (DatabaseDescriptor.getRoleManager().isExistingRole(this.role) && Roles.hasSuperuserStatus(this.role) && !state.getUser().isSuper()) {
            throw new UnauthorizedException("Only superusers can drop a role with superuser status");
        }
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        state.ensureNotAnonymous();
        if (!this.ifExists && !DatabaseDescriptor.getRoleManager().isExistingRole(this.role)) {
            throw new InvalidRequestException(String.format("%s doesn't exist", this.role.getRoleName()));
        }
        AuthenticatedUser user = state.getUser();
        if (user != null && user.getName().equals(this.role.getRoleName())) {
            throw new InvalidRequestException("Cannot DROP primary role for current login");
        }
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        if (this.ifExists && !DatabaseDescriptor.getRoleManager().isExistingRole(this.role)) {
            return null;
        }
        DatabaseDescriptor.getRoleManager().dropRole(state.getUser(), this.role);
        DatabaseDescriptor.getAuthorizer().revokeAllFrom(this.role);
        DatabaseDescriptor.getAuthorizer().revokeAllOn(this.role);
        return null;
    }
}

