/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Spring AI Embeddings
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SpringAiEmbeddingsEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Spring AI Embeddings component.
     */
    public interface SpringAiEmbeddingsEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSpringAiEmbeddingsEndpointBuilder advanced() {
            return (AdvancedSpringAiEmbeddingsEndpointBuilder) this;
        }

        /**
         * The EmbeddingModel to use for generating embeddings.
         * 
         * The option is a:
         * <code>org.springframework.ai.embedding.EmbeddingModel</code> type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param embeddingModel the value to set
         * @return the dsl builder
         */
        default SpringAiEmbeddingsEndpointBuilder embeddingModel(org.springframework.ai.embedding.EmbeddingModel embeddingModel) {
            doSetProperty("embeddingModel", embeddingModel);
            return this;
        }
        /**
         * The EmbeddingModel to use for generating embeddings.
         * 
         * The option will be converted to a
         * <code>org.springframework.ai.embedding.EmbeddingModel</code> type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param embeddingModel the value to set
         * @return the dsl builder
         */
        default SpringAiEmbeddingsEndpointBuilder embeddingModel(String embeddingModel) {
            doSetProperty("embeddingModel", embeddingModel);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Spring AI Embeddings component.
     */
    public interface AdvancedSpringAiEmbeddingsEndpointBuilder
            extends
                EndpointProducerBuilder {
        default SpringAiEmbeddingsEndpointBuilder basic() {
            return (SpringAiEmbeddingsEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiEmbeddingsEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiEmbeddingsEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface SpringAiEmbeddingsBuilders {
        /**
         * Spring AI Embeddings (camel-spring-ai-embeddings)
         * Spring AI Embeddings
         * 
         * Category: ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-spring-ai-embeddings
         * 
         * @return the dsl builder for the headers' name.
         */
        default SpringAiEmbeddingsHeaderNameBuilder springAiEmbeddings() {
            return SpringAiEmbeddingsHeaderNameBuilder.INSTANCE;
        }
        /**
         * Spring AI Embeddings (camel-spring-ai-embeddings)
         * Spring AI Embeddings
         * 
         * Category: ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-spring-ai-embeddings
         * 
         * Syntax: <code>spring-ai-embeddings:embeddingId</code>
         * 
         * Path parameter: embeddingId (required)
         * The id
         * 
         * @param path embeddingId
         * @return the dsl builder
         */
        default SpringAiEmbeddingsEndpointBuilder springAiEmbeddings(String path) {
            return SpringAiEmbeddingsEndpointBuilderFactory.endpointBuilder("spring-ai-embeddings", path);
        }
        /**
         * Spring AI Embeddings (camel-spring-ai-embeddings)
         * Spring AI Embeddings
         * 
         * Category: ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-spring-ai-embeddings
         * 
         * Syntax: <code>spring-ai-embeddings:embeddingId</code>
         * 
         * Path parameter: embeddingId (required)
         * The id
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path embeddingId
         * @return the dsl builder
         */
        default SpringAiEmbeddingsEndpointBuilder springAiEmbeddings(String componentName, String path) {
            return SpringAiEmbeddingsEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Spring AI Embeddings component.
     */
    public static class SpringAiEmbeddingsHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final SpringAiEmbeddingsHeaderNameBuilder INSTANCE = new SpringAiEmbeddingsHeaderNameBuilder();

        /**
         * The embedding response metadata.
         * 
         * The option is a: {@code
         * org.springframework.ai.embedding.EmbeddingResponseMetadata} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiEmbeddingMetadata}.
         */
        public String springAiEmbeddingMetadata() {
            return "CamelSpringAiEmbeddingMetadata";
        }
        /**
         * The index of the embedding in the response.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiEmbeddingIndex}.
         */
        public String springAiEmbeddingIndex() {
            return "CamelSpringAiEmbeddingIndex";
        }
        /**
         * The Embedding object.
         * 
         * The option is a: {@code org.springframework.ai.embedding.Embedding}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiEmbedding}.
         */
        public String springAiEmbedding() {
            return "CamelSpringAiEmbedding";
        }
        /**
         * The input text that was embedded.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiEmbeddingInputText}.
         */
        public String springAiEmbeddingInputText() {
            return "CamelSpringAiEmbeddingInputText";
        }
        /**
         * List of Embedding objects.
         * 
         * The option is a: {@code
         * java.util.List<org.springframework.ai.embedding.Embedding>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiEmbeddings}.
         */
        public String springAiEmbeddings() {
            return "CamelSpringAiEmbeddings";
        }
        /**
         * List of input texts that were embedded.
         * 
         * The option is a: {@code java.util.List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiEmbeddingInputTexts}.
         */
        public String springAiEmbeddingInputTexts() {
            return "CamelSpringAiEmbeddingInputTexts";
        }
    }
    static SpringAiEmbeddingsEndpointBuilder endpointBuilder(String componentName, String path) {
        class SpringAiEmbeddingsEndpointBuilderImpl extends AbstractEndpointBuilder implements SpringAiEmbeddingsEndpointBuilder, AdvancedSpringAiEmbeddingsEndpointBuilder {
            public SpringAiEmbeddingsEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SpringAiEmbeddingsEndpointBuilderImpl(path);
    }
}