/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.excerpt;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.LazyName;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.ValueType;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.BiMap;

public class CheckedBiMap
extends ValueType
implements Excerpt {
    public static final LazyName TYPE = LazyName.of("CheckedBiMap", new CheckedBiMap());

    private CheckedBiMap() {
    }

    @Override
    public void addTo(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * A bimap implementation that delegates to a provided forcePut method", new Object[0]).addLine(" * to perform entry validation and insertion into a backing bimap.", new Object[0]).addLine(" */", new Object[0]).addLine("private static class %s<K, V> extends %s<K, V> implements %s<K, V> {", TYPE, AbstractMap.class, BiMap.class).addLine("", new Object[0]).addLine("  private final %s<K, V> biMap;", BiMap.class).addLine("  private final %s<K, V> forcePut;", BiConsumer.class).addLine("", new Object[0]).addLine("  %s(%s<K, V> biMap, %s<K, V> forcePut) {", TYPE, BiMap.class, BiConsumer.class).addLine("    this.biMap = biMap;", new Object[0]).addLine("    this.forcePut = forcePut;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V get(Object key) {", new Object[0]).addLine("    return biMap.get(key);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean containsKey(Object key) {", new Object[0]).addLine("    return biMap.containsKey(key);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V put(K key, V value) {", new Object[0]).addLine("    K oldKey = biMap.inverse().get(value);", new Object[0]).addLine("    %s.checkArgument(", Preconditions.class).addLine("        oldKey == null || %s.equals(oldKey, key),", Objects.class).addLine("        \"value already present: %%s\", value);", new Object[0]).addLine("    V oldValue = biMap.get(key);", new Object[0]).addLine("    forcePut.accept(key, value);", new Object[0]).addLine("    return oldValue;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V forcePut(K key, V value) {", new Object[0]).addLine("    V oldValue = biMap.get(key);", new Object[0]).addLine("    forcePut.accept(key, value);", new Object[0]).addLine("    return oldValue;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V remove(Object key) {", new Object[0]).addLine("    return biMap.remove(key);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public void clear() {", new Object[0]).addLine("    biMap.clear();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<%s<K, V>> entrySet() {", Set.class, Map.Entry.class).addLine("    return new %s<>(biMap, forcePut);", CheckedEntrySet.TYPE).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<V,K> inverse() {", BiMap.class).addLine("    return new %s<V, K>(", TYPE).addLine("        biMap.inverse(), (value, key) -> forcePut.accept(key, value));", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<V> values() {", Set.class).addLine("    return biMap.values();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public void putAll(%s<? extends K, ? extends V> map) {", Map.class).addLine("    for (%s<? extends K, ? extends V> entry : map.entrySet()) {", Map.Entry.class).addLine("      put(entry.getKey(), entry.getValue());", new Object[0]).addLine("    }", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
    }

    private static class CheckedEntrySet
    extends ValueType
    implements Excerpt {
        static final LazyName TYPE = LazyName.of("CheckedEntrySet", new CheckedEntrySet());

        private CheckedEntrySet() {
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("private static class %s<K, V> extends %s<%s<K, V>> {", TYPE, AbstractSet.class, Map.Entry.class).addLine("", new Object[0]).addLine("  private final %s<K, V> biMap;", BiMap.class).addLine("  private final %s<%s<K, V>> set;", Set.class, Map.Entry.class).addLine("  private final %s<K, V> forcePut;", BiConsumer.class).addLine("", new Object[0]).addLine("  %s(%s<K, V> biMap, %s<K, V> forcePut) {", TYPE, BiMap.class, BiConsumer.class).addLine("    this.biMap = biMap;", new Object[0]).addLine("    this.set = biMap.entrySet();", new Object[0]).addLine("    this.forcePut = forcePut;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public int size() {", new Object[0]).addLine("    return set.size();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<%s<K, V>> iterator() {", Iterator.class, Map.Entry.class).addLine("    return new %s<K, V>(biMap, set.iterator(), forcePut);", CheckedEntryIterator.TYPE).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean contains(Object o) {", new Object[0]).addLine("    return set.contains(o);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean remove(Object o) {", new Object[0]).addLine("    return set.remove(o);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public void clear() {", new Object[0]).addLine("    set.clear();", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
        }
    }

    private static class CheckedEntryIterator
    extends ValueType
    implements Excerpt {
        static final LazyName TYPE = LazyName.of("CheckedEntryIterator", new CheckedEntryIterator());

        private CheckedEntryIterator() {
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("private static class %s<K, V> implements %s<%s<K, V>> {", TYPE, Iterator.class, Map.Entry.class).addLine("", new Object[0]).addLine("  private final %s<K, V> biMap;", BiMap.class).addLine("  private final %s<%s<K, V>> iterator;", Iterator.class, Map.Entry.class).addLine("  private final %s<K, V> forcePut;", BiConsumer.class).addLine("", new Object[0]).addLine("  %s(%s<K, V> biMap, %s<%s<K, V>> iterator, %s<K, V> forcePut) {", TYPE, BiMap.class, Iterator.class, Map.Entry.class, BiConsumer.class).addLine("    this.biMap = biMap;", new Object[0]).addLine("    this.iterator = iterator;", new Object[0]).addLine("    this.forcePut = forcePut;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean hasNext() {", new Object[0]).addLine("    return iterator.hasNext();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<K, V> next() {", Map.Entry.class).addLine("    return new %s<K, V>(biMap, iterator.next(), forcePut);", CheckedEntry.TYPE).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public void remove() {", new Object[0]).addLine("    iterator.remove();", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
        }
    }

    private static class CheckedEntry
    extends ValueType
    implements Excerpt {
        static final LazyName TYPE = LazyName.of("CheckedEntry", new CheckedEntry());

        private CheckedEntry() {
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("private static class %s<K, V> implements %s<K, V> {", TYPE, Map.Entry.class).addLine("", new Object[0]).addLine("  private final %s<K, V> biMap;", BiMap.class).addLine("  private final K key;", new Object[0]).addLine("  private V value;", new Object[0]).addLine("  private final %s<K, V> forcePut;", BiConsumer.class).addLine("", new Object[0]).addLine("  %s(%s<K, V> biMap, %s<K, V> entry, %s<K, V> forcePut) {", TYPE, BiMap.class, Map.Entry.class, BiConsumer.class).addLine("    this.biMap = biMap;", new Object[0]).addLine("    this.key = entry.getKey();", new Object[0]).addLine("    this.value = entry.getValue();", new Object[0]).addLine("    this.forcePut = forcePut;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public K getKey() {", new Object[0]).addLine("    return key;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V getValue() {", new Object[0]).addLine("    return value;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V setValue(V value) {", new Object[0]).addLine("    K oldKey = biMap.inverse().get(value);", new Object[0]).addLine("    %s.checkArgument(", Preconditions.class).addLine("        oldKey == null || %s.equals(oldKey, key),", Objects.class).addLine("        \"value already present: %%s\", value);", new Object[0]).addLine("    V oldValue = this.value;", new Object[0]).addLine("    this.value = %s.requireNonNull(value);", Objects.class).addLine("    forcePut.accept(key, value);", new Object[0]).addLine("    return oldValue;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean equals(Object o) {", new Object[0]).addLine("    if (!(o instanceof %s)) {", TYPE).addLine("      return false;", new Object[0]).addLine("    }", new Object[0]).addLine("    %1$s other = (%1$s) o;", TYPE).addLine("    return getKey().equals(other.getKey())", new Object[0]).addLine("        && getValue().equals(other.getValue());", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public int hashCode() {", new Object[0]).addLine("    return %s.hash(key, value);", Objects.class).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
        }
    }
}

