/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.statelib.impl.mvcc;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.bookkeeper.common.coder.Coder;
import org.apache.bookkeeper.statelib.api.exceptions.StateStoreRuntimeException;
import org.apache.bookkeeper.statelib.impl.mvcc.MVCCRecord;
import org.apache.bookkeeper.stream.proto.kv.store.KeyMeta;

final class MVCCRecordCoder
implements Coder<MVCCRecord> {
    private static final MVCCRecordCoder INSTANCE = new MVCCRecordCoder();

    public static MVCCRecordCoder of() {
        return INSTANCE;
    }

    public byte[] encode(MVCCRecord record) {
        KeyMeta meta = KeyMeta.newBuilder().setCreateRevision(record.getCreateRev()).setModRevision(record.getModRev()).setVersion(record.getVersion()).setValueType(record.getValueType()).setExpireTime(record.getExpireTime()).build();
        int metaLen = meta.getSerializedSize();
        int valLen = record.getValue().readableBytes();
        int totalLen = 4 + metaLen + 4 + valLen;
        byte[] data = new byte[totalLen];
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])data);
        buf.writerIndex(0);
        buf.writeInt(metaLen);
        CodedOutputStream out = CodedOutputStream.newInstance((byte[])data, (int)4, (int)metaLen);
        try {
            meta.writeTo(out);
        }
        catch (IOException e) {
            throw new StateStoreRuntimeException("Failed to serialize key metadata", e);
        }
        buf.writerIndex(buf.writerIndex() + metaLen);
        buf.writeInt(valLen);
        buf.writeBytes(record.getValue().slice());
        buf.release();
        return data;
    }

    public void encode(MVCCRecord value, ByteBuf destBuf) {
        destBuf.writeBytes(this.encode(value));
    }

    public int getSerializedSize(MVCCRecord record) {
        KeyMeta meta = KeyMeta.newBuilder().setCreateRevision(record.getCreateRev()).setModRevision(record.getModRev()).setVersion(record.getVersion()).setValueType(record.getValueType()).setExpireTime(record.getExpireTime()).build();
        int metaLen = meta.getSerializedSize();
        int valLen = record.getValue().readableBytes();
        return 4 + metaLen + 4 + valLen;
    }

    public MVCCRecord decode(ByteBuf data) {
        KeyMeta meta;
        ByteBuf copy = data.slice();
        int metaLen = copy.readInt();
        ByteBuffer metaBuf = copy.slice(copy.readerIndex(), metaLen).nioBuffer();
        try {
            meta = KeyMeta.parseFrom((ByteBuffer)metaBuf);
        }
        catch (InvalidProtocolBufferException e) {
            throw new StateStoreRuntimeException("Failed to deserialize key metadata", e);
        }
        copy.skipBytes(metaLen);
        int valLen = copy.readInt();
        ByteBuf valBuf = copy.retainedSlice(copy.readerIndex(), valLen);
        MVCCRecord record = MVCCRecord.newRecord();
        record.setCreateRev(meta.getCreateRevision());
        record.setModRev(meta.getModRevision());
        record.setVersion(meta.getVersion());
        record.setExpireTime(meta.getExpireTime());
        record.setValue(valBuf, meta.getValueType());
        return record;
    }

    private MVCCRecordCoder() {
    }
}

