/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.ResourceLeakDetector;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class TestByteBufAllocator
extends PooledByteBufAllocator {
    private static AtomicReference<TestByteBufAllocator> INSTANCE = new AtomicReference<Object>(null);
    private final List<ByteBuf> trackedBuffers = new ArrayList<ByteBuf>();
    private final ResourceLeakDetector.Level oldLevel;

    public static TestByteBufAllocator getInstance() {
        TestByteBufAllocator result = INSTANCE.get();
        if (result == null) {
            ResourceLeakDetector.Level oldLevel = ResourceLeakDetector.getLevel();
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
            INSTANCE.compareAndSet(null, new TestByteBufAllocator(oldLevel));
            result = INSTANCE.get();
        }
        return result;
    }

    public static void checkForLeaks() {
        TestByteBufAllocator result = INSTANCE.getAndSet(null);
        if (result != null) {
            result.checkInstanceForLeaks();
        }
    }

    private TestByteBufAllocator(ResourceLeakDetector.Level oldLevel) {
        super(false);
        this.oldLevel = oldLevel;
    }

    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        return this.track(super.newHeapBuffer(initialCapacity, maxCapacity));
    }

    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        return this.track(super.newDirectBuffer(initialCapacity, maxCapacity));
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        return this.track(super.compositeHeapBuffer(maxNumComponents));
    }

    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return this.track(super.compositeDirectBuffer(maxNumComponents));
    }

    private synchronized CompositeByteBuf track(CompositeByteBuf byteBuf) {
        this.trackedBuffers.add((ByteBuf)Objects.requireNonNull(byteBuf));
        return byteBuf;
    }

    private synchronized ByteBuf track(ByteBuf byteBuf) {
        this.trackedBuffers.add(Objects.requireNonNull(byteBuf));
        return byteBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInstanceForLeaks() {
        try {
            long referencedBuffersCount = 0L;
            TestByteBufAllocator testByteBufAllocator = this;
            synchronized (testByteBufAllocator) {
                referencedBuffersCount = this.trackedBuffers.stream().filter(byteBuf -> byteBuf.refCnt() > 0).count();
                this.trackedBuffers.clear();
            }
            if (referencedBuffersCount > 0L) {
                System.gc();
                throw new AssertionError((Object)"Found a netty ByteBuf leak!");
            }
        }
        finally {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)this.oldLevel);
        }
    }
}

