/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Quotas;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.common.PathTrie;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.ReferenceCountedACLCache;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTreeTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(DataTreeTest.class);

    @Test
    @Timeout(value=60L)
    public void testDumpEphemerals() throws Exception {
        int count = 1000;
        long session = 1000L;
        long zxid = 2000L;
        final DataTree dataTree = new DataTree();
        LOG.info("Create {} zkclient sessions and its ephemeral nodes", (Object)count);
        this.createEphemeralNode(session, dataTree, count);
        final AtomicBoolean exceptionDuringDumpEphemerals = new AtomicBoolean(false);
        final AtomicBoolean running = new AtomicBoolean(true);
        Thread thread = new Thread(){

            @Override
            public void run() {
                PrintWriter pwriter = new PrintWriter(new StringWriter());
                try {
                    while (running.get()) {
                        dataTree.dumpEphemerals(pwriter);
                    }
                }
                catch (Exception e) {
                    LOG.error("Received exception while dumpEphemerals!", (Throwable)e);
                    exceptionDuringDumpEphemerals.set(true);
                }
            }
        };
        thread.start();
        LOG.debug("Killing {} zkclient sessions and its ephemeral nodes", (Object)count);
        this.killZkClientSession(session, zxid, dataTree, count);
        running.set(false);
        thread.join();
        Assertions.assertFalse((boolean)exceptionDuringDumpEphemerals.get(), (String)"Should have got exception while dumpEphemerals!");
    }

    private void killZkClientSession(long session, long zxid, DataTree dataTree, int count) {
        for (int i = 0; i < count; ++i) {
            dataTree.killSession(session + (long)i, zxid);
        }
    }

    private void createEphemeralNode(long session, DataTree dataTree, int count) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
        for (int i = 0; i < count; ++i) {
            dataTree.createNode("/test" + i, new byte[0], null, session + (long)i, dataTree.getNode((String)"/").stat.getCversion() + 1, 1L, 1L);
        }
    }

    @Test
    @Timeout(value=60L)
    public void testRootWatchTriggered() throws Exception {
        DataTree dt = new DataTree();
        CompletableFuture fire = new CompletableFuture();
        dt.getChildren("/", new Stat(), event -> {
            if (event.getPath().equals("/")) {
                fire.complete(null);
            }
        });
        dt.createNode("/xyz", new byte[0], null, 0L, dt.getNode((String)"/").stat.getCversion() + 1, 1L, 1L);
        Assertions.assertTrue((boolean)fire.isDone(), (String)"Root node watch not triggered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testIncrementCversion() throws Exception {
        try {
            ZooKeeperServer.setDigestEnabled((boolean)true);
            DataTree dt = new DataTree();
            dt.createNode("/test", new byte[0], null, 0L, dt.getNode((String)"/").stat.getCversion() + 1, 1L, 1L);
            DataNode zk = dt.getNode("/test");
            int prevCversion = zk.stat.getCversion();
            long prevPzxid = zk.stat.getPzxid();
            long digestBefore = dt.getTreeDigest();
            dt.setCversionPzxid("/test/", prevCversion + 1, prevPzxid + 1L);
            int newCversion = zk.stat.getCversion();
            long newPzxid = zk.stat.getPzxid();
            Assertions.assertTrue((newCversion == prevCversion + 1 && newPzxid == prevPzxid + 1L ? 1 : 0) != 0, (String)("<cversion, pzxid> verification failed. Expected: <" + (prevCversion + 1) + ", " + (prevPzxid + 1L) + ">, found: <" + newCversion + ", " + newPzxid + ">"));
            Assertions.assertNotEquals((long)digestBefore, (long)dt.getTreeDigest());
        }
        finally {
            ZooKeeperServer.setDigestEnabled((boolean)false);
        }
    }

    @Test
    public void testNoCversionRevert() throws Exception {
        DataTree dt = new DataTree();
        DataNode parent = dt.getNode("/");
        dt.createNode("/test", new byte[0], null, 0L, parent.stat.getCversion() + 1, 1L, 1L);
        int currentCversion = parent.stat.getCversion();
        long currentPzxid = parent.stat.getPzxid();
        dt.createNode("/test1", new byte[0], null, 0L, currentCversion - 1, 1L, 1L);
        parent = dt.getNode("/");
        int newCversion = parent.stat.getCversion();
        long newPzxid = parent.stat.getPzxid();
        Assertions.assertTrue((newCversion >= currentCversion && newPzxid >= currentPzxid ? 1 : 0) != 0, (String)("<cversion, pzxid> verification failed. Expected: <" + currentCversion + ", " + currentPzxid + ">, found: <" + newCversion + ", " + newPzxid + ">"));
    }

    @Test
    public void testPzxidUpdatedWhenDeletingNonExistNode() throws Exception {
        DataTree dt = new DataTree();
        DataNode root = dt.getNode("/");
        long currentPzxid = root.stat.getPzxid();
        long zxid = currentPzxid + 1L;
        try {
            dt.deleteNode("/testPzxidUpdatedWhenDeletingNonExistNode", zxid);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        root = dt.getNode("/");
        currentPzxid = root.stat.getPzxid();
        Assertions.assertEquals((long)currentPzxid, (long)zxid);
        long prevPzxid = currentPzxid;
        zxid = prevPzxid - 1L;
        try {
            dt.deleteNode("/testPzxidUpdatedWhenDeletingNonExistNode", zxid);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        root = dt.getNode("/");
        currentPzxid = root.stat.getPzxid();
        Assertions.assertEquals((long)currentPzxid, (long)prevPzxid);
    }

    @Test
    public void testDigestUpdatedWhenReplayCreateTxnForExistNode() {
        try {
            ZooKeeperServer.setDigestEnabled((boolean)true);
            DataTree dt = new DataTree();
            dt.processTxn(new TxnHeader(13L, 1000, 1L, 30L, 1), (Record)new CreateTxn("/foo", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 1));
            dt.processTxn(new TxnHeader(13L, 1000, 1L, 30L, 1), (Record)new CreateTxn("/foo", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 2));
            Assertions.assertEquals((long)dt.getTreeDigest(), (long)dt.getLastProcessedZxidDigest().getDigest());
        }
        finally {
            ZooKeeperServer.setDigestEnabled((boolean)false);
        }
    }

    @Test
    @Timeout(value=60L)
    public void testPathTrieClearOnDeserialize() throws Exception {
        DataTree dserTree = new DataTree();
        dserTree.createNode("/bug", new byte[20], null, -1L, 1, 1L, 1L);
        dserTree.createNode(Quotas.quotaPath((String)"/bug"), null, null, -1L, 1, 1L, 1L);
        dserTree.createNode(Quotas.limitPath((String)"/bug"), new byte[20], null, -1L, 1, 1L, 1L);
        dserTree.createNode(Quotas.statPath((String)"/bug"), new byte[20], null, -1L, 1, 1L, 1L);
        DataTree tree = new DataTree();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)baos);
        tree.serialize((OutputArchive)oa, "test");
        baos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)bais);
        dserTree.deserialize((InputArchive)ia, "test");
        Field pfield = DataTree.class.getDeclaredField("pTrie");
        pfield.setAccessible(true);
        PathTrie pTrie = (PathTrie)pfield.get(dserTree);
        Assertions.assertEquals((Object)"/", (Object)pTrie.findMaxPrefix("/bug"), (String)"/bug is still in pTrie");
    }

    @Test
    @Timeout(value=60L)
    public void testSerializeDoesntLockACLCacheWhileWriting() throws Exception {
        final DataTree tree = new DataTree();
        tree.createNode("/marker", new byte[]{42}, null, -1L, 1, 1L, 1L);
        final AtomicBoolean ranTestCase = new AtomicBoolean();
        DataOutputStream out = new DataOutputStream(new ByteArrayOutputStream());
        BinaryOutputArchive oa = new BinaryOutputArchive(out){

            public void writeInt(int size, String tag) throws IOException {
                final Semaphore semaphore = new Semaphore(0);
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ReferenceCountedACLCache referenceCountedACLCache = tree.getReferenceCountedAclCache();
                        synchronized (referenceCountedACLCache) {
                            semaphore.release();
                        }
                    }
                }).start();
                try {
                    boolean acquired = semaphore.tryAcquire(30L, TimeUnit.SECONDS);
                    Assertions.assertTrue((boolean)acquired, (String)"Couldn't acquire a lock on the ACLCache while we were calling tree.serialize");
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
                ranTestCase.set(true);
                super.writeInt(size, tag);
            }
        };
        tree.serialize((OutputArchive)oa, "test");
        Assertions.assertTrue((boolean)ranTestCase.get(), (String)"Didn't find the expected node");
    }

    @Test
    @Timeout(value=60L)
    public void testDeserializeDoesntLockACLCacheWhileReading() throws Exception {
        DataTree tree = new DataTree();
        tree.createNode("/marker", new byte[]{42}, null, -1L, 1, 1L, 1L);
        final AtomicBoolean ranTestCase = new AtomicBoolean();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        BinaryOutputArchive oa = new BinaryOutputArchive((DataOutput)out);
        tree.serialize((OutputArchive)oa, "test");
        final DataTree tree2 = new DataTree();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
        BinaryInputArchive ia = new BinaryInputArchive(in){

            public long readLong(String tag) throws IOException {
                final Semaphore semaphore = new Semaphore(0);
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ReferenceCountedACLCache referenceCountedACLCache = tree2.getReferenceCountedAclCache();
                        synchronized (referenceCountedACLCache) {
                            semaphore.release();
                        }
                    }
                }).start();
                try {
                    boolean acquired = semaphore.tryAcquire(30L, TimeUnit.SECONDS);
                    Assertions.assertTrue((boolean)acquired, (String)"Couldn't acquire a lock on the ACLCache while we were calling tree.deserialize");
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
                ranTestCase.set(true);
                return super.readLong(tag);
            }
        };
        tree2.deserialize((InputArchive)ia, "test");
        Assertions.assertTrue((boolean)ranTestCase.get(), (String)"Didn't find the expected node");
    }

    @Test
    @Timeout(value=60L)
    public void testSerializeDoesntLockDataNodeWhileWriting() throws Exception {
        DataTree tree = new DataTree();
        tree.createNode("/marker", new byte[]{42}, null, -1L, 1, 1L, 1L);
        final DataNode markerNode = tree.getNode("/marker");
        final AtomicBoolean ranTestCase = new AtomicBoolean();
        DataOutputStream out = new DataOutputStream(new ByteArrayOutputStream());
        BinaryOutputArchive oa = new BinaryOutputArchive(out){

            public void writeRecord(Record r, String tag) throws IOException {
                if (r instanceof DataNode) {
                    DataNode node = (DataNode)r;
                    if (node.data.length == 1 && node.data[0] == 42) {
                        final Semaphore semaphore = new Semaphore(0);
                        new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                DataNode dataNode = markerNode;
                                synchronized (dataNode) {
                                    semaphore.release();
                                }
                            }
                        }).start();
                        try {
                            boolean acquired = semaphore.tryAcquire(30L, TimeUnit.SECONDS);
                            Assertions.assertTrue((boolean)acquired, (String)"Couldn't acquire a lock on the DataNode while we were calling tree.serialize");
                        }
                        catch (InterruptedException e1) {
                            throw new RuntimeException(e1);
                        }
                        ranTestCase.set(true);
                    }
                }
                super.writeRecord(r, tag);
            }
        };
        tree.serialize((OutputArchive)oa, "test");
        Assertions.assertTrue((boolean)ranTestCase.get(), (String)"Didn't find the expected node");
    }

    @Test
    @Timeout(value=60L)
    public void testReconfigACLClearOnDeserialize() throws Exception {
        DataTree tree = new DataTree();
        tree.deleteNode("/zookeeper/config", 1L);
        tree.getReferenceCountedAclCache().aclIndex = 0L;
        Assertions.assertEquals((int)0, (int)tree.aclCacheSize(), (String)"expected to have 1 acl in acl cache map");
        tree.createNode("/bug", new byte[20], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, -1L, 1, 1L, 1L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)baos);
        tree.serialize((OutputArchive)oa, "test");
        baos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)bais);
        tree.deserialize((InputArchive)ia, "test");
        Assertions.assertEquals((int)1, (int)tree.aclCacheSize(), (String)"expected to have 1 acl in acl cache map");
        Assertions.assertEquals((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)tree.getACL("/bug", new Stat()), (String)"expected to have the same acl");
        tree.addConfigNode();
        Assertions.assertEquals((int)2, (int)tree.aclCacheSize(), (String)"expected to have 2 acl in acl cache map");
        Assertions.assertEquals((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)tree.getACL("/bug", new Stat()), (String)"expected to have the same acl");
    }

    @Test
    public void testCachedApproximateDataSize() throws Exception {
        DataTree dt = new DataTree();
        long initialSize = dt.approximateDataSize();
        Assertions.assertEquals((long)dt.cachedApproximateDataSize(), (long)dt.approximateDataSize());
        dt.createNode("/testApproximateDataSize", new byte[20], null, -1L, 1, 1L, 1L);
        dt.createNode("/testApproximateDataSize1", new byte[20], null, -1L, 1, 1L, 1L);
        Assertions.assertEquals((long)dt.cachedApproximateDataSize(), (long)dt.approximateDataSize());
        dt.setData("/testApproximateDataSize1", new byte[32], -1, 1L, 1L);
        Assertions.assertEquals((long)dt.cachedApproximateDataSize(), (long)dt.approximateDataSize());
        dt.deleteNode("/testApproximateDataSize", -1L);
        Assertions.assertEquals((long)dt.cachedApproximateDataSize(), (long)dt.approximateDataSize());
    }

    @Test
    public void testGetAllChildrenNumber() throws Exception {
        DataTree dt = new DataTree();
        dt.createNode("/all_children_test", new byte[20], null, -1L, 1, 1L, 1L);
        dt.createNode("/all_children_test/nodes", new byte[20], null, -1L, 1, 1L, 1L);
        dt.createNode("/all_children_test/nodes/node1", new byte[20], null, -1L, 1, 1L, 1L);
        dt.createNode("/all_children_test/nodes/node2", new byte[20], null, -1L, 1, 1L, 1L);
        dt.createNode("/all_children_test/nodes/node3", new byte[20], null, -1L, 1, 1L, 1L);
        Assertions.assertEquals((int)4, (int)dt.getAllChildrenNumber("/all_children_test"));
        Assertions.assertEquals((int)3, (int)dt.getAllChildrenNumber("/all_children_test/nodes"));
        Assertions.assertEquals((int)0, (int)dt.getAllChildrenNumber("/all_children_test/nodes/node1"));
        Assertions.assertEquals((int)8, (int)dt.getAllChildrenNumber("/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeserializeZxidDigest() throws Exception {
        try {
            ZooKeeperServer.setDigestEnabled((boolean)true);
            DataTree dt = new DataTree();
            dt.processTxn(new TxnHeader(13L, 1000, 1L, 30L, 1), (Record)new CreateTxn("/foo", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 1), null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)baos);
            dt.serializeZxidDigest((OutputArchive)oa);
            baos.flush();
            DataTree.ZxidDigest zd = dt.getLastProcessedZxidDigest();
            Assertions.assertNotNull((Object)zd);
            BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            dt.deserializeZxidDigest((InputArchive)ia, zd.getZxid());
            Assertions.assertNotNull((Object)dt.getDigestFromLoadedSnapshot());
            ia = BinaryInputArchive.getArchive((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            dt.deserializeZxidDigest((InputArchive)ia, zd.getZxid() + 1L);
            Assertions.assertNull((Object)dt.getDigestFromLoadedSnapshot());
        }
        finally {
            ZooKeeperServer.setDigestEnabled((boolean)false);
        }
    }

    @Test
    public void testDataTreeMetrics() throws Exception {
        ServerMetrics.getMetrics().resetAll();
        long readBytes1 = 0L;
        long readBytes2 = 0L;
        long writeBytes1 = 0L;
        long writeBytes2 = 0L;
        String TOP1 = "top1";
        String TOP2 = "ttop2";
        String TOP1PATH = "/top1";
        String TOP2PATH = "/ttop2";
        String CHILD1 = "child1";
        String CHILD2 = "springishere";
        String CHILD1PATH = "/top1/child1";
        String CHILD2PATH = "/top1/springishere";
        int TOP2_LEN = 50;
        int CHILD1_LEN = 100;
        int CHILD2_LEN = 250;
        DataTree dt = new DataTree();
        dt.createNode("/top1", null, null, -1L, 1, 1L, 1L);
        writeBytes1 += (long)"/top1".length();
        dt.createNode("/ttop2", new byte[50], null, -1L, 1, 1L, 1L);
        writeBytes2 += (long)("/ttop2".length() + 50);
        dt.createNode("/top1/child1", null, null, -1L, 1, 1L, 1L);
        writeBytes1 += (long)"/top1/child1".length();
        dt.setData("/top1/child1", new byte[100], 1, -1L, 1L);
        writeBytes1 += (long)("/top1/child1".length() + 100);
        dt.createNode("/top1/springishere", new byte[250], null, -1L, 1, 1L, 1L);
        writeBytes1 += (long)("/top1/springishere".length() + 250);
        dt.getData("/top1", new Stat(), null);
        readBytes1 += (long)("/top1".length() + 68);
        dt.getData("/ttop2", new Stat(), null);
        readBytes2 += (long)("/ttop2".length() + 50 + 68);
        dt.statNode("/top1/springishere", null);
        readBytes1 += (long)("/top1/springishere".length() + 68);
        dt.getChildren("/top1", new Stat(), null);
        readBytes1 += (long)("/top1".length() + "child1".length() + "springishere".length() + 68);
        dt.deleteNode("/top1", 1L);
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        System.out.println("values:" + values);
        Assertions.assertEquals((Object)(writeBytes1 += (long)"/top1".length()), (Object)values.get("sum_top1_write_per_namespace"));
        Assertions.assertEquals((Object)5L, (Object)values.get("cnt_top1_write_per_namespace"));
        Assertions.assertEquals((Object)writeBytes2, (Object)values.get("sum_ttop2_write_per_namespace"));
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_ttop2_write_per_namespace"));
        Assertions.assertEquals((Object)readBytes1, (Object)values.get("sum_top1_read_per_namespace"));
        Assertions.assertEquals((Object)3L, (Object)values.get("cnt_top1_read_per_namespace"));
        Assertions.assertEquals((Object)readBytes2, (Object)values.get("sum_ttop2_read_per_namespace"));
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_ttop2_read_per_namespace"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDigest() throws Exception {
        try {
            ZooKeeperServer.setDigestEnabled((boolean)true);
            DataTree dt = new DataTree();
            long previousDigest = dt.getTreeDigest();
            dt.createNode("/digesttest", new byte[0], null, -1L, 1, 1L, 1L);
            Assertions.assertNotEquals((long)dt.getTreeDigest(), (long)previousDigest);
            previousDigest = dt.getTreeDigest();
            dt.createNode("/digesttest/1", "1".getBytes(), null, -1L, 2, 2L, 2L);
            Assertions.assertNotEquals((long)dt.getTreeDigest(), (long)previousDigest);
            previousDigest = dt.getTreeDigest();
            try {
                dt.createNode("/digesttest/1", "1".getBytes(), null, -1L, 2, 2L, 2L);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
            Assertions.assertEquals((long)dt.getTreeDigest(), (long)previousDigest);
            previousDigest = dt.getTreeDigest();
            dt.setData("/digesttest/1", "2".getBytes(), 3, 3L, 3L);
            Assertions.assertNotEquals((long)dt.getTreeDigest(), (long)previousDigest);
            previousDigest = dt.getTreeDigest();
            dt.deleteNode("/digesttest/1", 5L);
            Assertions.assertNotEquals((long)dt.getTreeDigest(), (long)previousDigest);
        }
        finally {
            ZooKeeperServer.setDigestEnabled((boolean)false);
        }
    }
}

