/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac.comp;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.javax.lang.model.element.Element;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.sjavac.comp.PubapiVisitor;
import org.openjdk.tools.sjavac.pubapi.PubApi;

public class PubAPIs {
    protected static final Context.Key<PubAPIs> pubApisKey = new Context.Key();
    protected Log log;
    protected Map<Symbol.ClassSymbol, PubApi> publicApiPerClass = new HashMap<Symbol.ClassSymbol, PubApi>();

    public static PubAPIs instance(Context context) {
        PubAPIs pubAPIs = context.get(pubApisKey);
        if (pubAPIs == null) {
            pubAPIs = new PubAPIs(context);
        }
        return pubAPIs;
    }

    private PubAPIs(Context context) {
        context.put(pubApisKey, this);
        this.log = Log.instance(context);
    }

    public Map<String, PubApi> getPubapis(Collection<JavaFileObject> collection, boolean bl) {
        HashMap<String, PubApi> hashMap = new HashMap<String, PubApi>();
        for (Symbol.ClassSymbol classSymbol : this.publicApiPerClass.keySet()) {
            boolean bl2 = collection.contains(classSymbol.sourcefile);
            if (bl != bl2) continue;
            String string = ":" + classSymbol.packge().fullname;
            PubApi pubApi = hashMap.getOrDefault(string, new PubApi());
            hashMap.put(string, PubApi.mergeTypes(pubApi, this.publicApiPerClass.get(classSymbol)));
        }
        return hashMap;
    }

    public void visitPubapi(Element element) {
        if (element == null) {
            return;
        }
        PubapiVisitor pubapiVisitor = new PubapiVisitor();
        pubapiVisitor.visit(element);
        this.publicApiPerClass.put((Symbol.ClassSymbol)element, pubapiVisitor.getCollectedPubApi());
    }
}

