/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.Serializable;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.control.GetConfigurationCommand;
import org.apache.axis2.clustering.control.GetConfigurationResponseCommand;
import org.apache.axis2.clustering.control.GetStateCommand;
import org.apache.axis2.clustering.control.GetStateResponseCommand;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcInitializationRequestHandler
implements RpcCallback {
    private static Log log = LogFactory.getLog(RpcInitializationRequestHandler.class);
    private ConfigurationContext configurationContext;

    public RpcInitializationRequestHandler(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public Serializable replyRequest(Serializable msg, Member invoker) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initialization request received by RpcInitializationRequestHandler");
        }
        if (msg instanceof GetStateCommand) {
            if (this.configurationContext.getPropertyNonReplicable("local_cluster.initialized") == null) {
                return null;
            }
            try {
                log.info((Object)("Received " + String.valueOf(msg) + " initialization request message from " + TribesUtil.getName(invoker)));
                GetStateCommand command = (GetStateCommand)((Object)msg);
                command.execute(this.configurationContext);
                GetStateResponseCommand getStateRespCmd = new GetStateResponseCommand();
                getStateRespCmd.setCommands(command.getCommands());
                return getStateRespCmd;
            }
            catch (ClusteringFault e) {
                String errMsg = "Cannot handle initialization request";
                log.error((Object)errMsg, (Throwable)e);
                throw new RemoteProcessException(errMsg, (Throwable)e);
            }
        }
        if (msg instanceof GetConfigurationCommand) {
            if (this.configurationContext.getPropertyNonReplicable("local_cluster.initialized") == null) {
                return null;
            }
            try {
                log.info((Object)("Received " + String.valueOf(msg) + " initialization request message from " + TribesUtil.getName(invoker)));
                GetConfigurationCommand command = (GetConfigurationCommand)((Object)msg);
                command.execute(this.configurationContext);
                GetConfigurationResponseCommand getConfigRespCmd = new GetConfigurationResponseCommand();
                getConfigRespCmd.setServiceGroups(command.getServiceGroupNames());
                return getConfigRespCmd;
            }
            catch (ClusteringFault e) {
                String errMsg = "Cannot handle initialization request";
                log.error((Object)errMsg, (Throwable)e);
                throw new RemoteProcessException(errMsg, (Throwable)e);
            }
        }
        return null;
    }

    public void leftOver(Serializable msg, Member member) {
    }
}

