/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ReflectionHelper {
    public static <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invokeMethod(Method method, Object instance, Object ... parameters) {
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(instance, parameters);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static boolean hasMethodWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        try {
            do {
                Method[] methods;
                for (Method method : methods = type.getDeclaredMethods()) {
                    if (!ReflectionHelper.hasAnnotation(method, annotationType, checkMetaAnnotations)) continue;
                    return true;
                }
            } while ((type = type.getSuperclass()) != null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean hasAnnotation(AnnotatedElement elem, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        if (elem.isAnnotationPresent(annotationType)) {
            return true;
        }
        if (checkMetaAnnotations) {
            for (Annotation a : elem.getAnnotations()) {
                for (Annotation meta : a.annotationType().getAnnotations()) {
                    if (!meta.annotationType().getName().equals(annotationType.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

