/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.settings.impl;

import java.util.concurrent.TimeUnit;

public enum SlowConsumerThresholdMeasurementUnit {
    MESSAGES_PER_SECOND(1),
    MESSAGES_PER_MINUTE(60),
    MESSAGES_PER_HOUR(3600),
    MESSAGES_PER_DAY(86400);

    private final int measurementUnitInSeconds;

    private SlowConsumerThresholdMeasurementUnit(int measurementUnitInSeconds) {
        this.measurementUnitInSeconds = measurementUnitInSeconds;
    }

    public static SlowConsumerThresholdMeasurementUnit valueOf(int measurementUnitInSeconds) {
        return switch (measurementUnitInSeconds) {
            case 1 -> MESSAGES_PER_SECOND;
            case 60 -> MESSAGES_PER_MINUTE;
            case 3600 -> MESSAGES_PER_HOUR;
            case 86400 -> MESSAGES_PER_DAY;
            default -> null;
        };
    }

    public static TimeUnit unitOf(int measurementUnitInSeconds) {
        return switch (measurementUnitInSeconds) {
            case 1 -> TimeUnit.SECONDS;
            case 60 -> TimeUnit.MINUTES;
            case 3600 -> TimeUnit.HOURS;
            case 86400 -> TimeUnit.DAYS;
            default -> null;
        };
    }

    public int getValue() {
        return this.measurementUnitInSeconds;
    }
}

