/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.settings.impl;

import java.io.Serializable;
import java.util.Objects;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.settings.Mergeable;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.DeletionPolicy;
import org.apache.activemq.artemis.core.settings.impl.PageFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerThresholdMeasurementUnit;
import org.apache.activemq.artemis.utils.BufferHelper;
import org.apache.activemq.artemis.utils.bean.MetaBean;

public class AddressSettings
implements Mergeable<AddressSettings>,
Serializable,
EncodingSupport {
    static MetaBean<AddressSettings> metaBean = new MetaBean();
    private static final long serialVersionUID = 1607502280582336366L;
    public static final long DEFAULT_MAX_SIZE_BYTES = -1L;
    public static final long DEFAULT_MAX_SIZE_MESSAGES = -1L;
    public static final int DEFAULT_MAX_READ_PAGE_MESSAGES = -1;
    public static final AddressFullMessagePolicy DEFAULT_ADDRESS_FULL_MESSAGE_POLICY = AddressFullMessagePolicy.PAGE;
    public static final int DEFAULT_PAGE_SIZE = 0xA00000;
    public static final int DEFAULT_MAX_DELIVERY_ATTEMPTS = 10;
    public static final int DEFAULT_PAGE_MAX_CACHE = 5;
    public static final int DEFAULT_MESSAGE_COUNTER_HISTORY_DAY_LIMIT = 0;
    public static final long DEFAULT_REDELIVER_DELAY = 0L;
    public static final double DEFAULT_REDELIVER_MULTIPLIER = 1.0;
    public static final double DEFAULT_REDELIVER_COLLISION_AVOIDANCE_FACTOR = 0.0;
    public static final boolean DEFAULT_LAST_VALUE_QUEUE = false;
    @Deprecated
    public static final boolean DEFAULT_AUTO_CREATE_JMS_QUEUES = true;
    @Deprecated
    public static final boolean DEFAULT_AUTO_DELETE_JMS_QUEUES = true;
    @Deprecated
    public static final boolean DEFAULT_AUTO_CREATE_TOPICS = true;
    @Deprecated
    public static final boolean DEFAULT_AUTO_DELETE_TOPICS = true;
    public static final boolean DEFAULT_AUTO_CREATE_QUEUES = true;
    public static final boolean DEFAULT_AUTO_DELETE_QUEUES = true;
    public static final boolean DEFAULT_AUTO_DELETE_CREATED_QUEUES = false;
    public static final long DEFAULT_AUTO_DELETE_QUEUES_DELAY = 0L;
    public static final boolean DEFAULT_AUTO_DELETE_QUEUES_SKIP_USAGE_CHECK = false;
    public static final long DEFAULT_AUTO_DELETE_QUEUES_MESSAGE_COUNT = 0L;
    public static final DeletionPolicy DEFAULT_CONFIG_DELETE_QUEUES = DeletionPolicy.OFF;
    public static final boolean DEFAULT_AUTO_CREATE_ADDRESSES = true;
    public static final boolean DEFAULT_AUTO_DELETE_ADDRESSES = true;
    public static final long DEFAULT_AUTO_DELETE_ADDRESSES_DELAY = 0L;
    public static final boolean DEFAULT_AUTO_DELETE_ADDRESSES_SKIP_USAGE_CHECK = false;
    public static final DeletionPolicy DEFAULT_CONFIG_DELETE_ADDRESSES = DeletionPolicy.OFF;
    public static final DeletionPolicy DEFAULT_CONFIG_DELETE_DIVERTS = DeletionPolicy.OFF;
    public static final long DEFAULT_REDISTRIBUTION_DELAY = -1L;
    public static final boolean DEFAULT_AUTO_CREATE_EXPIRY_RESOURCES = false;
    public static final SimpleString DEFAULT_EXPIRY_QUEUE_PREFIX = SimpleString.of((String)"EXP.");
    public static final SimpleString DEFAULT_EXPIRY_QUEUE_SUFFIX = SimpleString.of((String)"");
    public static final long DEFAULT_EXPIRY_DELAY = -1L;
    public static final long DEFAULT_MIN_EXPIRY_DELAY = -1L;
    public static final long DEFAULT_MAX_EXPIRY_DELAY = -1L;
    public static final boolean DEFAULT_NO_EXPIRY = false;
    public static final boolean DEFAULT_SEND_TO_DLA_ON_NO_ROUTE = false;
    public static final long DEFAULT_SLOW_CONSUMER_THRESHOLD = -1L;
    public static final long DEFAULT_SLOW_CONSUMER_CHECK_PERIOD = 5L;
    public static final int MANAGEMENT_BROWSE_PAGE_SIZE = 200;
    public static final SlowConsumerPolicy DEFAULT_SLOW_CONSUMER_POLICY = SlowConsumerPolicy.NOTIFY;
    public static final int DEFAULT_QUEUE_PREFETCH = 1000;
    public static final long DEFAULT_ADDRESS_REJECT_THRESHOLD = -1L;
    public static final boolean DEFAULT_AUTO_CREATE_DEAD_LETTER_RESOURCES = false;
    public static final SimpleString DEFAULT_DEAD_LETTER_QUEUE_PREFIX = SimpleString.of((String)"DLQ.");
    public static final SimpleString DEFAULT_DEAD_LETTER_QUEUE_SUFFIX = SimpleString.of((String)"");
    public static final boolean DEFAULT_ENABLE_METRICS = true;
    public static final int MANAGEMENT_MESSAGE_ATTRIBUTE_SIZE_LIMIT = 256;
    public static final SlowConsumerThresholdMeasurementUnit DEFAULT_SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT = SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_SECOND;
    public static final boolean DEFAULT_ENABLE_INGRESS_TIMESTAMP = false;
    private AddressFullMessagePolicy addressFullMessagePolicy = null;
    private Long maxSizeBytes = null;
    private Integer maxReadPageBytes = null;
    private Integer maxReadPageMessages = null;
    private Integer prefetchPageBytes = null;
    private Integer prefetchPageMessages = null;
    private Long pageLimitBytes = null;
    private Long pageLimitMessages = null;
    private PageFullMessagePolicy pageFullMessagePolicy = null;
    private Long maxSizeMessages = null;
    private Integer pageSizeBytes = null;
    private Integer pageCacheMaxSize = null;
    private Boolean dropMessagesWhenFull = null;
    private Integer maxDeliveryAttempts = null;
    private Integer messageCounterHistoryDayLimit = null;
    private Long redeliveryDelay = null;
    private Double redeliveryMultiplier = null;
    private Double redeliveryCollisionAvoidanceFactor = null;
    private Long maxRedeliveryDelay = null;
    private SimpleString deadLetterAddress = null;
    private SimpleString expiryAddress = null;
    private Long expiryDelay = null;
    private Long minExpiryDelay = null;
    private Long maxExpiryDelay = null;
    private Boolean noExpiry = null;
    private Boolean defaultLastValueQueue = null;
    private SimpleString defaultLastValueKey = null;
    private Boolean defaultNonDestructive = null;
    private Boolean defaultExclusiveQueue = null;
    private Boolean defaultGroupRebalance = null;
    private Boolean defaultGroupRebalancePauseDispatch = null;
    private Integer defaultGroupBuckets = null;
    private SimpleString defaultGroupFirstKey = null;
    private Long redistributionDelay = null;
    private Boolean sendToDLAOnNoRoute = null;
    private Long slowConsumerThreshold = null;
    private SlowConsumerThresholdMeasurementUnit slowConsumerThresholdMeasurementUnit = DEFAULT_SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT;
    private Long slowConsumerCheckPeriod = null;
    private SlowConsumerPolicy slowConsumerPolicy = null;
    @Deprecated
    private Boolean autoCreateJmsQueues = null;
    @Deprecated
    private Boolean autoDeleteJmsQueues = null;
    @Deprecated
    private Boolean autoCreateJmsTopics = null;
    @Deprecated
    private Boolean autoDeleteJmsTopics = null;
    private Boolean autoCreateQueues = null;
    private Boolean autoDeleteQueues = null;
    private Boolean autoDeleteCreatedQueues = null;
    private Long autoDeleteQueuesDelay = null;
    private Boolean autoDeleteQueuesSkipUsageCheck = null;
    private Long autoDeleteQueuesMessageCount = null;
    private Long defaultRingSize = null;
    private Long retroactiveMessageCount = null;
    private DeletionPolicy configDeleteQueues = null;
    private Boolean autoCreateAddresses = null;
    private Boolean autoDeleteAddresses = null;
    private Long autoDeleteAddressesDelay = null;
    private Boolean autoDeleteAddressesSkipUsageCheck = null;
    private DeletionPolicy configDeleteAddresses = null;
    private DeletionPolicy configDeleteDiverts = null;
    private Integer managementBrowsePageSize = 200;
    private Long maxSizeBytesRejectThreshold = null;
    private Integer defaultMaxConsumers = null;
    private Boolean defaultPurgeOnNoConsumers = null;
    private Integer defaultConsumersBeforeDispatch = null;
    private Long defaultDelayBeforeDispatch = null;
    private RoutingType defaultQueueRoutingType = null;
    private RoutingType defaultAddressRoutingType = null;
    private Integer defaultConsumerWindowSize = null;
    private Boolean autoCreateDeadLetterResources = null;
    private SimpleString deadLetterQueuePrefix = null;
    private SimpleString deadLetterQueueSuffix = null;
    private Boolean autoCreateExpiryResources = null;
    private SimpleString expiryQueuePrefix = null;
    private SimpleString expiryQueueSuffix = null;
    private Boolean enableMetrics = null;
    private Integer managementMessageAttributeSizeLimit = null;
    private Boolean enableIngressTimestamp = null;
    private Integer idCacheSize = null;
    private Integer initialQueueBufferSize = null;
    @Deprecated
    private transient Integer queuePrefetch = null;

    public AddressSettings(AddressSettings other) {
        metaBean.copy((Object)other, (Object)this);
    }

    public AddressSettings() {
    }

    @Deprecated
    public boolean isAutoCreateJmsQueues() {
        return Objects.requireNonNullElse(this.autoCreateJmsQueues, true);
    }

    public String toJSON() {
        return metaBean.toJSON((Object)this, true).toString();
    }

    public static AddressSettings fromJSON(String jsonString) {
        AddressSettings newSettings = new AddressSettings();
        metaBean.fromJSON((Object)newSettings, jsonString);
        return newSettings;
    }

    @Deprecated
    public AddressSettings setAutoCreateJmsQueues(boolean autoCreateJmsQueues) {
        this.autoCreateJmsQueues = autoCreateJmsQueues;
        return this;
    }

    @Deprecated
    public boolean isAutoDeleteJmsQueues() {
        return Objects.requireNonNullElse(this.autoDeleteJmsQueues, true);
    }

    @Deprecated
    public AddressSettings setAutoDeleteJmsQueues(boolean autoDeleteJmsQueues) {
        this.autoDeleteJmsQueues = autoDeleteJmsQueues;
        return this;
    }

    @Deprecated
    public boolean isAutoCreateJmsTopics() {
        return Objects.requireNonNullElse(this.autoCreateJmsTopics, true);
    }

    @Deprecated
    public AddressSettings setAutoCreateJmsTopics(boolean autoCreateJmsTopics) {
        this.autoCreateJmsTopics = autoCreateJmsTopics;
        return this;
    }

    @Deprecated
    public boolean isAutoDeleteJmsTopics() {
        return Objects.requireNonNullElse(this.autoDeleteJmsTopics, true);
    }

    @Deprecated
    public AddressSettings setAutoDeleteJmsTopics(boolean autoDeleteJmsTopics) {
        this.autoDeleteJmsTopics = autoDeleteJmsTopics;
        return this;
    }

    public Boolean isAutoCreateQueues() {
        return Objects.requireNonNullElse(this.autoCreateQueues, true);
    }

    public AddressSettings setAutoCreateQueues(Boolean autoCreateQueues) {
        this.autoCreateQueues = autoCreateQueues;
        return this;
    }

    public Boolean isAutoDeleteQueues() {
        return Objects.requireNonNullElse(this.autoDeleteQueues, true);
    }

    public AddressSettings setAutoDeleteQueues(Boolean autoDeleteQueues) {
        this.autoDeleteQueues = autoDeleteQueues;
        return this;
    }

    public AddressSettings setAutoDeleteCreatedQueues(Boolean autoDeleteCreatedQueues) {
        this.autoDeleteCreatedQueues = autoDeleteCreatedQueues;
        return this;
    }

    public Boolean isAutoDeleteCreatedQueues() {
        return Objects.requireNonNullElse(this.autoDeleteCreatedQueues, false);
    }

    public long getAutoDeleteQueuesDelay() {
        return Objects.requireNonNullElse(this.autoDeleteQueuesDelay, 0L);
    }

    public AddressSettings setAutoDeleteQueuesDelay(long autoDeleteQueuesDelay) {
        this.autoDeleteQueuesDelay = autoDeleteQueuesDelay;
        return this;
    }

    public boolean getAutoDeleteQueuesSkipUsageCheck() {
        return Objects.requireNonNullElse(this.autoDeleteQueuesSkipUsageCheck, false);
    }

    public AddressSettings setAutoDeleteQueuesSkipUsageCheck(boolean autoDeleteQueuesSkipUsageCheck) {
        this.autoDeleteQueuesSkipUsageCheck = autoDeleteQueuesSkipUsageCheck;
        return this;
    }

    public long getAutoDeleteQueuesMessageCount() {
        return Objects.requireNonNullElse(this.autoDeleteQueuesMessageCount, 0L);
    }

    public AddressSettings setAutoDeleteQueuesMessageCount(long autoDeleteQueuesMessageCount) {
        this.autoDeleteQueuesMessageCount = autoDeleteQueuesMessageCount;
        return this;
    }

    public DeletionPolicy getConfigDeleteQueues() {
        return Objects.requireNonNullElse(this.configDeleteQueues, DEFAULT_CONFIG_DELETE_QUEUES);
    }

    public AddressSettings setConfigDeleteQueues(DeletionPolicy configDeleteQueues) {
        this.configDeleteQueues = configDeleteQueues;
        return this;
    }

    public Boolean isAutoCreateAddresses() {
        return Objects.requireNonNullElse(this.autoCreateAddresses, true);
    }

    public AddressSettings setAutoCreateAddresses(Boolean autoCreateAddresses) {
        this.autoCreateAddresses = autoCreateAddresses;
        return this;
    }

    public Boolean isAutoDeleteAddresses() {
        return Objects.requireNonNullElse(this.autoDeleteAddresses, true);
    }

    public AddressSettings setAutoDeleteAddresses(Boolean autoDeleteAddresses) {
        this.autoDeleteAddresses = autoDeleteAddresses;
        return this;
    }

    public long getAutoDeleteAddressesDelay() {
        return Objects.requireNonNullElse(this.autoDeleteAddressesDelay, 0L);
    }

    public AddressSettings setAutoDeleteAddressesDelay(long autoDeleteAddressesDelay) {
        this.autoDeleteAddressesDelay = autoDeleteAddressesDelay;
        return this;
    }

    public boolean isAutoDeleteAddressesSkipUsageCheck() {
        return Objects.requireNonNullElse(this.autoDeleteAddressesSkipUsageCheck, false);
    }

    public AddressSettings setAutoDeleteAddressesSkipUsageCheck(boolean autoDeleteAddressesSkipUsageCheck) {
        this.autoDeleteAddressesSkipUsageCheck = autoDeleteAddressesSkipUsageCheck;
        return this;
    }

    public DeletionPolicy getConfigDeleteAddresses() {
        return Objects.requireNonNullElse(this.configDeleteAddresses, DEFAULT_CONFIG_DELETE_ADDRESSES);
    }

    public AddressSettings setConfigDeleteAddresses(DeletionPolicy configDeleteAddresses) {
        this.configDeleteAddresses = configDeleteAddresses;
        return this;
    }

    public AddressSettings setConfigDeleteDiverts(DeletionPolicy configDeleteDiverts) {
        this.configDeleteDiverts = configDeleteDiverts;
        return this;
    }

    public DeletionPolicy getConfigDeleteDiverts() {
        return Objects.requireNonNullElse(this.configDeleteDiverts, DEFAULT_CONFIG_DELETE_DIVERTS);
    }

    public Integer getDefaultMaxConsumers() {
        return Objects.requireNonNullElse(this.defaultMaxConsumers, ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers());
    }

    public AddressSettings setDefaultMaxConsumers(Integer defaultMaxConsumers) {
        this.defaultMaxConsumers = defaultMaxConsumers;
        return this;
    }

    public Integer getDefaultConsumersBeforeDispatch() {
        return Objects.requireNonNullElse(this.defaultConsumersBeforeDispatch, ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch());
    }

    public AddressSettings setDefaultConsumersBeforeDispatch(Integer defaultConsumersBeforeDispatch) {
        this.defaultConsumersBeforeDispatch = defaultConsumersBeforeDispatch;
        return this;
    }

    public Long getDefaultDelayBeforeDispatch() {
        return Objects.requireNonNullElse(this.defaultDelayBeforeDispatch, ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch());
    }

    public AddressSettings setDefaultDelayBeforeDispatch(Long defaultDelayBeforeDispatch) {
        this.defaultDelayBeforeDispatch = defaultDelayBeforeDispatch;
        return this;
    }

    public Boolean isDefaultPurgeOnNoConsumers() {
        return Objects.requireNonNullElse(this.defaultPurgeOnNoConsumers, ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers());
    }

    public AddressSettings setDefaultPurgeOnNoConsumers(Boolean defaultPurgeOnNoConsumers) {
        this.defaultPurgeOnNoConsumers = defaultPurgeOnNoConsumers;
        return this;
    }

    public RoutingType getDefaultQueueRoutingType() {
        return Objects.requireNonNullElse(this.defaultQueueRoutingType, ActiveMQDefaultConfiguration.getDefaultRoutingType());
    }

    public AddressSettings setDefaultQueueRoutingType(RoutingType defaultQueueRoutingType) {
        this.defaultQueueRoutingType = defaultQueueRoutingType;
        return this;
    }

    public RoutingType getDefaultAddressRoutingType() {
        return Objects.requireNonNullElse(this.defaultAddressRoutingType, ActiveMQDefaultConfiguration.getDefaultRoutingType());
    }

    public AddressSettings setDefaultAddressRoutingType(RoutingType defaultAddressRoutingType) {
        this.defaultAddressRoutingType = defaultAddressRoutingType;
        return this;
    }

    public boolean isDefaultLastValueQueue() {
        return Objects.requireNonNullElse(this.defaultLastValueQueue, false);
    }

    public AddressSettings setDefaultLastValueQueue(boolean defaultLastValueQueue) {
        this.defaultLastValueQueue = defaultLastValueQueue;
        return this;
    }

    public SimpleString getDefaultLastValueKey() {
        return this.defaultLastValueKey != null ? this.defaultLastValueKey : ActiveMQDefaultConfiguration.getDefaultLastValueKey();
    }

    public AddressSettings setDefaultLastValueKey(SimpleString defaultLastValueKey) {
        this.defaultLastValueKey = defaultLastValueKey;
        return this;
    }

    public boolean isDefaultNonDestructive() {
        return Objects.requireNonNullElse(this.defaultNonDestructive, ActiveMQDefaultConfiguration.getDefaultNonDestructive());
    }

    public AddressSettings setDefaultNonDestructive(boolean defaultNonDestructive) {
        this.defaultNonDestructive = defaultNonDestructive;
        return this;
    }

    public Boolean isDefaultExclusiveQueue() {
        return Objects.requireNonNullElse(this.defaultExclusiveQueue, ActiveMQDefaultConfiguration.getDefaultExclusive());
    }

    public AddressSettings setDefaultExclusiveQueue(Boolean defaultExclusiveQueue) {
        this.defaultExclusiveQueue = defaultExclusiveQueue;
        return this;
    }

    public AddressFullMessagePolicy getAddressFullMessagePolicy() {
        return Objects.requireNonNullElse(this.addressFullMessagePolicy, DEFAULT_ADDRESS_FULL_MESSAGE_POLICY);
    }

    public AddressSettings setAddressFullMessagePolicy(AddressFullMessagePolicy addressFullMessagePolicy) {
        this.addressFullMessagePolicy = addressFullMessagePolicy;
        return this;
    }

    public int getPageSizeBytes() {
        return Objects.requireNonNullElse(this.pageSizeBytes, 0xA00000);
    }

    public AddressSettings setPageSizeBytes(int pageSize) {
        this.pageSizeBytes = this.testForNull(pageSize);
        return this;
    }

    public int getPageCacheMaxSize() {
        return Objects.requireNonNullElse(this.pageCacheMaxSize, 5);
    }

    public AddressSettings setPageCacheMaxSize(int pageCacheMaxSize) {
        this.pageCacheMaxSize = pageCacheMaxSize;
        return this;
    }

    public long getMaxSizeBytes() {
        return Objects.requireNonNullElse(this.maxSizeBytes, -1L);
    }

    public long getMaxSizeMessages() {
        return Objects.requireNonNullElse(this.maxSizeMessages, -1L);
    }

    private Integer testForNull(int value) {
        return value < 0 ? null : Integer.valueOf(value);
    }

    public AddressSettings setMaxSizeMessages(long maxSizeMessages) {
        this.maxSizeMessages = maxSizeMessages;
        return this;
    }

    public AddressSettings setMaxSizeBytes(long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public int getMaxReadPageMessages() {
        return Objects.requireNonNullElse(this.maxReadPageMessages, -1);
    }

    public AddressSettings setMaxReadPageMessages(int maxReadPageMessages) {
        this.maxReadPageMessages = maxReadPageMessages;
        return this;
    }

    public int getPrefetchPageMessages() {
        return Objects.requireNonNullElse(this.prefetchPageMessages, this.getMaxReadPageMessages());
    }

    public AddressSettings setPrefetchPageMessages(int prefetchPageMessages) {
        this.prefetchPageMessages = prefetchPageMessages <= 0 ? null : Integer.valueOf(prefetchPageMessages);
        return this;
    }

    public Long getPageLimitBytes() {
        return this.pageLimitBytes;
    }

    public AddressSettings setPageLimitBytes(Long pageLimitBytes) {
        this.pageLimitBytes = pageLimitBytes;
        return this;
    }

    public Long getPageLimitMessages() {
        return this.pageLimitMessages;
    }

    public AddressSettings setPageLimitMessages(Long pageLimitMessages) {
        this.pageLimitMessages = pageLimitMessages;
        return this;
    }

    public PageFullMessagePolicy getPageFullMessagePolicy() {
        return this.pageFullMessagePolicy;
    }

    public AddressSettings setPageFullMessagePolicy(PageFullMessagePolicy policy) {
        this.pageFullMessagePolicy = policy;
        return this;
    }

    public int getMaxReadPageBytes() {
        return Objects.requireNonNullElse(this.maxReadPageBytes, 2 * this.getPageSizeBytes());
    }

    public AddressSettings setMaxReadPageBytes(int maxReadPageBytes) {
        this.maxReadPageBytes = maxReadPageBytes;
        return this;
    }

    public int getPrefetchPageBytes() {
        return Objects.requireNonNullElse(this.prefetchPageBytes, this.getMaxReadPageBytes());
    }

    public AddressSettings setPrefetchPageBytes(int prefetchPageBytes) {
        this.prefetchPageBytes = prefetchPageBytes <= 0 ? null : Integer.valueOf(prefetchPageBytes);
        return this;
    }

    public int getMaxDeliveryAttempts() {
        return Objects.requireNonNullElse(this.maxDeliveryAttempts, 10);
    }

    public AddressSettings setMaxDeliveryAttempts(int maxDeliveryAttempts) {
        this.maxDeliveryAttempts = maxDeliveryAttempts;
        return this;
    }

    public int getMessageCounterHistoryDayLimit() {
        return Objects.requireNonNullElse(this.messageCounterHistoryDayLimit, 0);
    }

    public AddressSettings setMessageCounterHistoryDayLimit(int messageCounterHistoryDayLimit) {
        this.messageCounterHistoryDayLimit = messageCounterHistoryDayLimit;
        return this;
    }

    public long getRedeliveryDelay() {
        return Objects.requireNonNullElse(this.redeliveryDelay, 0L);
    }

    public AddressSettings setRedeliveryDelay(long redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
        return this;
    }

    public double getRedeliveryMultiplier() {
        return Objects.requireNonNullElse(this.redeliveryMultiplier, 1.0);
    }

    public AddressSettings setRedeliveryMultiplier(double redeliveryMultiplier) {
        this.redeliveryMultiplier = redeliveryMultiplier;
        return this;
    }

    public double getRedeliveryCollisionAvoidanceFactor() {
        return Objects.requireNonNullElse(this.redeliveryCollisionAvoidanceFactor, 0.0);
    }

    public AddressSettings setRedeliveryCollisionAvoidanceFactor(double redeliveryCollisionAvoidanceFactor) {
        this.redeliveryCollisionAvoidanceFactor = redeliveryCollisionAvoidanceFactor;
        return this;
    }

    public long getMaxRedeliveryDelay() {
        return Objects.requireNonNullElse(this.maxRedeliveryDelay, this.getRedeliveryDelay() * 10L);
    }

    public AddressSettings setMaxRedeliveryDelay(long maxRedeliveryDelay) {
        this.maxRedeliveryDelay = maxRedeliveryDelay;
        return this;
    }

    public SimpleString getDeadLetterAddress() {
        return this.deadLetterAddress;
    }

    public AddressSettings setDeadLetterAddress(SimpleString deadLetterAddress) {
        this.deadLetterAddress = deadLetterAddress;
        return this;
    }

    public SimpleString getExpiryAddress() {
        return this.expiryAddress;
    }

    public AddressSettings setExpiryAddress(SimpleString expiryAddress) {
        this.expiryAddress = expiryAddress;
        return this;
    }

    public boolean isAutoCreateExpiryResources() {
        return Objects.requireNonNullElse(this.autoCreateExpiryResources, false);
    }

    public AddressSettings setAutoCreateExpiryResources(boolean value) {
        this.autoCreateExpiryResources = value;
        return this;
    }

    public SimpleString getExpiryQueuePrefix() {
        return Objects.requireNonNullElse(this.expiryQueuePrefix, DEFAULT_EXPIRY_QUEUE_PREFIX);
    }

    public AddressSettings setExpiryQueuePrefix(SimpleString value) {
        this.expiryQueuePrefix = value;
        return this;
    }

    public SimpleString getExpiryQueueSuffix() {
        return Objects.requireNonNullElse(this.expiryQueueSuffix, DEFAULT_EXPIRY_QUEUE_SUFFIX);
    }

    public AddressSettings setExpiryQueueSuffix(SimpleString value) {
        this.expiryQueueSuffix = value;
        return this;
    }

    public Long getExpiryDelay() {
        return Objects.requireNonNullElse(this.expiryDelay, -1L);
    }

    public AddressSettings setExpiryDelay(Long expiryDelay) {
        this.expiryDelay = expiryDelay;
        return this;
    }

    public Long getMinExpiryDelay() {
        return Objects.requireNonNullElse(this.minExpiryDelay, -1L);
    }

    public AddressSettings setMinExpiryDelay(Long minExpiryDelay) {
        this.minExpiryDelay = minExpiryDelay;
        return this;
    }

    public Long getMaxExpiryDelay() {
        return Objects.requireNonNullElse(this.maxExpiryDelay, -1L);
    }

    public AddressSettings setMaxExpiryDelay(Long maxExpiryDelay) {
        this.maxExpiryDelay = maxExpiryDelay;
        return this;
    }

    public Boolean isNoExpiry() {
        return Objects.requireNonNullElse(this.noExpiry, false);
    }

    public AddressSettings setNoExpiry(Boolean noExpiry) {
        this.noExpiry = noExpiry;
        return this;
    }

    public boolean isSendToDLAOnNoRoute() {
        return Objects.requireNonNullElse(this.sendToDLAOnNoRoute, false);
    }

    public AddressSettings setSendToDLAOnNoRoute(boolean value) {
        this.sendToDLAOnNoRoute = value;
        return this;
    }

    public boolean isAutoCreateDeadLetterResources() {
        return Objects.requireNonNullElse(this.autoCreateDeadLetterResources, false);
    }

    public AddressSettings setAutoCreateDeadLetterResources(boolean value) {
        this.autoCreateDeadLetterResources = value;
        return this;
    }

    public SimpleString getDeadLetterQueuePrefix() {
        return Objects.requireNonNullElse(this.deadLetterQueuePrefix, DEFAULT_DEAD_LETTER_QUEUE_PREFIX);
    }

    public AddressSettings setDeadLetterQueuePrefix(SimpleString value) {
        this.deadLetterQueuePrefix = value;
        return this;
    }

    public SimpleString getDeadLetterQueueSuffix() {
        return Objects.requireNonNullElse(this.deadLetterQueueSuffix, DEFAULT_DEAD_LETTER_QUEUE_SUFFIX);
    }

    public AddressSettings setDeadLetterQueueSuffix(SimpleString value) {
        this.deadLetterQueueSuffix = value;
        return this;
    }

    public long getRedistributionDelay() {
        return Objects.requireNonNullElse(this.redistributionDelay, -1L);
    }

    public AddressSettings setRedistributionDelay(long redistributionDelay) {
        this.redistributionDelay = redistributionDelay;
        return this;
    }

    public long getSlowConsumerThreshold() {
        return Objects.requireNonNullElse(this.slowConsumerThreshold, -1L);
    }

    public AddressSettings setSlowConsumerThreshold(long slowConsumerThreshold) {
        this.slowConsumerThreshold = slowConsumerThreshold;
        return this;
    }

    public SlowConsumerThresholdMeasurementUnit getSlowConsumerThresholdMeasurementUnit() {
        return Objects.requireNonNullElse(this.slowConsumerThresholdMeasurementUnit, DEFAULT_SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT);
    }

    public AddressSettings setSlowConsumerThresholdMeasurementUnit(SlowConsumerThresholdMeasurementUnit slowConsumerThresholdMeasurementUnit) {
        this.slowConsumerThresholdMeasurementUnit = slowConsumerThresholdMeasurementUnit;
        return this;
    }

    public long getSlowConsumerCheckPeriod() {
        return Objects.requireNonNullElse(this.slowConsumerCheckPeriod, 5L);
    }

    public AddressSettings setSlowConsumerCheckPeriod(long slowConsumerCheckPeriod) {
        this.slowConsumerCheckPeriod = slowConsumerCheckPeriod;
        return this;
    }

    public SlowConsumerPolicy getSlowConsumerPolicy() {
        return Objects.requireNonNullElse(this.slowConsumerPolicy, DEFAULT_SLOW_CONSUMER_POLICY);
    }

    public AddressSettings setSlowConsumerPolicy(SlowConsumerPolicy slowConsumerPolicy) {
        this.slowConsumerPolicy = slowConsumerPolicy;
        return this;
    }

    public int getManagementBrowsePageSize() {
        return Objects.requireNonNullElse(this.managementBrowsePageSize, 200);
    }

    public AddressSettings setManagementBrowsePageSize(int managementBrowsePageSize) {
        this.managementBrowsePageSize = managementBrowsePageSize;
        return this;
    }

    @Deprecated
    public int getQueuePrefetch() {
        return Objects.requireNonNullElse(this.queuePrefetch, 1000);
    }

    @Deprecated
    public AddressSettings setQueuePrefetch(int queuePrefetch) {
        this.queuePrefetch = queuePrefetch;
        return this;
    }

    public long getMaxSizeBytesRejectThreshold() {
        return this.maxSizeBytesRejectThreshold == null ? -1L : this.maxSizeBytesRejectThreshold;
    }

    public AddressSettings setMaxSizeBytesRejectThreshold(long maxSizeBytesRejectThreshold) {
        this.maxSizeBytesRejectThreshold = maxSizeBytesRejectThreshold;
        return this;
    }

    public int getDefaultConsumerWindowSize() {
        return Objects.requireNonNullElse(this.defaultConsumerWindowSize, 0x100000);
    }

    public AddressSettings setDefaultConsumerWindowSize(int defaultConsumerWindowSize) {
        this.defaultConsumerWindowSize = defaultConsumerWindowSize;
        return this;
    }

    public boolean isDefaultGroupRebalance() {
        return Objects.requireNonNullElse(this.defaultGroupRebalance, ActiveMQDefaultConfiguration.getDefaultGroupRebalance());
    }

    public AddressSettings setDefaultGroupRebalance(boolean defaultGroupRebalance) {
        this.defaultGroupRebalance = defaultGroupRebalance;
        return this;
    }

    public boolean isDefaultGroupRebalancePauseDispatch() {
        return Objects.requireNonNullElse(this.defaultGroupRebalancePauseDispatch, ActiveMQDefaultConfiguration.getDefaultGroupRebalancePauseDispatch());
    }

    public AddressSettings setDefaultGroupRebalancePauseDispatch(boolean defaultGroupRebalancePauseDispatch) {
        this.defaultGroupRebalancePauseDispatch = defaultGroupRebalancePauseDispatch;
        return this;
    }

    public int getDefaultGroupBuckets() {
        return Objects.requireNonNullElse(this.defaultGroupBuckets, ActiveMQDefaultConfiguration.getDefaultGroupBuckets());
    }

    public SimpleString getDefaultGroupFirstKey() {
        return this.defaultGroupFirstKey != null ? this.defaultGroupFirstKey : ActiveMQDefaultConfiguration.getDefaultGroupFirstKey();
    }

    public AddressSettings setDefaultGroupFirstKey(SimpleString defaultGroupFirstKey) {
        this.defaultGroupFirstKey = defaultGroupFirstKey;
        return this;
    }

    public AddressSettings setDefaultGroupBuckets(int defaultGroupBuckets) {
        this.defaultGroupBuckets = defaultGroupBuckets;
        return this;
    }

    public long getDefaultRingSize() {
        return Objects.requireNonNullElse(this.defaultRingSize, -1L);
    }

    public AddressSettings setDefaultRingSize(long defaultRingSize) {
        this.defaultRingSize = defaultRingSize;
        return this;
    }

    public long getRetroactiveMessageCount() {
        return Objects.requireNonNullElse(this.retroactiveMessageCount, 0L);
    }

    public AddressSettings setRetroactiveMessageCount(long defaultRetroactiveMessageCount) {
        this.retroactiveMessageCount = defaultRetroactiveMessageCount;
        return this;
    }

    public boolean isEnableMetrics() {
        return Objects.requireNonNullElse(this.enableMetrics, true);
    }

    public AddressSettings setEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
        return this;
    }

    public int getManagementMessageAttributeSizeLimit() {
        return Objects.requireNonNullElse(this.managementMessageAttributeSizeLimit, 256);
    }

    public AddressSettings setManagementMessageAttributeSizeLimit(int managementMessageAttributeSizeLimit) {
        this.managementMessageAttributeSizeLimit = managementMessageAttributeSizeLimit;
        return this;
    }

    public boolean isEnableIngressTimestamp() {
        return Objects.requireNonNullElse(this.enableIngressTimestamp, false);
    }

    public AddressSettings setEnableIngressTimestamp(boolean enableIngressTimestamp) {
        this.enableIngressTimestamp = enableIngressTimestamp;
        return this;
    }

    public Integer getIDCacheSize() {
        return this.idCacheSize;
    }

    public AddressSettings setIDCacheSize(Integer idCacheSize) {
        this.idCacheSize = idCacheSize;
        return this;
    }

    public Integer getInitialQueueBufferSize() {
        return this.initialQueueBufferSize;
    }

    public AddressSettings setInitialQueueBufferSize(Integer initialQueueBufferSize) {
        this.initialQueueBufferSize = initialQueueBufferSize;
        return this;
    }

    @Override
    public void merge(AddressSettings merged) {
        metaBean.forEach((type, name, setter, getter, gate) -> {
            if (getter.apply(this) == null) {
                setter.accept(this, getter.apply(merged));
            }
        });
    }

    @Override
    public AddressSettings mergeCopy(AddressSettings merged) {
        AddressSettings target = new AddressSettings();
        metaBean.forEach((type, name, setter, getter, gate) -> {
            Object sourceValue = getter.apply(this);
            if (sourceValue != null) {
                setter.accept(target, sourceValue);
            } else {
                setter.accept(target, getter.apply(merged));
            }
        });
        return target;
    }

    public void decode(ActiveMQBuffer buffer) {
        int original = buffer.readerIndex();
        try {
            this.decode(buffer, false);
        }
        catch (Throwable e) {
            buffer.readerIndex(original);
            this.decode(buffer, true);
        }
    }

    public void decode(ActiveMQBuffer buffer, boolean tryCompatible) {
        Integer slowConsumerMeasurementUnitEnumValue;
        SimpleString policyStr = buffer.readNullableSimpleString();
        this.addressFullMessagePolicy = policyStr != null ? AddressFullMessagePolicy.valueOf((String)policyStr.toString()) : null;
        this.maxSizeBytes = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        Long pageSizeLong = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.pageSizeBytes = pageSizeLong == null ? null : Integer.valueOf(pageSizeLong.intValue());
        this.pageCacheMaxSize = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.dropMessagesWhenFull = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.maxDeliveryAttempts = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.messageCounterHistoryDayLimit = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.redeliveryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.redeliveryMultiplier = BufferHelper.readNullableDouble((ActiveMQBuffer)buffer);
        this.maxRedeliveryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.deadLetterAddress = buffer.readNullableSimpleString();
        this.expiryAddress = buffer.readNullableSimpleString();
        this.expiryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.defaultLastValueQueue = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.redistributionDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.sendToDLAOnNoRoute = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.slowConsumerThreshold = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.slowConsumerCheckPeriod = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        policyStr = buffer.readNullableSimpleString();
        this.slowConsumerPolicy = policyStr != null ? SlowConsumerPolicy.valueOf(policyStr.toString()) : null;
        this.autoCreateJmsQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoDeleteJmsQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoCreateJmsTopics = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoDeleteJmsTopics = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoCreateQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoDeleteQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        policyStr = tryCompatible ? null : buffer.readNullableSimpleString();
        this.configDeleteQueues = policyStr != null ? DeletionPolicy.valueOf(policyStr.toString()) : null;
        this.autoCreateAddresses = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoDeleteAddresses = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        policyStr = tryCompatible ? null : buffer.readNullableSimpleString();
        this.configDeleteAddresses = policyStr != null ? DeletionPolicy.valueOf(policyStr.toString()) : null;
        this.managementBrowsePageSize = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.maxSizeBytesRejectThreshold = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.defaultMaxConsumers = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.defaultPurgeOnNoConsumers = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.defaultQueueRoutingType = RoutingType.getType((byte)buffer.readByte());
        this.defaultAddressRoutingType = RoutingType.getType((byte)buffer.readByte());
        if (buffer.readableBytes() > 0) {
            this.defaultExclusiveQueue = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultConsumersBeforeDispatch = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultDelayBeforeDispatch = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultConsumerWindowSize = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultLastValueKey = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.defaultNonDestructive = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteQueuesDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteAddressesDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultGroupRebalance = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultGroupBuckets = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteQueuesMessageCount = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteCreatedQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultRingSize = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.redeliveryCollisionAvoidanceFactor = BufferHelper.readNullableDouble((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultGroupFirstKey = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.retroactiveMessageCount = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoCreateDeadLetterResources = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.deadLetterQueuePrefix = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.deadLetterQueueSuffix = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.autoCreateExpiryResources = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.expiryQueuePrefix = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.expiryQueueSuffix = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.minExpiryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.maxExpiryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.enableMetrics = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultGroupRebalancePauseDispatch = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.managementMessageAttributeSizeLimit = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0 && (slowConsumerMeasurementUnitEnumValue = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer)) != null) {
            this.slowConsumerThresholdMeasurementUnit = SlowConsumerThresholdMeasurementUnit.valueOf(slowConsumerMeasurementUnitEnumValue);
        }
        if (buffer.readableBytes() > 0) {
            this.enableIngressTimestamp = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            policyStr = tryCompatible ? null : buffer.readNullableSimpleString();
            this.configDeleteDiverts = policyStr != null ? DeletionPolicy.valueOf(policyStr.toString()) : null;
        }
        if (buffer.readableBytes() > 0) {
            this.maxSizeMessages = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.maxReadPageBytes = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.maxReadPageMessages = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.pageLimitBytes = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.pageLimitMessages = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            policyStr = buffer.readNullableSimpleString();
            this.pageFullMessagePolicy = policyStr != null ? PageFullMessagePolicy.valueOf((String)policyStr.toString()) : null;
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteQueuesSkipUsageCheck = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteAddressesSkipUsageCheck = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.idCacheSize = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.prefetchPageBytes = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.prefetchPageMessages = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
    }

    public int getEncodeSize() {
        throw new UnsupportedOperationException("Encode of AddressSettings is no longer supported, please use JSON method and PersistAddressSettingJSON");
    }

    public void encode(ActiveMQBuffer buffer) {
        throw new UnsupportedOperationException("Encode of AddressSettings is no longer supported, please use JSON method and PersistAddressSettingJSON");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AddressSettings)) {
            return false;
        }
        AddressSettings other = (AddressSettings)obj;
        return Objects.equals(this.addressFullMessagePolicy, other.addressFullMessagePolicy) && Objects.equals(this.maxSizeBytes, other.maxSizeBytes) && Objects.equals(this.maxReadPageBytes, other.maxReadPageBytes) && Objects.equals(this.maxReadPageMessages, other.maxReadPageMessages) && Objects.equals(this.prefetchPageBytes, other.prefetchPageBytes) && Objects.equals(this.prefetchPageMessages, other.prefetchPageMessages) && Objects.equals(this.pageLimitBytes, other.pageLimitBytes) && Objects.equals(this.pageLimitMessages, other.pageLimitMessages) && Objects.equals(this.pageFullMessagePolicy, other.pageFullMessagePolicy) && Objects.equals(this.maxSizeMessages, other.maxSizeMessages) && Objects.equals(this.pageSizeBytes, other.pageSizeBytes) && Objects.equals(this.pageCacheMaxSize, other.pageCacheMaxSize) && Objects.equals(this.dropMessagesWhenFull, other.dropMessagesWhenFull) && Objects.equals(this.maxDeliveryAttempts, other.maxDeliveryAttempts) && Objects.equals(this.messageCounterHistoryDayLimit, other.messageCounterHistoryDayLimit) && Objects.equals(this.redeliveryDelay, other.redeliveryDelay) && Objects.equals(this.redeliveryMultiplier, other.redeliveryMultiplier) && Objects.equals(this.redeliveryCollisionAvoidanceFactor, other.redeliveryCollisionAvoidanceFactor) && Objects.equals(this.maxRedeliveryDelay, other.maxRedeliveryDelay) && Objects.equals(this.deadLetterAddress, other.deadLetterAddress) && Objects.equals(this.expiryAddress, other.expiryAddress) && Objects.equals(this.expiryDelay, other.expiryDelay) && Objects.equals(this.minExpiryDelay, other.minExpiryDelay) && Objects.equals(this.maxExpiryDelay, other.maxExpiryDelay) && Objects.equals(this.noExpiry, other.noExpiry) && Objects.equals(this.defaultLastValueQueue, other.defaultLastValueQueue) && Objects.equals(this.defaultLastValueKey, other.defaultLastValueKey) && Objects.equals(this.defaultNonDestructive, other.defaultNonDestructive) && Objects.equals(this.defaultExclusiveQueue, other.defaultExclusiveQueue) && Objects.equals(this.defaultGroupRebalance, other.defaultGroupRebalance) && Objects.equals(this.defaultGroupRebalancePauseDispatch, other.defaultGroupRebalancePauseDispatch) && Objects.equals(this.defaultGroupBuckets, other.defaultGroupBuckets) && Objects.equals(this.defaultGroupFirstKey, other.defaultGroupFirstKey) && Objects.equals(this.redistributionDelay, other.redistributionDelay) && Objects.equals(this.sendToDLAOnNoRoute, other.sendToDLAOnNoRoute) && Objects.equals(this.slowConsumerThreshold, other.slowConsumerThreshold) && Objects.equals((Object)this.slowConsumerThresholdMeasurementUnit, (Object)other.slowConsumerThresholdMeasurementUnit) && Objects.equals(this.slowConsumerCheckPeriod, other.slowConsumerCheckPeriod) && Objects.equals((Object)this.slowConsumerPolicy, (Object)other.slowConsumerPolicy) && Objects.equals(this.autoCreateJmsQueues, other.autoCreateJmsQueues) && Objects.equals(this.autoDeleteJmsQueues, other.autoDeleteJmsQueues) && Objects.equals(this.autoCreateJmsTopics, other.autoCreateJmsTopics) && Objects.equals(this.autoDeleteJmsTopics, other.autoDeleteJmsTopics) && Objects.equals(this.autoCreateQueues, other.autoCreateQueues) && Objects.equals(this.autoDeleteQueues, other.autoDeleteQueues) && Objects.equals(this.autoDeleteCreatedQueues, other.autoDeleteCreatedQueues) && Objects.equals(this.autoDeleteQueuesDelay, other.autoDeleteQueuesDelay) && Objects.equals(this.autoDeleteQueuesSkipUsageCheck, other.autoDeleteQueuesSkipUsageCheck) && Objects.equals(this.autoDeleteQueuesMessageCount, other.autoDeleteQueuesMessageCount) && Objects.equals(this.defaultRingSize, other.defaultRingSize) && Objects.equals(this.retroactiveMessageCount, other.retroactiveMessageCount) && Objects.equals((Object)this.configDeleteQueues, (Object)other.configDeleteQueues) && Objects.equals(this.autoCreateAddresses, other.autoCreateAddresses) && Objects.equals(this.autoDeleteAddresses, other.autoDeleteAddresses) && Objects.equals(this.autoDeleteAddressesDelay, other.autoDeleteAddressesDelay) && Objects.equals(this.autoDeleteAddressesSkipUsageCheck, other.autoDeleteAddressesSkipUsageCheck) && Objects.equals((Object)this.configDeleteAddresses, (Object)other.configDeleteAddresses) && Objects.equals((Object)this.configDeleteDiverts, (Object)other.configDeleteDiverts) && Objects.equals(this.managementBrowsePageSize, other.managementBrowsePageSize) && Objects.equals(this.maxSizeBytesRejectThreshold, other.maxSizeBytesRejectThreshold) && Objects.equals(this.defaultMaxConsumers, other.defaultMaxConsumers) && Objects.equals(this.defaultPurgeOnNoConsumers, other.defaultPurgeOnNoConsumers) && Objects.equals(this.defaultConsumersBeforeDispatch, other.defaultConsumersBeforeDispatch) && Objects.equals(this.defaultDelayBeforeDispatch, other.defaultDelayBeforeDispatch) && Objects.equals(this.defaultQueueRoutingType, other.defaultQueueRoutingType) && Objects.equals(this.defaultAddressRoutingType, other.defaultAddressRoutingType) && Objects.equals(this.defaultConsumerWindowSize, other.defaultConsumerWindowSize) && Objects.equals(this.autoCreateDeadLetterResources, other.autoCreateDeadLetterResources) && Objects.equals(this.deadLetterQueuePrefix, other.deadLetterQueuePrefix) && Objects.equals(this.deadLetterQueueSuffix, other.deadLetterQueueSuffix) && Objects.equals(this.autoCreateExpiryResources, other.autoCreateExpiryResources) && Objects.equals(this.expiryQueuePrefix, other.expiryQueuePrefix) && Objects.equals(this.expiryQueueSuffix, other.expiryQueueSuffix) && Objects.equals(this.enableMetrics, other.enableMetrics) && Objects.equals(this.managementMessageAttributeSizeLimit, other.managementMessageAttributeSizeLimit) && Objects.equals(this.enableIngressTimestamp, other.enableIngressTimestamp) && Objects.equals(this.idCacheSize, other.idCacheSize) && Objects.equals(this.initialQueueBufferSize, other.initialQueueBufferSize) && Objects.equals(this.queuePrefetch, other.queuePrefetch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressFullMessagePolicy, this.maxSizeBytes, this.maxReadPageBytes, this.maxReadPageMessages, this.prefetchPageBytes, this.prefetchPageMessages, this.pageLimitBytes, this.pageLimitMessages, this.pageFullMessagePolicy, this.maxSizeMessages, this.pageSizeBytes, this.pageCacheMaxSize, this.dropMessagesWhenFull, this.maxDeliveryAttempts, this.messageCounterHistoryDayLimit, this.redeliveryDelay, this.redeliveryMultiplier, this.redeliveryCollisionAvoidanceFactor, this.maxRedeliveryDelay, this.deadLetterAddress, this.expiryAddress, this.expiryDelay, this.minExpiryDelay, this.maxExpiryDelay, this.noExpiry, this.defaultLastValueQueue, this.defaultLastValueKey, this.defaultNonDestructive, this.defaultExclusiveQueue, this.defaultGroupRebalance, this.defaultGroupRebalancePauseDispatch, this.defaultGroupBuckets, this.defaultGroupFirstKey, this.redistributionDelay, this.sendToDLAOnNoRoute, this.slowConsumerThreshold, this.slowConsumerThresholdMeasurementUnit, this.slowConsumerCheckPeriod, this.slowConsumerPolicy, this.autoCreateJmsQueues, this.autoDeleteJmsQueues, this.autoCreateJmsTopics, this.autoDeleteJmsTopics, this.autoCreateQueues, this.autoDeleteQueues, this.autoDeleteCreatedQueues, this.autoDeleteQueuesDelay, this.autoDeleteQueuesSkipUsageCheck, this.autoDeleteQueuesMessageCount, this.defaultRingSize, this.retroactiveMessageCount, this.configDeleteQueues, this.autoCreateAddresses, this.autoDeleteAddresses, this.autoDeleteAddressesDelay, this.autoDeleteAddressesSkipUsageCheck, this.configDeleteAddresses, this.configDeleteDiverts, this.managementBrowsePageSize, this.maxSizeBytesRejectThreshold, this.defaultMaxConsumers, this.defaultPurgeOnNoConsumers, this.defaultConsumersBeforeDispatch, this.defaultDelayBeforeDispatch, this.defaultQueueRoutingType, this.defaultAddressRoutingType, this.defaultConsumerWindowSize, this.autoCreateDeadLetterResources, this.deadLetterQueuePrefix, this.deadLetterQueueSuffix, this.autoCreateExpiryResources, this.expiryQueuePrefix, this.expiryQueueSuffix, this.enableMetrics, this.managementMessageAttributeSizeLimit, this.enableIngressTimestamp, this.idCacheSize, this.queuePrefetch, this.initialQueueBufferSize});
    }

    public String toString() {
        return "AddressSettings{addressFullMessagePolicy=" + String.valueOf(this.addressFullMessagePolicy) + ", maxSizeBytes=" + this.maxSizeBytes + ", maxReadPageBytes=" + this.maxReadPageBytes + ", maxReadPageMessages=" + this.maxReadPageMessages + ", prefetchPageBytes=" + this.prefetchPageBytes + ", prefetchPageMessages=" + this.prefetchPageMessages + ", pageLimitBytes=" + this.pageLimitBytes + ", pageLimitMessages=" + this.pageLimitMessages + ", pageFullMessagePolicy=" + String.valueOf(this.pageFullMessagePolicy) + ", maxSizeMessages=" + this.maxSizeMessages + ", pageSizeBytes=" + this.pageSizeBytes + ", pageMaxCache=" + this.pageCacheMaxSize + ", dropMessagesWhenFull=" + this.dropMessagesWhenFull + ", maxDeliveryAttempts=" + this.maxDeliveryAttempts + ", messageCounterHistoryDayLimit=" + this.messageCounterHistoryDayLimit + ", redeliveryDelay=" + this.redeliveryDelay + ", redeliveryMultiplier=" + this.redeliveryMultiplier + ", redeliveryCollisionAvoidanceFactor=" + this.redeliveryCollisionAvoidanceFactor + ", maxRedeliveryDelay=" + this.maxRedeliveryDelay + ", deadLetterAddress=" + String.valueOf(this.deadLetterAddress) + ", expiryAddress=" + String.valueOf(this.expiryAddress) + ", expiryDelay=" + this.expiryDelay + ", minExpiryDelay=" + this.minExpiryDelay + ", maxExpiryDelay=" + this.maxExpiryDelay + ", noExpiry=" + this.noExpiry + ", defaultLastValueQueue=" + this.defaultLastValueQueue + ", defaultLastValueKey=" + String.valueOf(this.defaultLastValueKey) + ", defaultNonDestructive=" + this.defaultNonDestructive + ", defaultExclusiveQueue=" + this.defaultExclusiveQueue + ", defaultGroupRebalance=" + this.defaultGroupRebalance + ", defaultGroupRebalancePauseDispatch=" + this.defaultGroupRebalancePauseDispatch + ", defaultGroupBuckets=" + this.defaultGroupBuckets + ", defaultGroupFirstKey=" + String.valueOf(this.defaultGroupFirstKey) + ", redistributionDelay=" + this.redistributionDelay + ", sendToDLAOnNoRoute=" + this.sendToDLAOnNoRoute + ", slowConsumerThreshold=" + this.slowConsumerThreshold + ", slowConsumerThresholdMeasurementUnit=" + String.valueOf((Object)this.slowConsumerThresholdMeasurementUnit) + ", slowConsumerCheckPeriod=" + this.slowConsumerCheckPeriod + ", slowConsumerPolicy=" + String.valueOf((Object)this.slowConsumerPolicy) + ", autoCreateJmsQueues=" + this.autoCreateJmsQueues + ", autoDeleteJmsQueues=" + this.autoDeleteJmsQueues + ", autoCreateJmsTopics=" + this.autoCreateJmsTopics + ", autoDeleteJmsTopics=" + this.autoDeleteJmsTopics + ", autoCreateQueues=" + this.autoCreateQueues + ", autoDeleteQueues=" + this.autoDeleteQueues + ", autoDeleteCreatedQueues=" + this.autoDeleteCreatedQueues + ", autoDeleteQueuesDelay=" + this.autoDeleteQueuesDelay + ", autoDeleteQueuesSkipUsageCheck=" + this.autoDeleteQueuesSkipUsageCheck + ", autoDeleteQueuesMessageCount=" + this.autoDeleteQueuesMessageCount + ", defaultRingSize=" + this.defaultRingSize + ", retroactiveMessageCount=" + this.retroactiveMessageCount + ", configDeleteQueues=" + String.valueOf((Object)this.configDeleteQueues) + ", autoCreateAddresses=" + this.autoCreateAddresses + ", autoDeleteAddresses=" + this.autoDeleteAddresses + ", autoDeleteAddressesDelay=" + this.autoDeleteAddressesDelay + ", autoDeleteAddressesSkipUsageCheck=" + this.autoDeleteAddressesSkipUsageCheck + ", configDeleteAddresses=" + String.valueOf((Object)this.configDeleteAddresses) + ", configDeleteDiverts=" + String.valueOf((Object)this.configDeleteDiverts) + ", managementBrowsePageSize=" + this.managementBrowsePageSize + ", maxSizeBytesRejectThreshold=" + this.maxSizeBytesRejectThreshold + ", defaultMaxConsumers=" + this.defaultMaxConsumers + ", defaultPurgeOnNoConsumers=" + this.defaultPurgeOnNoConsumers + ", defaultConsumersBeforeDispatch=" + this.defaultConsumersBeforeDispatch + ", defaultDelayBeforeDispatch=" + this.defaultDelayBeforeDispatch + ", defaultQueueRoutingType=" + String.valueOf(this.defaultQueueRoutingType) + ", defaultAddressRoutingType=" + String.valueOf(this.defaultAddressRoutingType) + ", defaultConsumerWindowSize=" + this.defaultConsumerWindowSize + ", autoCreateDeadLetterResources=" + this.autoCreateDeadLetterResources + ", deadLetterQueuePrefix=" + String.valueOf(this.deadLetterQueuePrefix) + ", deadLetterQueueSuffix=" + String.valueOf(this.deadLetterQueueSuffix) + ", autoCreateExpiryResources=" + this.autoCreateExpiryResources + ", expiryQueuePrefix=" + String.valueOf(this.expiryQueuePrefix) + ", expiryQueueSuffix=" + String.valueOf(this.expiryQueueSuffix) + ", enableMetrics=" + this.enableMetrics + ", managementMessageAttributeSizeLimit=" + this.managementMessageAttributeSizeLimit + ", enableIngressTimestamp=" + this.enableIngressTimestamp + ", idCacheSize=" + this.idCacheSize + ", queuePrefetch=" + this.queuePrefetch + ", initialQueueBufferSize=" + this.initialQueueBufferSize + "}";
    }

    static {
        metaBean.add(AddressFullMessagePolicy.class, "addressFullMessagePolicy", (t, p) -> {
            t.addressFullMessagePolicy = p;
        }, t -> t.addressFullMessagePolicy);
        metaBean.add(Long.class, "maxSizeBytes", (t, p) -> {
            t.maxSizeBytes = p;
        }, t -> t.maxSizeBytes);
        metaBean.add(Integer.class, "maxReadPageBytes", (t, p) -> {
            t.maxReadPageBytes = p;
        }, t -> t.maxReadPageBytes);
        metaBean.add(Integer.class, "maxReadPageMessages", (t, p) -> {
            t.maxReadPageMessages = p;
        }, t -> t.maxReadPageMessages);
        metaBean.add(Integer.class, "prefetchPageBytes", (t, p) -> {
            t.prefetchPageBytes = p;
        }, t -> t.prefetchPageBytes);
        metaBean.add(Integer.class, "prefetchPageMessages", (t, p) -> {
            t.prefetchPageMessages = p;
        }, t -> t.prefetchPageMessages);
        metaBean.add(Long.class, "pageLimitBytes", (t, p) -> {
            t.pageLimitBytes = p;
        }, t -> t.pageLimitBytes);
        metaBean.add(Long.class, "pageLimitMessages", (t, p) -> {
            t.pageLimitMessages = p;
        }, t -> t.pageLimitMessages);
        metaBean.add(PageFullMessagePolicy.class, "pageFullMessagePolicy", (t, p) -> {
            t.pageFullMessagePolicy = p;
        }, t -> t.pageFullMessagePolicy);
        metaBean.add(Long.class, "maxSizeMessages", (t, p) -> {
            t.maxSizeMessages = p;
        }, t -> t.maxSizeMessages);
        metaBean.add(Integer.class, "pageSizeBytes", (t, p) -> {
            t.pageSizeBytes = p;
        }, t -> t.pageSizeBytes);
        metaBean.add(Integer.class, "pageCacheMaxSize", (t, p) -> {
            t.pageCacheMaxSize = p;
        }, t -> t.pageCacheMaxSize);
        metaBean.add(Boolean.class, "dropMessagesWhenFull", (t, p) -> {
            t.dropMessagesWhenFull = p;
        }, t -> t.dropMessagesWhenFull);
        metaBean.add(Integer.class, "maxDeliveryAttempts", (t, p) -> {
            t.maxDeliveryAttempts = p;
        }, t -> t.maxDeliveryAttempts);
        metaBean.add(Integer.class, "messageCounterHistoryDayLimit", (t, p) -> {
            t.messageCounterHistoryDayLimit = p;
        }, t -> t.messageCounterHistoryDayLimit);
        metaBean.add(Long.class, "redeliveryDelay", (t, p) -> {
            t.redeliveryDelay = p;
        }, t -> t.redeliveryDelay);
        metaBean.add(Double.class, "redeliveryMultiplier", (t, p) -> {
            t.redeliveryMultiplier = p;
        }, t -> t.redeliveryMultiplier);
        metaBean.add(Double.class, "redeliveryCollisionAvoidanceFactor", (t, p) -> {
            t.redeliveryCollisionAvoidanceFactor = p;
        }, t -> t.redeliveryCollisionAvoidanceFactor);
        metaBean.add(Long.class, "maxRedeliveryDelay", (t, p) -> {
            t.maxRedeliveryDelay = p;
        }, t -> t.maxRedeliveryDelay);
        metaBean.add(SimpleString.class, "deadLetterAddress", (t, p) -> {
            t.deadLetterAddress = p;
        }, t -> t.deadLetterAddress);
        metaBean.add(SimpleString.class, "expiryAddress", (t, p) -> {
            t.expiryAddress = p;
        }, t -> t.expiryAddress);
        metaBean.add(Long.class, "expiryDelay", (t, p) -> {
            t.expiryDelay = p;
        }, t -> t.expiryDelay);
        metaBean.add(Long.class, "minExpiryDelay", (t, p) -> {
            t.minExpiryDelay = p;
        }, t -> t.minExpiryDelay);
        metaBean.add(Long.class, "maxExpiryDelay", (t, p) -> {
            t.maxExpiryDelay = p;
        }, t -> t.maxExpiryDelay);
        metaBean.add(Boolean.class, "noExpiry", (t, p) -> {
            t.noExpiry = p;
        }, t -> t.noExpiry);
        metaBean.add(Boolean.class, "defaultLastValueQueue", (t, p) -> {
            t.defaultLastValueQueue = p;
        }, t -> t.defaultLastValueQueue);
        metaBean.add(SimpleString.class, "defaultLastValueKey", (t, p) -> {
            t.defaultLastValueKey = p;
        }, t -> t.defaultLastValueKey);
        metaBean.add(Boolean.class, "defaultNonDestructive", (t, p) -> {
            t.defaultNonDestructive = p;
        }, t -> t.defaultNonDestructive);
        metaBean.add(Boolean.class, "defaultExclusiveQueue", (t, p) -> {
            t.defaultExclusiveQueue = p;
        }, t -> t.defaultExclusiveQueue);
        metaBean.add(Boolean.class, "defaultGroupRebalance", (t, p) -> {
            t.defaultGroupRebalance = p;
        }, t -> t.defaultGroupRebalance);
        metaBean.add(Boolean.class, "defaultGroupRebalancePauseDispatch", (t, p) -> {
            t.defaultGroupRebalancePauseDispatch = p;
        }, t -> t.defaultGroupRebalancePauseDispatch);
        metaBean.add(Integer.class, "defaultGroupBuckets", (t, p) -> {
            t.defaultGroupBuckets = p;
        }, t -> t.defaultGroupBuckets);
        metaBean.add(SimpleString.class, "defaultGroupFirstKey", (t, p) -> {
            t.defaultGroupFirstKey = p;
        }, t -> t.defaultGroupFirstKey);
        metaBean.add(Long.class, "redistributionDelay", (t, p) -> {
            t.redistributionDelay = p;
        }, t -> t.redistributionDelay);
        metaBean.add(Boolean.class, "sendToDLAOnNoRoute", (t, p) -> {
            t.sendToDLAOnNoRoute = p;
        }, t -> t.sendToDLAOnNoRoute);
        metaBean.add(Long.class, "slowConsumerThreshold", (t, p) -> {
            t.slowConsumerThreshold = p;
        }, t -> t.slowConsumerThreshold);
        metaBean.add(SlowConsumerThresholdMeasurementUnit.class, "slowConsumerThresholdMeasurementUnit", (t, p) -> {
            t.slowConsumerThresholdMeasurementUnit = p;
        }, t -> t.slowConsumerThresholdMeasurementUnit);
        metaBean.add(Long.class, "slowConsumerCheckPeriod", (t, p) -> {
            t.slowConsumerCheckPeriod = p;
        }, t -> t.slowConsumerCheckPeriod);
        metaBean.add(SlowConsumerPolicy.class, "slowConsumerPolicy", (t, p) -> {
            t.slowConsumerPolicy = p;
        }, t -> t.slowConsumerPolicy);
        metaBean.add(Boolean.class, "autoCreateJmsQueues", (t, p) -> {
            t.autoCreateJmsQueues = (Boolean)p;
        }, t -> t.autoCreateJmsQueues, t -> t.autoCreateJmsQueues != null);
        metaBean.add(Boolean.class, "autoDeleteJmsQueues", (t, p) -> {
            t.autoDeleteJmsQueues = (Boolean)p;
        }, t -> t.autoDeleteJmsQueues, t -> t.autoDeleteJmsQueues != null);
        metaBean.add(Boolean.class, "autoCreateJmsTopics", (t, p) -> {
            t.autoCreateJmsTopics = (Boolean)p;
        }, t -> t.autoCreateJmsTopics, t -> t.autoCreateJmsTopics != null);
        metaBean.add(Boolean.class, "autoDeleteJmsTopics", (t, p) -> {
            t.autoDeleteJmsTopics = (Boolean)p;
        }, t -> t.autoDeleteJmsTopics, t -> t.autoDeleteJmsTopics != null);
        metaBean.add(Boolean.class, "autoCreateQueues", (t, p) -> {
            t.autoCreateQueues = p;
        }, t -> t.autoCreateQueues);
        metaBean.add(Boolean.class, "autoDeleteQueues", (t, p) -> {
            t.autoDeleteQueues = p;
        }, t -> t.autoDeleteQueues);
        metaBean.add(Boolean.class, "autoDeleteCreatedQueues", (t, p) -> {
            t.autoDeleteCreatedQueues = p;
        }, t -> t.autoDeleteCreatedQueues);
        metaBean.add(Long.class, "autoDeleteQueuesDelay", (t, p) -> {
            t.autoDeleteQueuesDelay = p;
        }, t -> t.autoDeleteQueuesDelay);
        metaBean.add(Boolean.class, "autoDeleteQueuesSkipUsageCheck", (t, p) -> {
            t.autoDeleteQueuesSkipUsageCheck = p;
        }, t -> t.autoDeleteQueuesSkipUsageCheck);
        metaBean.add(Long.class, "autoDeleteQueuesMessageCount", (t, p) -> {
            t.autoDeleteQueuesMessageCount = p;
        }, t -> t.autoDeleteQueuesMessageCount);
        metaBean.add(Long.class, "defaultRingSize", (t, p) -> {
            t.defaultRingSize = p;
        }, t -> t.defaultRingSize);
        metaBean.add(Long.class, "retroactiveMessageCount", (t, p) -> {
            t.retroactiveMessageCount = p;
        }, t -> t.retroactiveMessageCount);
        metaBean.add(DeletionPolicy.class, "configDeleteQueues", (t, p) -> {
            t.configDeleteQueues = p;
        }, t -> t.configDeleteQueues);
        metaBean.add(Boolean.class, "autoCreateAddresses", (t, p) -> {
            t.autoCreateAddresses = p;
        }, t -> t.autoCreateAddresses);
        metaBean.add(Boolean.class, "autoDeleteAddresses", (t, p) -> {
            t.autoDeleteAddresses = p;
        }, t -> t.autoDeleteAddresses);
        metaBean.add(Long.class, "autoDeleteAddressesDelay", (t, p) -> {
            t.autoDeleteAddressesDelay = p;
        }, t -> t.autoDeleteAddressesDelay);
        metaBean.add(Boolean.class, "autoDeleteAddressesSkipUsageCheck", (t, p) -> {
            t.autoDeleteAddressesSkipUsageCheck = p;
        }, t -> t.autoDeleteAddressesSkipUsageCheck);
        metaBean.add(DeletionPolicy.class, "configDeleteAddresses", (t, p) -> {
            t.configDeleteAddresses = p;
        }, t -> t.configDeleteAddresses);
        metaBean.add(DeletionPolicy.class, "configDeleteDiverts", (t, p) -> {
            t.configDeleteDiverts = p;
        }, t -> t.configDeleteDiverts);
        metaBean.add(Integer.class, "managementBrowsePageSize", (t, p) -> {
            t.managementBrowsePageSize = p;
        }, t -> t.managementBrowsePageSize);
        metaBean.add(Long.class, "maxSizeBytesRejectThreshold", (t, p) -> {
            t.maxSizeBytesRejectThreshold = p;
        }, t -> t.maxSizeBytesRejectThreshold);
        metaBean.add(Integer.class, "defaultMaxConsumers", (t, p) -> {
            t.defaultMaxConsumers = p;
        }, t -> t.defaultMaxConsumers);
        metaBean.add(Boolean.class, "defaultPurgeOnNoConsumers", (t, p) -> {
            t.defaultPurgeOnNoConsumers = p;
        }, t -> t.defaultPurgeOnNoConsumers);
        metaBean.add(Integer.class, "defaultConsumersBeforeDispatch", (t, p) -> {
            t.defaultConsumersBeforeDispatch = p;
        }, t -> t.defaultConsumersBeforeDispatch);
        metaBean.add(Long.class, "defaultDelayBeforeDispatch", (t, p) -> {
            t.defaultDelayBeforeDispatch = p;
        }, t -> t.defaultDelayBeforeDispatch);
        metaBean.add(RoutingType.class, "defaultQueueRoutingType", (t, p) -> {
            t.defaultQueueRoutingType = p;
        }, t -> t.defaultQueueRoutingType);
        metaBean.add(RoutingType.class, "defaultAddressRoutingType", (t, p) -> {
            t.defaultAddressRoutingType = p;
        }, t -> t.defaultAddressRoutingType);
        metaBean.add(Integer.class, "defaultConsumerWindowSize", (t, p) -> {
            t.defaultConsumerWindowSize = p;
        }, t -> t.defaultConsumerWindowSize);
        metaBean.add(Boolean.class, "autoCreateDeadLetterResources", (t, p) -> {
            t.autoCreateDeadLetterResources = p;
        }, t -> t.autoCreateDeadLetterResources);
        metaBean.add(SimpleString.class, "deadLetterQueuePrefix", (t, p) -> {
            t.deadLetterQueuePrefix = p;
        }, t -> t.deadLetterQueuePrefix);
        metaBean.add(SimpleString.class, "deadLetterQueueSuffix", (t, p) -> {
            t.deadLetterQueueSuffix = p;
        }, t -> t.deadLetterQueueSuffix);
        metaBean.add(Boolean.class, "autoCreateExpiryResources", (t, p) -> {
            t.autoCreateExpiryResources = p;
        }, t -> t.autoCreateExpiryResources);
        metaBean.add(SimpleString.class, "expiryQueuePrefix", (t, p) -> {
            t.expiryQueuePrefix = p;
        }, t -> t.expiryQueuePrefix);
        metaBean.add(SimpleString.class, "expiryQueueSuffix", (t, p) -> {
            t.expiryQueueSuffix = p;
        }, t -> t.expiryQueueSuffix);
        metaBean.add(Boolean.class, "enableMetrics", (t, p) -> {
            t.enableMetrics = p;
        }, t -> t.enableMetrics);
        metaBean.add(Integer.class, "managementMessageAttributeSizeLimit", (t, p) -> {
            t.managementMessageAttributeSizeLimit = p;
        }, t -> t.managementMessageAttributeSizeLimit);
        metaBean.add(Boolean.class, "enableIngressTimestamp", (t, p) -> {
            t.enableIngressTimestamp = p;
        }, t -> t.enableIngressTimestamp);
        metaBean.add(Integer.class, "idCacheSize", (t, p) -> {
            t.idCacheSize = p;
        }, t -> t.idCacheSize);
        metaBean.add(Integer.class, "queuePrefetch", (t, p) -> {
            t.queuePrefetch = p;
        }, t -> t.queuePrefetch);
        metaBean.add(Integer.class, "initialQueueBufferSize", (t, p) -> {
            t.initialQueueBufferSize = p;
        }, t -> t.initialQueueBufferSize);
    }
}

