/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.cluster.ha.BackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStorePrimaryPolicy;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.SharedStoreBackupActivation;

public class SharedStoreBackupPolicy
extends BackupPolicy {
    private boolean failoverOnServerShutdown = ActiveMQDefaultConfiguration.isDefaultFailoverOnServerShutdown();
    private boolean allowAutoFailBack = ActiveMQDefaultConfiguration.isDefaultAllowAutoFailback();
    private boolean isWaitForActivation = ActiveMQDefaultConfiguration.isDefaultWaitForActivation();
    private SharedStorePrimaryPolicy sharedStorePrimaryPolicy;

    public SharedStoreBackupPolicy() {
    }

    public SharedStoreBackupPolicy(boolean failoverOnServerShutdown, boolean restartBackup, boolean allowAutoFailBack, ScaleDownPolicy scaleDownPolicy) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        this.restartBackup = restartBackup;
        this.allowAutoFailBack = allowAutoFailBack;
        this.scaleDownPolicy = scaleDownPolicy;
    }

    @Deprecated
    public long getFailbackDelay() {
        return -1L;
    }

    @Deprecated
    public void setFailbackDelay(long failbackDelay) {
    }

    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
    }

    public SharedStorePrimaryPolicy getSharedStorePrimaryPolicy() {
        if (this.sharedStorePrimaryPolicy == null) {
            this.sharedStorePrimaryPolicy = new SharedStorePrimaryPolicy(this.failoverOnServerShutdown, this.isWaitForActivation);
        }
        return this.sharedStorePrimaryPolicy;
    }

    public void setSharedStorePrimaryPolicy(SharedStorePrimaryPolicy sharedStorePrimaryPolicy) {
        this.sharedStorePrimaryPolicy = sharedStorePrimaryPolicy;
    }

    @Override
    public boolean isSharedStore() {
        return true;
    }

    @Override
    public boolean canScaleDown() {
        return this.scaleDownPolicy != null;
    }

    public boolean isAllowAutoFailBack() {
        return this.allowAutoFailBack;
    }

    public void setAllowAutoFailBack(boolean allowAutoFailBack) {
        this.allowAutoFailBack = allowAutoFailBack;
    }

    public void setIsWaitForActivation(boolean isWaitForActivation) {
        this.isWaitForActivation = isWaitForActivation;
    }

    @Override
    public Activation createActivation(ActiveMQServerImpl server, boolean wasPrimary, Map<String, Object> activationParams, IOCriticalErrorListener ioCriticalErrorListener) {
        return new SharedStoreBackupActivation(server, this, ioCriticalErrorListener);
    }

    @Override
    public String getBackupGroupName() {
        return null;
    }
}

