/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Arrays;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.replication.ReplicationManager;

public final class ReplicationAddMessage
extends PacketImpl {
    private long id;
    private byte journalID;
    private ReplicationManager.ADD_OPERATION_TYPE operation;
    private byte journalRecordType;
    private Persister persister;
    private Object encodingData;
    private byte[] recordData;
    private final boolean beforeTwoEighteen;

    public ReplicationAddMessage(boolean beforeTwoEighteen) {
        super((byte)91);
        this.beforeTwoEighteen = beforeTwoEighteen;
    }

    public ReplicationAddMessage(boolean beforeTwoEighteen, byte journalID, ReplicationManager.ADD_OPERATION_TYPE operation, long id, byte journalRecordType, Persister persister, Object encodingData) {
        this(beforeTwoEighteen);
        this.journalID = journalID;
        this.operation = operation;
        this.id = id;
        this.journalRecordType = journalRecordType;
        this.persister = persister;
        this.encodingData = encodingData;
    }

    public int expectedEncodeSize() {
        return 28 + this.persister.getEncodeSize(this.encodingData);
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeByte(this.journalID);
        if (this.beforeTwoEighteen) {
            buffer.writeBoolean(this.operation == ReplicationManager.ADD_OPERATION_TYPE.UPDATE);
        } else {
            buffer.writeByte(this.operation.toRecord());
        }
        buffer.writeLong(this.id);
        buffer.writeByte(this.journalRecordType);
        buffer.writeInt(this.persister.getEncodeSize(this.encodingData));
        this.persister.encode(buffer, this.encodingData);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        boolean isUpdate;
        this.journalID = buffer.readByte();
        this.operation = this.beforeTwoEighteen ? ((isUpdate = buffer.readBoolean()) ? ReplicationManager.ADD_OPERATION_TYPE.UPDATE : ReplicationManager.ADD_OPERATION_TYPE.ADD) : ReplicationManager.ADD_OPERATION_TYPE.toOperation(buffer.readByte());
        this.id = buffer.readLong();
        this.journalRecordType = buffer.readByte();
        int recordDataSize = buffer.readInt();
        this.recordData = new byte[recordDataSize];
        buffer.readBytes(this.recordData);
    }

    public long getId() {
        return this.id;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public ReplicationManager.ADD_OPERATION_TYPE getRecord() {
        return this.operation;
    }

    public byte getJournalRecordType() {
        return this.journalRecordType;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.encodingData, this.id, this.journalID, this.journalRecordType, this.operation, Arrays.hashCode(this.recordData)});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationAddMessage)) {
            return false;
        }
        ReplicationAddMessage other = (ReplicationAddMessage)((Object)obj);
        return Objects.equals(this.encodingData, other.encodingData) && this.id == other.id && this.journalID == other.journalID && this.journalRecordType == other.journalRecordType && this.operation == other.operation && Arrays.equals(this.recordData, other.recordData);
    }
}

