/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Serializable;
import java.util.Objects;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;

@Deprecated
public class CoreQueueConfiguration
implements Serializable {
    private static final long serialVersionUID = 650404974977490254L;
    private String address = null;
    private String name = null;
    private String filterString = null;
    private boolean durable = true;
    private String user = null;
    private Boolean exclusive;
    private Boolean groupRebalance;
    private Integer groupBuckets;
    private String groupFirstKey;
    private Boolean lastValue;
    private String lastValueKey;
    private Boolean nonDestructive;
    private Integer maxConsumers;
    private Integer consumersBeforeDispatch;
    private Long delayBeforeDispatch;
    private Boolean enabled;
    private Long ringSize = ActiveMQDefaultConfiguration.getDefaultRingSize();
    private Boolean purgeOnNoConsumers = ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers();
    private RoutingType routingType = ActiveMQDefaultConfiguration.getDefaultRoutingType();

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public String getUser() {
        return this.user;
    }

    public Boolean isExclusive() {
        return this.exclusive;
    }

    public Boolean isGroupRebalance() {
        return this.groupRebalance;
    }

    public Integer getGroupBuckets() {
        return this.groupBuckets;
    }

    public String getGroupFirstKey() {
        return this.groupFirstKey;
    }

    public Boolean isLastValue() {
        return this.lastValue;
    }

    public String getLastValueKey() {
        return this.lastValueKey;
    }

    public Boolean isNonDestructive() {
        return this.nonDestructive;
    }

    public Integer getConsumersBeforeDispatch() {
        return this.consumersBeforeDispatch;
    }

    public Long getDelayBeforeDispatch() {
        return this.delayBeforeDispatch;
    }

    public Long getRingSize() {
        return this.ringSize;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public QueueConfiguration toQueueConfiguration() {
        return QueueConfiguration.of((String)this.getName()).setAddress(this.getAddress()).setDurable(Boolean.valueOf(this.isDurable())).setRoutingType(this.getRoutingType()).setExclusive(this.isExclusive()).setRingSize(this.getRingSize()).setGroupRebalance(this.isGroupRebalance()).setNonDestructive(this.isNonDestructive()).setLastValue(this.isLastValue()).setFilterString(this.getFilterString()).setMaxConsumers(this.getMaxConsumers()).setPurgeOnNoConsumers(Boolean.valueOf(this.getPurgeOnNoConsumers())).setConsumersBeforeDispatch(this.getConsumersBeforeDispatch()).setDelayBeforeDispatch(this.getDelayBeforeDispatch()).setGroupBuckets(this.getGroupBuckets()).setGroupFirstKey(this.getGroupFirstKey()).setUser(this.getUser()).setLastValueKey(this.getLastValueKey()).setEnabled(this.isEnabled());
    }

    public static CoreQueueConfiguration fromQueueConfiguration(QueueConfiguration queueConfiguration) {
        return new CoreQueueConfiguration().setAddress(Objects.toString(queueConfiguration.getAddress(), null)).setName(Objects.toString(queueConfiguration.getName(), null)).setFilterString(Objects.toString(queueConfiguration.getFilterString(), null)).setDurable(Objects.requireNonNullElse(queueConfiguration.isDurable(), true)).setUser(Objects.toString(queueConfiguration.getUser(), null)).setExclusive(queueConfiguration.isExclusive()).setGroupRebalance(queueConfiguration.isGroupRebalance()).setGroupBuckets(queueConfiguration.getGroupBuckets()).setGroupFirstKey(Objects.toString(queueConfiguration.getGroupFirstKey(), null)).setLastValue(queueConfiguration.isLastValue()).setLastValueKey(Objects.toString(queueConfiguration.getLastValueKey(), null)).setNonDestructive(queueConfiguration.isNonDestructive()).setMaxConsumers(queueConfiguration.getMaxConsumers()).setConsumersBeforeDispatch(queueConfiguration.getConsumersBeforeDispatch()).setDelayBeforeDispatch(queueConfiguration.getDelayBeforeDispatch()).setRingSize(Objects.requireNonNullElse(queueConfiguration.getRingSize(), ActiveMQDefaultConfiguration.getDefaultRingSize())).setEnabled(Objects.requireNonNullElse(queueConfiguration.isEnabled(), ActiveMQDefaultConfiguration.getDefaultEnabled())).setPurgeOnNoConsumers(Objects.requireNonNullElse(queueConfiguration.isPurgeOnNoConsumers(), ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers())).setRoutingType(Objects.requireNonNullElse(queueConfiguration.getRoutingType(), ActiveMQDefaultConfiguration.getDefaultRoutingType()));
    }

    public CoreQueueConfiguration setAddress(String address) {
        this.address = address;
        return this;
    }

    public CoreQueueConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public CoreQueueConfiguration setFilterString(String filterString) {
        this.filterString = filterString;
        return this;
    }

    public CoreQueueConfiguration setDurable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public CoreQueueConfiguration setMaxConsumers(Integer maxConsumers) {
        this.maxConsumers = maxConsumers;
        return this;
    }

    public CoreQueueConfiguration setConsumersBeforeDispatch(Integer consumersBeforeDispatch) {
        this.consumersBeforeDispatch = consumersBeforeDispatch;
        return this;
    }

    public CoreQueueConfiguration setDelayBeforeDispatch(Long delayBeforeDispatch) {
        this.delayBeforeDispatch = delayBeforeDispatch;
        return this;
    }

    public CoreQueueConfiguration setRingSize(Long ringSize) {
        this.ringSize = ringSize;
        return this;
    }

    public CoreQueueConfiguration setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public CoreQueueConfiguration setPurgeOnNoConsumers(Boolean purgeOnNoConsumers) {
        this.purgeOnNoConsumers = purgeOnNoConsumers;
        return this;
    }

    public CoreQueueConfiguration setUser(String user) {
        this.user = user;
        return this;
    }

    public CoreQueueConfiguration setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    public CoreQueueConfiguration setGroupRebalance(Boolean groupRebalance) {
        this.groupRebalance = groupRebalance;
        return this;
    }

    public CoreQueueConfiguration setGroupBuckets(Integer groupBuckets) {
        this.groupBuckets = groupBuckets;
        return this;
    }

    public CoreQueueConfiguration setGroupFirstKey(String groupFirstKey) {
        this.groupFirstKey = groupFirstKey;
        return this;
    }

    public CoreQueueConfiguration setLastValue(Boolean lastValue) {
        this.lastValue = lastValue;
        return this;
    }

    public CoreQueueConfiguration setLastValueKey(String lastValueKey) {
        this.lastValueKey = lastValueKey;
        return this;
    }

    public CoreQueueConfiguration setNonDestructive(Boolean nonDestructive) {
        this.nonDestructive = nonDestructive;
        return this;
    }

    public boolean getPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    public Integer getMaxConsumers() {
        return this.maxConsumers;
    }

    public RoutingType getRoutingType() {
        return this.routingType;
    }

    public CoreQueueConfiguration setRoutingType(RoutingType routingType) {
        this.routingType = routingType;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.address, this.durable, this.filterString, this.name, this.maxConsumers, this.purgeOnNoConsumers, this.exclusive, this.groupRebalance, this.groupBuckets, this.groupFirstKey, this.lastValue, this.lastValueKey, this.nonDestructive, this.consumersBeforeDispatch, this.delayBeforeDispatch, this.routingType, this.ringSize, this.enabled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CoreQueueConfiguration)) {
            return false;
        }
        CoreQueueConfiguration other = (CoreQueueConfiguration)obj;
        return Objects.equals(this.address, other.address) && this.durable == other.durable && Objects.equals(this.filterString, other.filterString) && Objects.equals(this.name, other.name) && Objects.equals(this.maxConsumers, other.maxConsumers) && Objects.equals(this.purgeOnNoConsumers, other.purgeOnNoConsumers) && Objects.equals(this.ringSize, other.ringSize) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.exclusive, other.exclusive) && Objects.equals(this.groupRebalance, other.groupRebalance) && Objects.equals(this.groupBuckets, other.groupBuckets) && Objects.equals(this.groupFirstKey, other.groupFirstKey) && Objects.equals(this.lastValue, other.lastValue) && Objects.equals(this.lastValueKey, other.lastValueKey) && Objects.equals(this.nonDestructive, other.nonDestructive) && Objects.equals(this.consumersBeforeDispatch, other.consumersBeforeDispatch) && Objects.equals(this.delayBeforeDispatch, other.delayBeforeDispatch) && Objects.equals(this.routingType, other.routingType);
    }

    public String toString() {
        return "CoreQueueConfiguration[name=" + this.name + ", address=" + this.address + ", routingType=" + String.valueOf(this.routingType) + ", durable=" + this.durable + ", filterString=" + this.filterString + ", maxConsumers=" + this.maxConsumers + ", purgeOnNoConsumers=" + this.purgeOnNoConsumers + ", exclusive=" + this.exclusive + ", groupRebalance=" + this.groupRebalance + ", groupBuckets=" + this.groupBuckets + ", groupFirstKey=" + this.groupFirstKey + ", lastValue=" + this.lastValue + ", lastValueKey=" + this.lastValueKey + ", nonDestructive=" + this.nonDestructive + ", consumersBeforeDispatch=" + this.consumersBeforeDispatch + ", delayBeforeDispatch=" + this.delayBeforeDispatch + ", ringSize=" + this.ringSize + ", enabled=" + this.enabled + "]";
    }
}

