/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.exceptions;

import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.exceptions.ProviderConnectionSecurityException;
import org.apache.qpid.jms.provider.exceptions.ProviderIOException;
import org.apache.qpid.jms.sasl.SaslSecurityRuntimeException;

public class ProviderExceptionSupport {
    public static ProviderIOException createOrPassthroughFatal(Throwable cause) {
        if (cause instanceof ProviderIOException) {
            return (ProviderIOException)cause;
        }
        String message = cause.getMessage();
        if (message == null || message.length() == 0) {
            message = cause.toString();
        }
        if (cause instanceof SaslSecurityRuntimeException) {
            return new ProviderConnectionSecurityException(message, cause);
        }
        return new ProviderIOException(message, cause);
    }

    public static ProviderException createNonFatalOrPassthrough(Throwable cause) {
        if (cause instanceof ProviderException) {
            return (ProviderException)cause;
        }
        String message = cause.getMessage();
        if (message == null || message.length() == 0) {
            message = cause.toString();
        }
        return new ProviderException(message, cause);
    }
}

