/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsObjectMessage;
import org.apache.qpid.jms.message.facade.JmsObjectMessageFacade;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.policy.JmsDeserializationPolicy;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpMessageSupport;
import org.apache.qpid.jms.provider.amqp.message.AmqpObjectTypeDelegate;
import org.apache.qpid.jms.provider.amqp.message.AmqpSerializedObjectDelegate;
import org.apache.qpid.jms.provider.amqp.message.AmqpTypedObjectDelegate;

public class AmqpJmsObjectMessageFacade
extends AmqpJmsMessageFacade
implements JmsObjectMessageFacade {
    private AmqpObjectTypeDelegate delegate;
    private JmsDeserializationPolicy deserializationPolicy;

    @Override
    public void initialize(AmqpConnection connection) {
        super.initialize(connection);
        this.initDelegate(connection.isObjectMessageUsesAmqpTypes());
    }

    @Override
    public void initialize(AmqpConsumer consumer) {
        super.initialize(consumer);
        this.deserializationPolicy = ((JmsConsumerInfo)consumer.getResourceInfo()).getDeserializationPolicy();
        boolean javaSerialized = AmqpMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE.equals(this.getContentType());
        this.initDelegate(!javaSerialized);
    }

    @Override
    public byte getJmsMsgType() {
        return 1;
    }

    public boolean isAmqpTypedEncoding() {
        return this.delegate.isAmqpTypeEncoded();
    }

    @Override
    public AmqpJmsObjectMessageFacade copy() throws JMSException {
        AmqpJmsObjectMessageFacade copy = new AmqpJmsObjectMessageFacade();
        copy.deserializationPolicy = this.deserializationPolicy;
        copy.initDelegate(this.isAmqpTypedEncoding());
        this.copyInto(copy);
        try {
            this.delegate.copyInto(copy.delegate);
        }
        catch (Exception ex) {
            throw JmsExceptionSupport.create(ex);
        }
        return copy;
    }

    @Override
    public Serializable getObject() throws IOException, ClassNotFoundException {
        return this.delegate.getObject();
    }

    @Override
    public void setObject(Serializable value) throws IOException {
        this.delegate.setObject(value);
    }

    @Override
    public void clearBody() {
        try {
            this.setObject(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasBody() {
        return this.delegate.hasBody();
    }

    @Override
    public void onSend(long producerTtl) throws JMSException {
        super.onSend(producerTtl);
        this.delegate.onSend();
    }

    @Override
    public JmsObjectMessage asJmsMessage() {
        return new JmsObjectMessage(this);
    }

    void setUseAmqpTypedEncoding(boolean useAmqpTypedEncoding) throws JMSException {
        if (useAmqpTypedEncoding != this.delegate.isAmqpTypeEncoded()) {
            try {
                Serializable existingObject = this.delegate.getObject();
                AmqpObjectTypeDelegate newDelegate = null;
                newDelegate = useAmqpTypedEncoding ? new AmqpTypedObjectDelegate(this) : new AmqpSerializedObjectDelegate(this, this.deserializationPolicy);
                newDelegate.setObject(existingObject);
                this.delegate = newDelegate;
            }
            catch (IOException | ClassNotFoundException e) {
                throw JmsExceptionSupport.create(e);
            }
        }
    }

    private void initDelegate(boolean useAmqpTypes) {
        this.delegate = !useAmqpTypes ? new AmqpSerializedObjectDelegate(this, this.deserializationPolicy) : new AmqpTypedObjectDelegate(this);
    }

    AmqpObjectTypeDelegate getDelegate() {
        return this.delegate;
    }
}

