/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import java.lang.reflect.Method;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsQueue;
import org.apache.qpid.jms.JmsTopic;
import org.apache.qpid.jms.message.JmsUnresolvedDestinationTransformer;

public class JmsDefaultUnresolvedDestinationTransformer
implements JmsUnresolvedDestinationTransformer {
    @Override
    public JmsDestination transform(Destination destination) throws JMSException {
        String queueName = null;
        String topicName = null;
        if (destination instanceof Queue) {
            queueName = ((Queue)destination).getQueueName();
        }
        if (destination instanceof Topic) {
            topicName = ((Topic)destination).getTopicName();
        }
        if (queueName == null && topicName == null) {
            throw new JMSException("Unresolvable destination: Both queue and topic names are null: " + destination);
        }
        try {
            Method isQueueMethod = destination.getClass().getMethod("isQueue", new Class[0]);
            Method isTopicMethod = destination.getClass().getMethod("isTopic", new Class[0]);
            Boolean isQueue = (Boolean)isQueueMethod.invoke((Object)destination, new Object[0]);
            Boolean isTopic = (Boolean)isTopicMethod.invoke((Object)destination, new Object[0]);
            if (isQueue.booleanValue()) {
                return new JmsQueue(queueName);
            }
            if (isTopic.booleanValue()) {
                return new JmsTopic(topicName);
            }
            throw new JMSException("Unresolvable destination: Neither Queue nor Topic: " + destination);
        }
        catch (Exception e) {
            throw new JMSException("Unresolvable destination: " + e.getMessage() + ": " + destination);
        }
    }

    @Override
    public JmsDestination transform(String destination) throws JMSException {
        if (destination == null) {
            throw new JMSException("Destination objects cannot have a null name value");
        }
        return new JmsQueue(destination);
    }
}

