/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jolokia.server.core.util.InetAddresses;
import org.jolokia.server.core.util.NetworkInterfaceAndAddress;

public final class NetworkUtil {
    private static final boolean MAC = System.getProperty("os.name").toLowerCase().contains("mac");
    static final List<String> MAC_SKIP_NIFS = new ArrayList<String>();

    private NetworkUtil() {
    }

    public static void main(String[] args) throws UnknownHostException, SocketException {
        System.out.println(NetworkUtil.dumpLocalNetworkInfo());
    }

    public static InetAddress getAnyAddress() {
        try {
            return NetworkUtil.isIPv6Supported() ? Inet6Address.getByName("::") : InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static InetAddress getLocalAddress() throws UnknownHostException, SocketException {
        return NetworkUtil.getLocalAddress(Inet4Address.class);
    }

    public static InetAddress getLocalAddress(Class<? extends InetAddress> type) throws UnknownHostException, SocketException {
        InetAddress addr = InetAddress.getLocalHost();
        NetworkInterface nif = NetworkInterface.getByInetAddress(addr);
        if (addr.isLoopbackAddress() || addr.getClass() != type || nif == null) {
            InetAddress lookedUpAddr = NetworkUtil.findLocalAddressViaNetworkInterface(type);
            addr = lookedUpAddr != null ? lookedUpAddr : (type == null || type == Inet4Address.class ? InetAddress.getByName("127.0.0.1") : InetAddress.getByName("::1"));
        }
        return addr;
    }

    public static InetAddress getLocalAddressWithMulticast(Class<? extends InetAddress> type) throws UnknownHostException, SocketException {
        InetAddress addr = NetworkUtil.getLocalAddress(type);
        if (NetworkUtil.isMulticastSupported(addr)) {
            return addr;
        }
        throw new UnknownHostException("Cannot find address of local host which can be used for multicasting");
    }

    public static InetAddress findLocalAddressViaNetworkInterface(Class<? extends InetAddress> type) throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        InetAddress fallback = null;
        InetAddress fallbackHardware = null;
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface nif = networkInterfaces.nextElement();
            Enumeration<InetAddress> addrEnum = nif.getInetAddresses();
            while (addrEnum.hasMoreElements()) {
                InetAddress interfaceAddress = addrEnum.nextElement();
                if (!NetworkUtil.useInetAddress(nif, interfaceAddress, type)) continue;
                if (nif.getHardwareAddress() != null) {
                    if (fallbackHardware == null) {
                        fallbackHardware = interfaceAddress;
                        continue;
                    }
                    if (!fallbackHardware.isLinkLocalAddress() && !fallbackHardware.isSiteLocalAddress() || interfaceAddress.isLinkLocalAddress() || interfaceAddress.isSiteLocalAddress()) continue;
                    fallbackHardware = interfaceAddress;
                    continue;
                }
                if (fallback == null) {
                    fallback = interfaceAddress;
                    continue;
                }
                if (!fallback.isLinkLocalAddress() && !fallback.isSiteLocalAddress() || interfaceAddress.isLinkLocalAddress() || interfaceAddress.isSiteLocalAddress()) continue;
                fallback = interfaceAddress;
            }
        }
        return fallbackHardware != null ? fallbackHardware : fallback;
    }

    public static Map<String, InetAddresses> getBestMatchAddresses() {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return Collections.emptyMap();
        }
        HashMap<String, InetAddresses> result = new HashMap<String, InetAddresses>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface nif = networkInterfaces.nextElement();
            try {
                if (!nif.isUp()) continue;
                Inet4Address fallback4 = null;
                Inet6Address fallback6 = null;
                Enumeration<InetAddress> addrEnum = nif.getInetAddresses();
                while (addrEnum.hasMoreElements()) {
                    InetAddress ia = addrEnum.nextElement();
                    if (ia instanceof Inet4Address) {
                        if (fallback4 == null) {
                            fallback4 = (Inet4Address)ia;
                            continue;
                        }
                        if (!fallback4.isLinkLocalAddress() && !fallback4.isSiteLocalAddress() || ia.isLinkLocalAddress() || ia.isSiteLocalAddress()) continue;
                        fallback4 = (Inet4Address)ia;
                        continue;
                    }
                    if (!(ia instanceof Inet6Address)) continue;
                    if (fallback6 == null) {
                        fallback6 = (Inet6Address)ia;
                        continue;
                    }
                    if (!fallback6.isLinkLocalAddress() && !fallback6.isSiteLocalAddress() || ia.isLinkLocalAddress() || ia.isSiteLocalAddress()) continue;
                    fallback6 = (Inet6Address)ia;
                }
                result.put(nif.getName(), new InetAddresses(fallback4, fallback6));
            }
            catch (SocketException socketException) {}
        }
        return result;
    }

    public static NetworkInterface getBestMatchNetworkInterface() {
        Enumeration<NetworkInterface> networkInterfaces;
        boolean preferIP6Addresses = Boolean.getBoolean("java.net.preferIPv6Addresses");
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        NetworkInterface best = null;
        HashSet bestAddresses = new HashSet();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface nif = networkInterfaces.nextElement();
            if (best == null) {
                best = nif;
                continue;
            }
            try {
                if (!best.isUp() && nif.isUp()) {
                    best = nif;
                    best.getInterfaceAddresses().forEach(addr -> bestAddresses.add(addr.getAddress()));
                    continue;
                }
                NetworkInterface finalBest = best;
                boolean hardwareBetter = (best.getHardwareAddress() == null || MAC && MAC_SKIP_NIFS.stream().anyMatch(prefix -> finalBest.getName().startsWith((String)prefix))) && nif.getHardwareAddress() != null;
                boolean addressesBetter = false;
                HashSet addresses = new HashSet();
                nif.getInterfaceAddresses().forEach(addr -> addresses.add(addr.getAddress()));
                addressesBetter |= bestAddresses.size() < addresses.size();
                if (!preferIP6Addresses) {
                    addressesBetter |= bestAddresses.stream().noneMatch(a -> a instanceof Inet4Address) && addresses.stream().anyMatch(a -> a instanceof Inet4Address);
                }
                if (!hardwareBetter && !addressesBetter) continue;
                best = nif;
                bestAddresses.clear();
                bestAddresses.addAll(addresses);
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
        }
        return best;
    }

    public static boolean isMulticastSupported() {
        return !NetworkUtil.getMulticastAddresses().isEmpty();
    }

    public static boolean isIPv6Supported() {
        boolean preferIP4Stack = Boolean.getBoolean("java.net.preferIPv4Stack");
        if (preferIP4Stack) {
            return false;
        }
        boolean preferIP6Addresses = Boolean.getBoolean("java.net.preferIPv6Addresses");
        if (preferIP6Addresses) {
            InetAddress lo = InetAddress.getLoopbackAddress();
            return lo instanceof Inet6Address;
        }
        try {
            NetworkInterface nif = NetworkInterface.getByInetAddress(InetAddress.getByName("::1"));
            return nif != null;
        }
        catch (SocketException | UnknownHostException e) {
            return false;
        }
    }

    public static boolean isMulticastSupported(NetworkInterface pNif) throws SocketException {
        return pNif != null && pNif.isUp() && pNif.supportsMulticast();
    }

    public static boolean isMulticastSupported(InetAddress pAddr) throws SocketException {
        return NetworkUtil.isMulticastSupported(NetworkInterface.getByInetAddress(pAddr));
    }

    public static List<NetworkInterfaceAndAddress> getMulticastAddresses() {
        try {
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            ArrayList<NetworkInterfaceAndAddress> ret = new ArrayList<NetworkInterfaceAndAddress>();
            while (nifs.hasMoreElements()) {
                NetworkInterface nif = nifs.nextElement();
                if (!nif.supportsMulticast() || !nif.isUp()) continue;
                Enumeration<InetAddress> addresses = nif.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ret.add(new NetworkInterfaceAndAddress(nif, addresses.nextElement()));
                }
            }
            return ret;
        }
        catch (SocketException exp) {
            return Collections.emptyList();
        }
    }

    public static String getAgentId(int objectId, String type) {
        String address;
        try {
            address = NetworkUtil.getLocalAddress().getHostAddress();
        }
        catch (IOException exp) {
            address = "local";
        }
        return address + "-" + NetworkUtil.getProcessId() + "-" + Integer.toHexString(objectId) + "-" + type;
    }

    public static String sanitizeLocalUrl(String pRequestURL) {
        try {
            URL url = new URL(pRequestURL);
            String host = url.getHost();
            int port = NetworkUtil.getPort(url);
            InetAddress address = NetworkUtil.findLocalAddressListeningOnPort(host, port);
            return new URL(url.getProtocol(), address.getHostAddress(), port, url.getFile()).toExternalForm();
        }
        catch (IOException e) {
            return pRequestURL;
        }
    }

    private static int getPort(URL url) {
        int port = url.getPort();
        if (port != -1) {
            return port;
        }
        return url.getProtocol().equalsIgnoreCase("https") ? 443 : 80;
    }

    private static boolean useInetAddress(NetworkInterface networkInterface, InetAddress interfaceAddress, Class<? extends InetAddress> type) throws SocketException {
        return networkInterface.isUp() && networkInterface.supportsMulticast() && interfaceAddress.getClass() == type && !interfaceAddress.isLoopbackAddress();
    }

    private static InetAddress findLocalAddressListeningOnPort(String pHost, int pPort) throws UnknownHostException, SocketException {
        InetAddress address = InetAddress.getByName(pHost);
        if (address.isLoopbackAddress()) {
            InetAddress localAddress = NetworkUtil.getLocalAddress(address.getClass());
            if (!localAddress.isLoopbackAddress() && NetworkUtil.isPortOpen(localAddress, pPort)) {
                return localAddress;
            }
            localAddress = NetworkUtil.getLocalAddressFromNetworkInterfacesListeningOnPort(pPort);
            if (localAddress != null) {
                return localAddress;
            }
        }
        return address;
    }

    private static InetAddress getLocalAddressFromNetworkInterfacesListeningOnPort(int pPort) {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface nif = networkInterfaces.nextElement();
                Enumeration<InetAddress> addrEnum = nif.getInetAddresses();
                while (addrEnum.hasMoreElements()) {
                    InetAddress interfaceAddress = addrEnum.nextElement();
                    if (interfaceAddress.isLoopbackAddress() || !nif.isUp() || !NetworkUtil.isPortOpen(interfaceAddress, pPort)) continue;
                    return interfaceAddress;
                }
            }
        }
        catch (SocketException e) {
            return null;
        }
        return null;
    }

    private static boolean isPortOpen(InetAddress pAddress, int pPort) {
        boolean bl;
        Socket socket = new Socket();
        try {
            socket.setReuseAddress(true);
            InetSocketAddress sa = new InetSocketAddress(pAddress, pPort);
            socket.connect(sa, 200);
            bl = socket.isConnected();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    private static String getProcessId() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        return index < 0 ? jvmName : jvmName.substring(0, index);
    }

    /*
     * Unable to fully structure code
     */
    public static String dumpLocalNetworkInfo() throws UnknownHostException, SocketException {
        buffer = new StringBuilder();
        addr = InetAddress.getLocalHost();
        buffer.append("Localhost: ").append(NetworkUtil.getAddrInfo(addr, false)).append("\n");
        nifs = NetworkInterface.getNetworkInterfaces();
        buffer.append("Network interfaces:\n");
        while (nifs.hasMoreElements()) {
            nif = nifs.nextElement();
            buffer.append("  - ").append(NetworkUtil.getNetworkInterfaceInfo(nif)).append("\n");
            name = nif.getName();
            if (!NetworkUtil.MAC) ** GOTO lbl-1000
            if (NetworkUtil.MAC_SKIP_NIFS.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, startsWith(java.lang.String ), (Ljava/lang/String;)Z)((String)name))) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            skip = v0;
            addresses = nif.getInetAddresses();
            while (addresses.hasMoreElements()) {
                addr = addresses.nextElement();
                buffer.append("    ").append(NetworkUtil.getAddrInfo(addr, skip)).append("\n");
            }
        }
        return buffer.toString();
    }

    private static String getAddrInfo(InetAddress pAddr, boolean skipHostname) throws SocketException {
        String hostname = skipHostname ? null : pAddr.getHostName();
        Object ret = hostname != null ? hostname + " (" + pAddr.getHostAddress() + ")" : pAddr.getHostAddress();
        ret = (String)ret + " [site-local: " + pAddr.isSiteLocalAddress() + ", link-local: " + pAddr.isLinkLocalAddress() + ", lb: " + pAddr.isLoopbackAddress() + "]";
        NetworkInterface nif = NetworkInterface.getByInetAddress(pAddr);
        ret = (String)ret + " -- nif: " + NetworkUtil.getNetworkInterfaceInfo(nif);
        return ret;
    }

    private static String getNetworkInterfaceInfo(NetworkInterface pNif) throws SocketException {
        if (pNif == null) {
            return "[null]";
        }
        return pNif.getDisplayName() + " [up: " + pNif.isUp() + ", mc: " + pNif.supportsMulticast() + ", lb: " + pNif.isLoopback() + ", hw: " + NetworkUtil.formatHwAddress(pNif.getHardwareAddress()) + "]";
    }

    private static String formatHwAddress(byte[] pHardwareAddress) {
        if (pHardwareAddress == null) {
            return "[none]";
        }
        StringBuilder sb = new StringBuilder(18);
        for (byte b : pHardwareAddress) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

