/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.impl;

import org.jolokia.server.core.service.api.LogHandler;

public class StdoutLogHandler
implements LogHandler {
    private final boolean doDebug;

    public StdoutLogHandler(boolean pDoDebug) {
        this.doDebug = pDoDebug;
    }

    public StdoutLogHandler() {
        this(false);
    }

    public StdoutLogHandler(String category) {
        this(false);
    }

    @Override
    public void debug(String message) {
        if (this.doDebug) {
            this.log("D> " + message);
        }
    }

    @Override
    public void info(String message) {
        this.log("I> " + message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log("E> " + message);
        if (t != null) {
            t.printStackTrace();
        }
    }

    @Override
    public boolean isDebug() {
        return this.doDebug;
    }

    private void log(String message) {
        System.out.println(message);
    }
}

