/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.sql;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.sql.Oracle12CSQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.journal.ActiveMQJournalBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertySQLProvider
implements SQLProvider {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int STATE_ROW_ID = 0;
    private static final int PRIMARY_LOCK_ROW_ID = 1;
    private static final int BACKUP_LOCK_ROW_ID = 2;
    private static final int NODE_ID_ROW_ID = 3;
    private final String tableName;
    private final Factory.SQLDialect dialect;
    private volatile Properties sql;

    protected PropertySQLProvider(Factory.SQLDialect dialect, String tableName, Properties sqlProperties) {
        this.dialect = dialect;
        this.sql = sqlProperties;
        LetterCase tableNamesCase = LetterCase.parse(PropertySQLProvider.sql("table-names-case", dialect, sqlProperties, true));
        this.tableName = tableNamesCase.apply(tableName);
    }

    @Override
    public long getMaxBlobSize() {
        return Long.parseLong(this.sql("max-blob-size"));
    }

    @Override
    public String[] getCreateJournalTableSQL() {
        return new String[]{String.format(this.sql("create-journal-table"), this.tableName), String.format(this.sql("create-journal-index"), this.tableName), String.format(this.sql("create-journal-tx-index"), this.tableName)};
    }

    @Override
    public String getInsertJournalRecordsSQL() {
        return String.format(this.sql("insert-journal-record"), this.tableName);
    }

    @Override
    public String getSelectJournalRecordsSQL() {
        return String.format(this.sql("select-journal-record"), this.tableName);
    }

    @Override
    public String getDeleteJournalRecordsSQL() {
        return String.format(this.sql("delete-journal-record"), this.tableName);
    }

    @Override
    public String getDeleteJournalTxRecordsSQL() {
        return String.format(this.sql("delete-journal-tx-record"), this.tableName);
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String[] getCreateFileTableSQL() {
        return new String[]{String.format(this.sql("create-file-table"), this.tableName), String.format(this.sql("create-file-index"), this.tableName)};
    }

    @Override
    public String getInsertFileSQL() {
        return String.format(this.sql("insert-file"), this.tableName);
    }

    @Override
    public String getSelectFileNamesByExtensionSQL() {
        return String.format(this.sql("select-filenames-by-extension"), this.tableName);
    }

    @Override
    public String getSelectFileByFileName() {
        return String.format(this.sql("select-file-by-filename"), this.tableName);
    }

    @Override
    public String getReplaceLargeObjectSQL() {
        return String.format(this.sql("replace-file"), this.tableName);
    }

    @Override
    public String getAppendToLargeObjectSQL() {
        return String.format(this.sql("append-to-file"), this.tableName);
    }

    @Override
    public String getReadLargeObjectSQL() {
        return String.format(this.sql("read-large-object"), this.tableName);
    }

    @Override
    public String getDeleteFileSQL() {
        return String.format(this.sql("delete-file"), this.tableName);
    }

    @Override
    public String getUpdateFileNameByIdSQL() {
        return String.format(this.sql("update-filename-by-id"), this.tableName);
    }

    @Override
    public String getCopyFileRecordByIdSQL() {
        return String.format(this.sql("copy-file-record-by-id"), this.tableName);
    }

    @Override
    public String getDropFileTableSQL() {
        return String.format(this.sql("drop-table"), this.tableName);
    }

    @Override
    public String getCloneFileRecordByIdSQL() {
        return String.format(this.sql("clone-file-record"), this.tableName);
    }

    @Override
    public String getCountJournalRecordsSQL() {
        return String.format(this.sql("count-journal-record"), this.tableName);
    }

    @Override
    public boolean closeConnectionOnShutdown() {
        return Boolean.valueOf(this.sql("close-connection-on-shutdown"));
    }

    @Override
    public String createNodeManagerStoreTableSQL() {
        return String.format(this.sql("create-node-manager-store-table"), this.tableName);
    }

    @Override
    public String createStateSQL() {
        return String.format(this.sql("create-state"), this.tableName, 0);
    }

    @Override
    public String createNodeIdSQL() {
        return String.format(this.sql("create-state"), this.tableName, 3);
    }

    @Override
    public String createPrimaryLockSQL() {
        return String.format(this.sql("create-state"), this.tableName, 1);
    }

    @Override
    public String createBackupLockSQL() {
        return String.format(this.sql("create-state"), this.tableName, 2);
    }

    @Override
    public String tryAcquirePrimaryLockSQL() {
        return String.format(this.sql("try-acquire-lock"), this.tableName, 1);
    }

    @Override
    public String tryAcquireBackupLockSQL() {
        return String.format(this.sql("try-acquire-lock"), this.tableName, 2);
    }

    @Override
    public String tryReleasePrimaryLockSQL() {
        return String.format(this.sql("try-release-lock"), this.tableName, 1);
    }

    @Override
    public String tryReleaseBackupLockSQL() {
        return String.format(this.sql("try-release-lock"), this.tableName, 2);
    }

    @Override
    public String isPrimaryLockedSQL() {
        return String.format(this.sql("is-locked"), this.tableName, 1);
    }

    @Override
    public String isBackupLockedSQL() {
        return String.format(this.sql("is-locked"), this.tableName, 2);
    }

    @Override
    public String renewPrimaryLockSQL() {
        return String.format(this.sql("renew-lock"), this.tableName, 1);
    }

    @Override
    public String renewBackupLockSQL() {
        return String.format(this.sql("renew-lock"), this.tableName, 2);
    }

    @Override
    public String currentTimestampSQL() {
        return String.format(this.sql("current-timestamp"), this.tableName);
    }

    @Override
    public String currentTimestampTimeZoneId() {
        return this.sql("current-timestamp-timezone-id", false);
    }

    @Override
    public String writeStateSQL() {
        return String.format(this.sql("write-state"), this.tableName, 0);
    }

    @Override
    public String readStateSQL() {
        return String.format(this.sql("read-state"), this.tableName, 0);
    }

    @Override
    public String writeNodeIdSQL() {
        return String.format(this.sql("write-nodeId"), this.tableName, 3);
    }

    @Override
    public String readNodeIdSQL() {
        return String.format(this.sql("read-nodeId"), this.tableName, 3);
    }

    @Override
    public String initializeNodeIdSQL() {
        return String.format(this.sql("initialize-nodeId"), this.tableName, 3);
    }

    protected String sql(String key) {
        return this.sql(key, true);
    }

    protected String sql(String key, boolean checkNull) {
        return PropertySQLProvider.sql(key, this.dialect, this.sql, checkNull);
    }

    private static String sql(String key, Factory.SQLDialect dialect, Properties sql, boolean checkNull) {
        String result;
        if (dialect != null && (result = sql.getProperty(key + "." + dialect.getKey())) != null) {
            return result;
        }
        result = sql.getProperty(key);
        if (checkNull && result == null) {
            throw ActiveMQJournalBundle.BUNDLE.propertyNotFound(key, Objects.toString((Object)dialect, null));
        }
        return result;
    }

    public static final class Factory
    implements SQLProvider.Factory {
        private static final String SQL_PROPERTIES_FILE = "journal-sql.properties";
        private SQLDialect dialect;
        private final Properties sql;

        public Factory(SQLDialect dialect) {
            this.dialect = dialect;
            try (InputStream stream = PropertySQLProvider.class.getClassLoader().getResourceAsStream(SQL_PROPERTIES_FILE);){
                this.sql = new Properties();
                this.sql.load(stream);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load properties from journal-sql.properties");
            }
        }

        public Factory(DataSource dataSource) {
            this(new JDBCConnectionProvider(dataSource));
        }

        public Factory(Map<String, Object> dataSourceProperties) {
            this(Factory.investigateDialect(dataSourceProperties));
        }

        public Factory(JDBCConnectionProvider connectionProvider) {
            this(Factory.investigateDialect(connectionProvider));
        }

        public static SQLDialect investigateDialect(Connection connection) {
            SQLDialect dialect = null;
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                String dbProduct = metaData.getDatabaseProductName();
                dialect = Factory.identifyDialect(dbProduct);
                if (dialect == null) {
                    logger.debug("Attempting to guess on driver name.");
                    dialect = Factory.identifyDialect(metaData.getDriverName());
                }
                if (dialect == null) {
                    logger.warn("Unable to detect database dialect from connection metadata or JDBC driver name.");
                } else {
                    logger.debug("Detect database dialect as '{}'.", (Object)dialect);
                }
            }
            catch (Exception e) {
                logger.debug("Unable to read JDBC metadata.", (Throwable)e);
            }
            return dialect;
        }

        public static SQLDialect investigateDialect(Map<String, Object> dataSourceProperties) {
            SQLDialect dialect = null;
            for (Object entry : dataSourceProperties.values()) {
                String string;
                if (!(entry instanceof String) || (dialect = Factory.identifyDialect(string = (String)entry)) == null) continue;
                return dialect;
            }
            return dialect;
        }

        private static SQLDialect investigateDialect(JDBCConnectionProvider connectionProvider) {
            SQLDialect sQLDialect;
            block8: {
                Connection connection = connectionProvider.getConnection();
                try {
                    sQLDialect = Factory.investigateDialect(connection);
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.debug("Unable to read JDBC metadata.", (Throwable)e);
                        return null;
                    }
                }
                connection.close();
            }
            return sQLDialect;
        }

        public static SQLDialect identifyDialect(String name) {
            return SQLDialect.identifyDialect(name);
        }

        @Override
        public SQLProvider create(String tableName, SQLProvider.DatabaseStoreType dbStoreType) {
            if (this.dialect == SQLDialect.ORACLE) {
                return new Oracle12CSQLProvider(tableName, this.sql, dbStoreType);
            }
            return new PropertySQLProvider(this.dialect, tableName, this.sql);
        }

        public static enum SQLDialect {
            ORACLE("oracle", "oracle"),
            POSTGRESQL("postgresql", "postgres"),
            DERBY("derby", "derby"),
            MYSQL("mysql", "mysql", "mariadb"),
            DB2("db2", "db2"),
            HSQL("hsql", "hsql", "hypersonic"),
            H2("h2", "h2"),
            MSSQL("mssql", "microsoft"),
            SYBASE("jconnect", "jconnect");

            private final String key;
            private final String[] driverKeys;

            private SQLDialect(String key, String ... driverKeys) {
                this.key = key;
                this.driverKeys = driverKeys;
            }

            String getKey() {
                return this.key;
            }

            private boolean match(String driverName) {
                for (String driverKey : this.driverKeys) {
                    if (!driverName.contains(driverKey)) continue;
                    return true;
                }
                return false;
            }

            public static SQLDialect identifyDialect(String name) {
                if (name == null) {
                    return null;
                }
                String lowerCaseName = name.toLowerCase();
                return Stream.of(SQLDialect.values()).filter(dialect -> dialect.match(lowerCaseName)).findFirst().orElse(null);
            }
        }
    }

    private static enum LetterCase implements Function<String, String>
    {
        upper(String::toUpperCase),
        lower(String::toLowerCase),
        none(Function.identity());

        private final Function<String, String> transform;

        private LetterCase(Function<String, String> transform) {
            this.transform = transform;
        }

        @Override
        public String apply(String s) {
            return this.transform.apply(s);
        }

        public static LetterCase parse(String value) {
            return LetterCase.valueOf(value);
        }
    }
}

