/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.file.Db2SequentialFileDriver;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.apache.activemq.artemis.jdbc.store.file.PostgresSequentialSequentialFileDriver;
import org.apache.activemq.artemis.jdbc.store.sql.PropertySQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

class JDBCFileUtils {
    JDBCFileUtils() {
    }

    static JDBCSequentialFileFactoryDriver getDBFileDriver(JDBCConnectionProvider connectionProvider, SQLProvider provider) throws SQLException {
        PropertySQLProvider.Factory.SQLDialect sqlDialect;
        try (Connection connection = connectionProvider.getConnection();){
            sqlDialect = PropertySQLProvider.Factory.investigateDialect(connection);
        }
        JDBCSequentialFileFactoryDriver dbDriver = PropertySQLProvider.Factory.SQLDialect.POSTGRESQL.equals((Object)sqlDialect) ? new PostgresSequentialSequentialFileDriver(connectionProvider, provider) : (PropertySQLProvider.Factory.SQLDialect.DB2.equals((Object)sqlDialect) ? new Db2SequentialFileDriver(connectionProvider, provider) : new JDBCSequentialFileFactoryDriver(connectionProvider, provider));
        return dbDriver;
    }
}

