/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactoryProperties
implements ConnectionFactoryOptions {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean hasBeenUpdated = false;
    private List<String> connectorClassName;
    private List<Map<String, Object>> connectionParameters;
    private Boolean ha;
    private String connectionLoadBalancingPolicyClassName;
    private String jgroupsFile;
    private String jgroupsChannelName;
    private String discoveryAddress;
    private Integer discoveryPort;
    private String discoveryLocalBindAddress;
    private Long discoveryRefreshTimeout;
    private Long discoveryInitialWaitTimeout;
    private String clientID;
    private Integer dupsOKBatchSize;
    private Integer transactionBatchSize;
    private Long clientFailureCheckPeriod;
    private Long connectionTTL;
    private Boolean cacheLargeMessagesClient;
    private Long callTimeout;
    private Long callFailoverTimeout;
    private Boolean compressLargeMessage;
    private Integer compressionLevel;
    private Integer consumerWindowSize;
    private Integer producerWindowSize;
    private Integer consumerMaxRate;
    private Integer confirmationWindowSize;
    private Integer producerMaxRate;
    private Integer minLargeMessageSize;
    private Boolean blockOnAcknowledge;
    private Boolean blockOnNonDurableSend;
    private Boolean blockOnDurableSend;
    private Boolean autoGroup;
    private Boolean preAcknowledge;
    private Integer initialConnectAttempts;
    private Long retryInterval;
    private Double retryIntervalMultiplier;
    private Long maxRetryInterval;
    private Integer reconnectAttempts;
    private Boolean useGlobalPools;
    private Boolean cacheDestinations;
    private Boolean enable1xPrefixes;
    private Integer initialMessagePacketSize;
    private Integer scheduledThreadPoolMaxSize;
    private Integer threadPoolMaxSize;
    private String groupID;
    private String protocolManagerFactoryStr;
    private String deserializationDenyList;
    private String deserializationAllowList;
    private Boolean enableSharedClientID;

    public List<String> getParsedConnectorClassNames() {
        return this.connectorClassName;
    }

    public List<Map<String, Object>> getParsedConnectionParameters() {
        return this.connectionParameters;
    }

    public void setParsedConnectionParameters(List<Map<String, Object>> connectionParameters) {
        this.connectionParameters = connectionParameters;
        this.hasBeenUpdated = true;
    }

    public void setParsedConnectorClassNames(List<String> value) {
        this.connectorClassName = value;
        this.hasBeenUpdated = true;
    }

    public Boolean isHA() {
        return this.ha;
    }

    public void setHA(Boolean ha) {
        this.hasBeenUpdated = true;
        this.ha = ha;
    }

    public Boolean isCacheLargeMessagesClient() {
        return this.cacheLargeMessagesClient;
    }

    public void setCacheLargeMessagesClient(Boolean cacheLargeMessagesClient) {
        this.hasBeenUpdated = true;
        this.cacheLargeMessagesClient = cacheLargeMessagesClient;
    }

    public Boolean isCompressLargeMessage() {
        return this.compressLargeMessage;
    }

    public void setCompressLargeMessage(Boolean compressLargeMessage) {
        this.hasBeenUpdated = true;
        this.compressLargeMessage = compressLargeMessage;
    }

    public Integer getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(Integer compressionLevel) {
        this.hasBeenUpdated = true;
        this.compressionLevel = compressionLevel;
    }

    public String getConnectionLoadBalancingPolicyClassName() {
        logger.trace("getConnectionLoadBalancingPolicyClassName()");
        return this.connectionLoadBalancingPolicyClassName;
    }

    public void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        logger.trace("setSessionDefaultType({})", (Object)connectionLoadBalancingPolicyClassName);
        this.hasBeenUpdated = true;
        this.connectionLoadBalancingPolicyClassName = connectionLoadBalancingPolicyClassName;
    }

    public String getDiscoveryAddress() {
        logger.trace("getDiscoveryAddress()");
        return this.discoveryAddress;
    }

    public void setDiscoveryAddress(String discoveryAddress) {
        logger.trace("setDiscoveryAddress({})", (Object)discoveryAddress);
        this.hasBeenUpdated = true;
        this.discoveryAddress = discoveryAddress;
    }

    public Integer getDiscoveryPort() {
        logger.trace("getDiscoveryPort()");
        return this.discoveryPort;
    }

    public void setDiscoveryLocalBindAddress(String discoveryLocalBindAddress) {
        logger.trace("setDiscoveryLocalBindAddress({})", (Object)discoveryLocalBindAddress);
        this.hasBeenUpdated = true;
        this.discoveryLocalBindAddress = discoveryLocalBindAddress;
    }

    public String getDiscoveryLocalBindAddress() {
        logger.trace("getDiscoveryLocalBindAddress()");
        return this.discoveryLocalBindAddress;
    }

    public void setDiscoveryPort(Integer discoveryPort) {
        logger.trace("setDiscoveryPort({})", (Object)discoveryPort);
        this.hasBeenUpdated = true;
        this.discoveryPort = discoveryPort;
    }

    public Long getDiscoveryRefreshTimeout() {
        logger.trace("getDiscoveryRefreshTimeout()");
        return this.discoveryRefreshTimeout;
    }

    public void setDiscoveryRefreshTimeout(Long discoveryRefreshTimeout) {
        logger.trace("setDiscoveryRefreshTimeout({})", (Object)discoveryRefreshTimeout);
        this.hasBeenUpdated = true;
        this.discoveryRefreshTimeout = discoveryRefreshTimeout;
    }

    public Long getDiscoveryInitialWaitTimeout() {
        logger.trace("getDiscoveryInitialWaitTimeout()");
        return this.discoveryInitialWaitTimeout;
    }

    public void setDiscoveryInitialWaitTimeout(Long discoveryInitialWaitTimeout) {
        logger.trace("setDiscoveryInitialWaitTimeout({})", (Object)discoveryInitialWaitTimeout);
        this.hasBeenUpdated = true;
        this.discoveryInitialWaitTimeout = discoveryInitialWaitTimeout;
    }

    public String getClientID() {
        logger.trace("getClientID()");
        return this.clientID;
    }

    public void setClientID(String clientID) {
        logger.trace("setClientID({})", (Object)clientID);
        this.hasBeenUpdated = true;
        this.clientID = clientID;
    }

    public Integer getDupsOKBatchSize() {
        logger.trace("getDupsOKBatchSize()");
        return this.dupsOKBatchSize;
    }

    public void setDupsOKBatchSize(Integer dupsOKBatchSize) {
        logger.trace("setDupsOKBatchSize({})", (Object)dupsOKBatchSize);
        this.hasBeenUpdated = true;
        this.dupsOKBatchSize = dupsOKBatchSize;
    }

    public Integer getTransactionBatchSize() {
        logger.trace("getTransactionBatchSize()");
        return this.transactionBatchSize;
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        logger.trace("setTransactionBatchSize({})", (Object)transactionBatchSize);
        this.hasBeenUpdated = true;
        this.transactionBatchSize = transactionBatchSize;
    }

    public Long getClientFailureCheckPeriod() {
        logger.trace("getClientFailureCheckPeriod()");
        return this.clientFailureCheckPeriod;
    }

    public void setClientFailureCheckPeriod(Long clientFailureCheckPeriod) {
        logger.trace("setClientFailureCheckPeriod({})", (Object)clientFailureCheckPeriod);
        this.hasBeenUpdated = true;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
    }

    public Long getConnectionTTL() {
        logger.trace("getConnectionTTL()");
        return this.connectionTTL;
    }

    public void setConnectionTTL(Long connectionTTL) {
        logger.trace("setConnectionTTL({})", (Object)connectionTTL);
        this.hasBeenUpdated = true;
        this.connectionTTL = connectionTTL;
    }

    public Long getCallTimeout() {
        logger.trace("getCallTimeout()");
        return this.callTimeout;
    }

    public void setCallTimeout(Long callTimeout) {
        logger.trace("setCallTimeout({})", (Object)callTimeout);
        this.hasBeenUpdated = true;
        this.callTimeout = callTimeout;
    }

    public Long getCallFailoverTimeout() {
        logger.trace("getCallFailoverTimeout()");
        return this.callFailoverTimeout;
    }

    public void setCallFailoverTimeout(Long callFailoverTimeout) {
        logger.trace("setCallFailoverTimeout({})", (Object)callFailoverTimeout);
        this.hasBeenUpdated = true;
        this.callFailoverTimeout = callFailoverTimeout;
    }

    public Integer getConsumerWindowSize() {
        logger.trace("getConsumerWindowSize()");
        return this.consumerWindowSize;
    }

    public void setConsumerWindowSize(Integer consumerWindowSize) {
        logger.trace("setConsumerWindowSize({})", (Object)consumerWindowSize);
        this.hasBeenUpdated = true;
        this.consumerWindowSize = consumerWindowSize;
    }

    public Integer getConsumerMaxRate() {
        logger.trace("getConsumerMaxRate()");
        return this.consumerMaxRate;
    }

    public void setConsumerMaxRate(Integer consumerMaxRate) {
        logger.trace("setConsumerMaxRate({})", (Object)consumerMaxRate);
        this.hasBeenUpdated = true;
        this.consumerMaxRate = consumerMaxRate;
    }

    public Integer getConfirmationWindowSize() {
        logger.trace("getConfirmationWindowSize()");
        return this.confirmationWindowSize;
    }

    public void setConfirmationWindowSize(Integer confirmationWindowSize) {
        logger.trace("setConfirmationWindowSize({})", (Object)confirmationWindowSize);
        this.hasBeenUpdated = true;
        this.confirmationWindowSize = confirmationWindowSize;
    }

    @Deprecated
    public Boolean isFailoverOnInitialConnection() {
        return false;
    }

    @Deprecated
    public void setFailoverOnInitialConnection(Boolean failoverOnInitialConnection) {
    }

    public Integer getProducerMaxRate() {
        logger.trace("getProducerMaxRate()");
        return this.producerMaxRate;
    }

    public void setProducerMaxRate(Integer producerMaxRate) {
        logger.trace("setProducerMaxRate({})", (Object)producerMaxRate);
        this.hasBeenUpdated = true;
        this.producerMaxRate = producerMaxRate;
    }

    public Integer getProducerWindowSize() {
        logger.trace("getProducerWindowSize()");
        return this.producerWindowSize;
    }

    public void setProducerWindowSize(Integer producerWindowSize) {
        logger.trace("setProducerWindowSize({})", (Object)producerWindowSize);
        this.hasBeenUpdated = true;
        this.producerWindowSize = producerWindowSize;
    }

    public Integer getMinLargeMessageSize() {
        logger.trace("getMinLargeMessageSize()");
        return this.minLargeMessageSize;
    }

    public void setMinLargeMessageSize(Integer minLargeMessageSize) {
        logger.trace("setMinLargeMessageSize({})", (Object)minLargeMessageSize);
        this.hasBeenUpdated = true;
        this.minLargeMessageSize = minLargeMessageSize;
    }

    public Boolean isBlockOnAcknowledge() {
        logger.trace("isBlockOnAcknowledge()");
        return this.blockOnAcknowledge;
    }

    public void setBlockOnAcknowledge(Boolean blockOnAcknowledge) {
        logger.trace("setBlockOnAcknowledge({})", (Object)blockOnAcknowledge);
        this.hasBeenUpdated = true;
        this.blockOnAcknowledge = blockOnAcknowledge;
    }

    public Boolean isBlockOnNonDurableSend() {
        logger.trace("isBlockOnNonDurableSend()");
        return this.blockOnNonDurableSend;
    }

    public void setBlockOnNonDurableSend(Boolean blockOnNonDurableSend) {
        logger.trace("setBlockOnNonDurableSend({})", (Object)blockOnNonDurableSend);
        this.hasBeenUpdated = true;
        this.blockOnNonDurableSend = blockOnNonDurableSend;
    }

    public Boolean isBlockOnDurableSend() {
        logger.trace("isBlockOnDurableSend()");
        return this.blockOnDurableSend;
    }

    public void setBlockOnDurableSend(Boolean blockOnDurableSend) {
        logger.trace("setBlockOnDurableSend({})", (Object)blockOnDurableSend);
        this.hasBeenUpdated = true;
        this.blockOnDurableSend = blockOnDurableSend;
    }

    public Boolean isAutoGroup() {
        logger.trace("isAutoGroup()");
        return this.autoGroup;
    }

    public void setAutoGroup(Boolean autoGroup) {
        logger.trace("setAutoGroup({})", (Object)autoGroup);
        this.hasBeenUpdated = true;
        this.autoGroup = autoGroup;
    }

    public Boolean isPreAcknowledge() {
        logger.trace("isPreAcknowledge()");
        return this.preAcknowledge;
    }

    public void setPreAcknowledge(Boolean preAcknowledge) {
        logger.trace("setPreAcknowledge({})", (Object)preAcknowledge);
        this.hasBeenUpdated = true;
        this.preAcknowledge = preAcknowledge;
    }

    public Long getRetryInterval() {
        logger.trace("getRetryInterval()");
        return this.retryInterval;
    }

    public void setRetryInterval(Long retryInterval) {
        logger.trace("setRetryInterval({})", (Object)retryInterval);
        this.hasBeenUpdated = true;
        this.retryInterval = retryInterval;
    }

    public Double getRetryIntervalMultiplier() {
        logger.trace("getRetryIntervalMultiplier()");
        return this.retryIntervalMultiplier;
    }

    public void setRetryIntervalMultiplier(Double retryIntervalMultiplier) {
        logger.trace("setRetryIntervalMultiplier({})", (Object)retryIntervalMultiplier);
        this.hasBeenUpdated = true;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
    }

    public Long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public void setMaxRetryInterval(Long maxRetryInterval) {
        this.hasBeenUpdated = true;
        this.maxRetryInterval = maxRetryInterval;
    }

    public Integer getReconnectAttempts() {
        logger.trace("getReconnectAttempts()");
        return this.reconnectAttempts;
    }

    public void setReconnectAttempts(Integer reconnectAttempts) {
        logger.trace("setReconnectAttempts({})", (Object)reconnectAttempts);
        this.hasBeenUpdated = true;
        this.reconnectAttempts = reconnectAttempts;
    }

    public Boolean isUseGlobalPools() {
        logger.trace("isUseGlobalPools()");
        return this.useGlobalPools;
    }

    public void setUseGlobalPools(Boolean useGlobalPools) {
        logger.trace("setUseGlobalPools({})", (Object)useGlobalPools);
        this.hasBeenUpdated = true;
        this.useGlobalPools = useGlobalPools;
    }

    public Boolean isCacheDestinations() {
        logger.trace("isCacheDestinations()");
        return this.cacheDestinations;
    }

    public void setCacheDestinations(Boolean cacheDestinations) {
        logger.trace("setCacheDestinations({})", (Object)cacheDestinations);
        this.hasBeenUpdated = true;
        this.cacheDestinations = cacheDestinations;
    }

    public Boolean isEnable1xPrefixes() {
        logger.trace("isEnable1xPrefixes()");
        return this.enable1xPrefixes;
    }

    public void setEnable1xPrefixes(Boolean enable1xPrefixes) {
        logger.trace("setEnable1xPrefixes({})", (Object)enable1xPrefixes);
        this.hasBeenUpdated = true;
        this.enable1xPrefixes = enable1xPrefixes;
    }

    public Integer getScheduledThreadPoolMaxSize() {
        logger.trace("getScheduledThreadPoolMaxSize()");
        return this.scheduledThreadPoolMaxSize;
    }

    public void setScheduledThreadPoolMaxSize(Integer scheduledThreadPoolMaxSize) {
        logger.trace("setScheduledThreadPoolMaxSize({})", (Object)scheduledThreadPoolMaxSize);
        this.hasBeenUpdated = true;
        this.scheduledThreadPoolMaxSize = scheduledThreadPoolMaxSize;
    }

    public Integer getThreadPoolMaxSize() {
        logger.trace("getThreadPoolMaxSize()");
        return this.threadPoolMaxSize;
    }

    public void setThreadPoolMaxSize(Integer threadPoolMaxSize) {
        logger.trace("setThreadPoolMaxSize({})", (Object)threadPoolMaxSize);
        this.hasBeenUpdated = true;
        this.threadPoolMaxSize = threadPoolMaxSize;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public void setGroupID(String groupID) {
        this.hasBeenUpdated = true;
        this.groupID = groupID;
    }

    public Integer getInitialConnectAttempts() {
        return this.initialConnectAttempts;
    }

    public void setInitialConnectAttempts(Integer initialConnectAttempts) {
        this.hasBeenUpdated = true;
        this.initialConnectAttempts = initialConnectAttempts;
    }

    public Integer getInitialMessagePacketSize() {
        return this.initialMessagePacketSize;
    }

    public void setInitialMessagePacketSize(Integer initialMessagePacketSize) {
        this.hasBeenUpdated = true;
        this.initialMessagePacketSize = initialMessagePacketSize;
    }

    public String getJgroupsFile() {
        return this.jgroupsFile;
    }

    public void setJgroupsFile(String jgroupsFile) {
        this.jgroupsFile = jgroupsFile;
        this.hasBeenUpdated = true;
    }

    public String getJgroupsChannelName() {
        return this.jgroupsChannelName;
    }

    public void setJgroupsChannelName(String jgroupsChannelName) {
        this.jgroupsChannelName = jgroupsChannelName;
        this.hasBeenUpdated = true;
    }

    public String getProtocolManagerFactoryStr() {
        return this.protocolManagerFactoryStr;
    }

    public void setProtocolManagerFactoryStr(String protocolManagerFactoryStr) {
        this.protocolManagerFactoryStr = protocolManagerFactoryStr;
    }

    @Deprecated(forRemoval=true)
    public String getDeserializationBlackList() {
        return this.deserializationDenyList;
    }

    @Deprecated(forRemoval=true)
    public void setDeserializationBlackList(String deserializationDenyList) {
        this.deserializationDenyList = deserializationDenyList;
        this.hasBeenUpdated = true;
    }

    @Deprecated(forRemoval=true)
    public String getDeserializationWhiteList() {
        return this.deserializationAllowList;
    }

    @Deprecated(forRemoval=true)
    public void setDeserializationWhiteList(String deserializationAllowList) {
        this.deserializationAllowList = deserializationAllowList;
        this.hasBeenUpdated = true;
    }

    public String getDeserializationDenyList() {
        return this.deserializationDenyList;
    }

    public void setDeserializationDenyList(String deserializationDenyList) {
        this.deserializationDenyList = deserializationDenyList;
        this.hasBeenUpdated = true;
    }

    public String getDeserializationAllowList() {
        return this.deserializationAllowList;
    }

    public void setDeserializationAllowList(String deserializationAllowList) {
        this.deserializationAllowList = deserializationAllowList;
        this.hasBeenUpdated = true;
    }

    public boolean isHasBeenUpdated() {
        return this.hasBeenUpdated;
    }

    public void setEnableSharedClientID(boolean enable) {
        this.enableSharedClientID = enable;
    }

    public boolean isEnableSharedClientID() {
        return Objects.requireNonNullElse(this.enableSharedClientID, false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConnectionFactoryProperties)) {
            return false;
        }
        ConnectionFactoryProperties other = (ConnectionFactoryProperties)obj;
        return Objects.equals(this.autoGroup, other.autoGroup) && Objects.equals(this.blockOnAcknowledge, other.blockOnAcknowledge) && Objects.equals(this.blockOnDurableSend, other.blockOnDurableSend) && Objects.equals(this.blockOnNonDurableSend, other.blockOnNonDurableSend) && Objects.equals(this.cacheLargeMessagesClient, other.cacheLargeMessagesClient) && Objects.equals(this.compressLargeMessage, other.compressLargeMessage) && Objects.equals(this.ha, other.ha) && Objects.equals(this.preAcknowledge, other.preAcknowledge) && Objects.equals(this.callFailoverTimeout, other.callFailoverTimeout) && Objects.equals(this.callTimeout, other.callTimeout) && Objects.equals(this.clientFailureCheckPeriod, other.clientFailureCheckPeriod) && Objects.equals(this.clientID, other.clientID) && Objects.equals(this.confirmationWindowSize, other.confirmationWindowSize) && Objects.equals(this.connectionLoadBalancingPolicyClassName, other.connectionLoadBalancingPolicyClassName) && Objects.equals(this.connectionTTL, other.connectionTTL) && Objects.equals(this.consumerMaxRate, other.consumerMaxRate) && Objects.equals(this.consumerWindowSize, other.consumerWindowSize) && Objects.equals(this.discoveryAddress, other.discoveryAddress) && Objects.equals(this.discoveryInitialWaitTimeout, other.discoveryInitialWaitTimeout) && Objects.equals(this.discoveryLocalBindAddress, other.discoveryLocalBindAddress) && Objects.equals(this.discoveryPort, other.discoveryPort) && Objects.equals(this.discoveryRefreshTimeout, other.discoveryRefreshTimeout) && Objects.equals(this.dupsOKBatchSize, other.dupsOKBatchSize) && Objects.equals(this.groupID, other.groupID) && Objects.equals(this.initialConnectAttempts, other.initialConnectAttempts) && Objects.equals(this.initialMessagePacketSize, other.initialMessagePacketSize) && Objects.equals(this.jgroupsChannelName, other.jgroupsChannelName) && Objects.equals(this.jgroupsFile, other.jgroupsFile) && Objects.equals(this.maxRetryInterval, other.maxRetryInterval) && Objects.equals(this.minLargeMessageSize, other.minLargeMessageSize) && Objects.equals(this.producerMaxRate, other.producerMaxRate) && Objects.equals(this.producerWindowSize, other.producerWindowSize) && Objects.equals(this.protocolManagerFactoryStr, other.protocolManagerFactoryStr) && Objects.equals(this.reconnectAttempts, other.reconnectAttempts) && Objects.equals(this.retryInterval, other.retryInterval) && Objects.equals(this.retryIntervalMultiplier, other.retryIntervalMultiplier) && Objects.equals(this.scheduledThreadPoolMaxSize, other.scheduledThreadPoolMaxSize) && Objects.equals(this.threadPoolMaxSize, other.threadPoolMaxSize) && Objects.equals(this.transactionBatchSize, other.transactionBatchSize) && Objects.equals(this.useGlobalPools, other.useGlobalPools) && Objects.equals(this.connectorClassName, other.connectorClassName) && Objects.equals(this.connectionParameters, other.connectionParameters) && Objects.equals(this.deserializationDenyList, other.deserializationDenyList) && Objects.equals(this.deserializationAllowList, other.deserializationAllowList) && Objects.equals(this.enable1xPrefixes, other.enable1xPrefixes) && Objects.equals(this.enableSharedClientID, other.enableSharedClientID);
    }

    public int hashCode() {
        return Objects.hash(this.ha, this.connectionLoadBalancingPolicyClassName, this.jgroupsFile, this.jgroupsChannelName, this.discoveryAddress, this.discoveryPort, this.discoveryLocalBindAddress, this.discoveryRefreshTimeout, this.discoveryInitialWaitTimeout, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, this.clientFailureCheckPeriod, this.connectionTTL, this.cacheLargeMessagesClient, this.callTimeout, this.callFailoverTimeout, this.compressLargeMessage, this.consumerWindowSize, this.producerWindowSize, this.protocolManagerFactoryStr, this.consumerMaxRate, this.confirmationWindowSize, this.producerMaxRate, this.minLargeMessageSize, this.blockOnAcknowledge, this.blockOnNonDurableSend, this.blockOnDurableSend, this.autoGroup, this.preAcknowledge, this.initialConnectAttempts, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, this.reconnectAttempts, this.useGlobalPools, this.initialMessagePacketSize, this.scheduledThreadPoolMaxSize, this.threadPoolMaxSize, this.groupID, this.connectorClassName, this.connectionParameters, this.deserializationDenyList, this.deserializationAllowList, this.enable1xPrefixes, this.enableSharedClientID);
    }
}

