/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.lang.invoke.MethodHandles;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.activemq.artemis.ra.ActiveMQRAMessageConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRAMessageListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MessageListener listener;
    private final ActiveMQRAMessageConsumer consumer;

    public ActiveMQRAMessageListener(MessageListener listener, ActiveMQRAMessageConsumer consumer) {
        logger.trace("constructor({}, {})", (Object)listener, (Object)consumer);
        this.listener = listener;
        this.consumer = consumer;
    }

    public void onMessage(Message message) {
        logger.trace("onMessage({})", (Object)message);
        message = this.consumer.wrapMessage(message);
        this.listener.onMessage(message);
    }
}

