/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAddressPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationCapabilities;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationEventDispatcher;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationEventProcessor;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationLocalPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationQueuePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationRemoteAddressPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationRemotePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationRemoteQueuePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationSenderController;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.ActiveMQServerAMQPFederationPlugin;
import org.apache.activemq.artemis.protocol.amqp.federation.Federation;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.qpid.proton.engine.Link;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQPFederation
implements Federation {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String FEDERATION_INSTANCE_RECORD = "FEDERATION_INSTANCE_RECORD";
    protected final Map<String, AMQPFederationQueuePolicyManager> localQueuePolicyManagers = new ConcurrentHashMap<String, AMQPFederationQueuePolicyManager>();
    protected final Map<String, AMQPFederationAddressPolicyManager> localAddressPolicyManagers = new ConcurrentHashMap<String, AMQPFederationAddressPolicyManager>();
    protected final Map<String, Predicate<Link>> linkClosedinterceptors = new ConcurrentHashMap<String, Predicate<Link>>();
    protected final Map<String, AMQPFederationRemoteAddressPolicyManager> remoteAddressPolicyManagers = new HashMap<String, AMQPFederationRemoteAddressPolicyManager>();
    protected final Map<String, AMQPFederationRemoteQueuePolicyManager> remoteQueuePolicyManagers = new HashMap<String, AMQPFederationRemoteQueuePolicyManager>();
    protected final WildcardConfiguration wildcardConfiguration;
    protected final ScheduledExecutorService scheduler;
    protected final String name;
    protected final ActiveMQServer server;
    protected final AMQPFederationMetrics metrics = new AMQPFederationMetrics();
    protected AMQPFederationEventDispatcher eventDispatcher;
    protected AMQPFederationEventProcessor eventProcessor;
    protected volatile AMQPConnectionContext connection;
    protected volatile AMQPSessionContext session;
    protected volatile State state = State.UNINITIALIZED;
    protected volatile boolean connected;

    public AMQPFederation(String name, ActiveMQServer server) {
        Objects.requireNonNull(name, "Federation name cannot be null");
        Objects.requireNonNull(server, "Provided server instance cannot be null");
        this.name = name;
        this.server = server;
        this.scheduler = server.getScheduledPool();
        this.wildcardConfiguration = server.getConfiguration().getWildcardConfiguration() != null ? server.getConfiguration().getWildcardConfiguration() : WildcardConfiguration.DEFAULT_WILDCARD_CONFIGURATION;
    }

    public WildcardConfiguration getWildcardConfiguration() {
        return this.wildcardConfiguration;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public ActiveMQServer getServer() {
        return this.server;
    }

    public AMQPFederationMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isStarted() {
        return this.state == State.STARTED;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public abstract AMQPConnectionContext getConnectionContext();

    public abstract AMQPSessionContext getSessionContext();

    public abstract AMQPFederationConfiguration getConfiguration();

    public abstract AMQPFederationCapabilities getCapabilities();

    public final synchronized void initialize() throws ActiveMQException {
        this.failIfShutdown();
        if (this.state == State.UNINITIALIZED) {
            this.state = State.STOPPED;
            this.handleFederationInitialized();
            try {
                this.registerFederationManagement();
            }
            catch (Exception e) {
                logger.warn("Ignoring error while attempting to register federation with management services");
            }
        }
    }

    public final synchronized void start() throws ActiveMQException {
        this.failIfShutdown();
        if (this.state.ordinal() < State.STOPPED.ordinal()) {
            throw new ActiveMQIllegalStateException("The federation has not been initialized and cannot be started.");
        }
        if (this.state == State.STOPPED) {
            this.state = State.STARTED;
            this.startAllPolicyManagers();
            this.handleFederationStarted();
            this.signalFederationStarted();
        }
    }

    public final synchronized void stop() throws ActiveMQException {
        if (this.state.ordinal() < State.STOPPED.ordinal()) {
            throw new ActiveMQIllegalStateException("The federation has not been initialized and cannot be stopped.");
        }
        if (this.state == State.STARTED) {
            this.state = State.STOPPED;
            this.stopAllPolicyManagers();
            this.handleFederationStopped();
            this.signalFederationStopped();
        }
    }

    public final synchronized void shutdown() throws ActiveMQException {
        if (this.state.ordinal() < State.SHUTDOWN.ordinal()) {
            this.state = State.SHUTDOWN;
            this.shutdownAllPolicyManagers();
            this.handleFederationShutdown();
            try {
                this.unregisterFederationManagement();
            }
            catch (Exception e) {
                logger.warn("Ignoring error while attempting to unregister federation with management services");
            }
            try {
                if (this.eventDispatcher != null) {
                    this.eventDispatcher.close(false);
                }
                if (this.eventProcessor != null) {
                    this.eventProcessor.close(false);
                }
            }
            catch (ActiveMQException amqEx) {
                throw amqEx;
            }
            catch (Exception ex) {
                throw (ActiveMQException)new ActiveMQException(ex.getMessage()).initCause((Throwable)ex);
            }
            finally {
                this.eventDispatcher = null;
                this.eventProcessor = null;
            }
        }
    }

    String prefixEventsLinkQueueName(String suffix) {
        StringBuilder builder = new StringBuilder();
        char delimiter = this.getWildcardConfiguration().getDelimiter();
        builder.append("$ACTIVEMQ_ARTEMIS_FEDERATION").append(delimiter).append("events").append(delimiter).append(suffix);
        return builder.toString();
    }

    String prefixControlLinkQueueName(String suffix) {
        StringBuilder builder = new StringBuilder();
        char delimiter = this.getWildcardConfiguration().getDelimiter();
        builder.append("$ACTIVEMQ_ARTEMIS_FEDERATION").append(delimiter).append("control").append(delimiter).append(suffix);
        return builder.toString();
    }

    public AMQPFederation addLinkClosedInterceptor(String id, Predicate<Link> interceptor) {
        this.linkClosedinterceptors.put(id, interceptor);
        return this;
    }

    public AMQPFederation removeLinkClosedInterceptor(String id) {
        this.linkClosedinterceptors.remove(id);
        return this;
    }

    public synchronized AMQPFederation addQueueMatchPolicy(FederationReceiveFromQueuePolicy queuePolicy) throws ActiveMQException {
        AMQPFederationQueuePolicyManager manager = new AMQPFederationQueuePolicyManager(this, this.metrics.newPolicyMetrics(), queuePolicy);
        this.localQueuePolicyManagers.put(queuePolicy.getPolicyName(), manager);
        logger.debug("AMQP Federation {} adding queue match policy: {}", (Object)this.getName(), (Object)queuePolicy.getPolicyName());
        manager.initialize();
        if (this.isConnected()) {
            manager.connectionRestored();
        }
        if (this.isStarted()) {
            this.scheduler.execute(() -> manager.start());
        }
        return this;
    }

    public synchronized AMQPFederation addAddressMatchPolicy(FederationReceiveFromAddressPolicy addressPolicy) throws ActiveMQException {
        AMQPFederationAddressPolicyManager manager = new AMQPFederationAddressPolicyManager(this, this.metrics.newPolicyMetrics(), addressPolicy);
        this.localAddressPolicyManagers.put(addressPolicy.getPolicyName(), manager);
        logger.debug("AMQP Federation {} adding address match policy: {}", (Object)this.getName(), (Object)addressPolicy.getPolicyName());
        manager.initialize();
        if (this.isConnected()) {
            manager.connectionRestored();
        }
        if (this.isStarted()) {
            this.scheduler.execute(() -> manager.start());
        }
        return this;
    }

    public synchronized AMQPFederationRemoteAddressPolicyManager getRemoteAddressPolicyManager(String policyName) {
        if (!this.remoteAddressPolicyManagers.containsKey(policyName)) {
            AMQPFederationRemoteAddressPolicyManager manager = new AMQPFederationRemoteAddressPolicyManager(this, this.metrics.newPolicyMetrics(), policyName);
            manager.initialize();
            if (this.isConnected()) {
                manager.connectionRestored();
            }
            if (this.isStarted()) {
                manager.start();
            }
            this.remoteAddressPolicyManagers.put(policyName, manager);
        }
        return this.remoteAddressPolicyManagers.get(policyName);
    }

    public synchronized AMQPFederationRemoteQueuePolicyManager getRemoteQueuePolicyManager(String policyName) {
        if (!this.remoteQueuePolicyManagers.containsKey(policyName)) {
            AMQPFederationRemoteQueuePolicyManager manager = new AMQPFederationRemoteQueuePolicyManager(this, this.metrics.newPolicyMetrics(), policyName);
            manager.initialize();
            if (this.isConnected()) {
                manager.connectionRestored();
            }
            if (this.isStarted()) {
                manager.start();
            }
            this.remoteQueuePolicyManagers.put(policyName, manager);
        }
        return this.remoteQueuePolicyManagers.get(policyName);
    }

    synchronized void registerEventSender(AMQPFederationEventDispatcher dispatcher) {
        if (this.eventDispatcher != null) {
            throw new IllegalStateException("Federation event dispatcher already registered on this federation instance.");
        }
        this.eventDispatcher = dispatcher;
    }

    synchronized void registerEventReceiver(AMQPFederationEventProcessor processor) {
        if (this.eventProcessor != null) {
            throw new IllegalStateException("Federation event processor already registered on this federation instance.");
        }
        this.eventProcessor = processor;
    }

    synchronized void registerMissingAddress(String address) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.addAddressWatch(address);
        }
    }

    synchronized void registerMissingQueue(String queue) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.addQueueWatch(queue);
        }
    }

    synchronized void processRemoteAddressAdded(String addressName) {
        this.localAddressPolicyManagers.values().forEach(policy -> {
            try {
                policy.afterRemoteAddressAdded(addressName);
            }
            catch (Exception e) {
                logger.warn("Error processing remote address added event: ", (Throwable)e);
                this.signalError(e);
            }
        });
    }

    synchronized void processRemoteQueueAdded(String addressName, String queueName) {
        this.localQueuePolicyManagers.values().forEach(policy -> {
            try {
                policy.afterRemoteQueueAdded(addressName, queueName);
            }
            catch (Exception e) {
                logger.warn("Error processing remote queue added event: ", (Throwable)e);
                this.signalError(e);
            }
        });
    }

    protected abstract void signalResourceCreateError(Exception var1);

    protected abstract void signalError(Exception var1);

    protected void handleFederationInitialized() throws ActiveMQException {
    }

    protected void handleFederationStarted() throws ActiveMQException {
    }

    protected void handleFederationStopped() throws ActiveMQException {
    }

    protected void handleFederationShutdown() throws ActiveMQException {
    }

    private void startAllPolicyManagers() throws ActiveMQException {
        this.localAddressPolicyManagers.forEach((nname, manager) -> manager.start());
        this.localQueuePolicyManagers.forEach((nname, manager) -> manager.start());
        this.remoteAddressPolicyManagers.forEach((name, manager) -> manager.start());
        this.remoteQueuePolicyManagers.forEach((name, manager) -> manager.start());
    }

    private void stopAllPolicyManagers() throws ActiveMQException {
        this.localAddressPolicyManagers.forEach((nname, manager) -> manager.stop());
        this.localQueuePolicyManagers.forEach((nname, manager) -> manager.stop());
        this.remoteAddressPolicyManagers.forEach((name, manager) -> manager.stop());
        this.remoteQueuePolicyManagers.forEach((name, manager) -> manager.stop());
    }

    private void shutdownAllPolicyManagers() throws ActiveMQException {
        try {
            this.localAddressPolicyManagers.forEach((nname, manager) -> manager.shutdown());
            this.localQueuePolicyManagers.forEach((nname, manager) -> manager.shutdown());
            this.remoteAddressPolicyManagers.forEach((nname, manager) -> manager.shutdown());
            this.remoteQueuePolicyManagers.forEach((nname, manager) -> manager.shutdown());
        }
        finally {
            this.localQueuePolicyManagers.clear();
            this.localAddressPolicyManagers.clear();
            this.remoteQueuePolicyManagers.clear();
            this.remoteAddressPolicyManagers.clear();
        }
    }

    protected final boolean invokeLinkClosedInterceptors(Link link) {
        for (Map.Entry<String, Predicate<Link>> interceptor : this.linkClosedinterceptors.entrySet()) {
            if (!interceptor.getValue().test(link)) continue;
            logger.trace("Remote link[{}] close intercepted and handled by interceptor: {}", (Object)link.getName(), (Object)interceptor.getKey());
            return true;
        }
        return false;
    }

    protected final void signalFederationStarted() {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ActiveMQServerAMQPFederationPlugin federationPlugin = (ActiveMQServerAMQPFederationPlugin)plugin;
                    federationPlugin.federationStarted(this);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("federationStarted", (Throwable)t);
        }
    }

    protected final void signalFederationStopped() {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ActiveMQServerAMQPFederationPlugin federationPlugin = (ActiveMQServerAMQPFederationPlugin)plugin;
                    federationPlugin.federationStopped(this);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("federationStopped", (Throwable)t);
        }
    }

    private void failIfShutdown() throws ActiveMQIllegalStateException {
        if (this.state == State.SHUTDOWN) {
            throw new ActiveMQIllegalStateException("The federation instance has been shutdown");
        }
    }

    abstract void registerFederationManagement() throws Exception;

    abstract void unregisterFederationManagement() throws Exception;

    abstract void registerLocalPolicyManagement(AMQPFederationLocalPolicyManager var1) throws Exception;

    abstract void unregisterLocalPolicyManagement(AMQPFederationLocalPolicyManager var1) throws Exception;

    abstract void registerRemotePolicyManagement(AMQPFederationRemotePolicyManager var1) throws Exception;

    abstract void unregisterRemotePolicyManagement(AMQPFederationRemotePolicyManager var1) throws Exception;

    abstract void registerFederationConsumerManagement(AMQPFederationConsumer var1) throws Exception;

    abstract void unregisterFederationConsumerManagement(AMQPFederationConsumer var1) throws Exception;

    abstract void registerFederationProducerManagement(AMQPFederationSenderController var1) throws Exception;

    abstract void unregisterFederationProducerManagement(AMQPFederationSenderController var1) throws Exception;

    private static enum State {
        UNINITIALIZED,
        STOPPED,
        STARTED,
        SHUTDOWN;

    }
}

