/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.hornetq;

import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.core.impl.CoreProtocolManagerFactory;
import org.apache.activemq.artemis.core.protocol.hornetq.HQFilterConversionInterceptor;
import org.apache.activemq.artemis.core.protocol.hornetq.HQPropertiesConversionInterceptor;
import org.apache.activemq.artemis.core.protocol.hornetq.HornetQProtocolManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.utils.uri.BeanSupport;
import org.osgi.service.component.annotations.Component;

@Component(service={ProtocolManagerFactory.class})
public class HornetQProtocolManagerFactory
extends CoreProtocolManagerFactory {
    public static final String HORNETQ_PROTOCOL_NAME = "HORNETQ";
    private static final String MODULE_NAME = "artemis-hornetq-protocol";
    private static String[] SUPPORTED_PROTOCOLS = new String[]{"HORNETQ"};

    public ProtocolManager createProtocolManager(ActiveMQServer server, Map<String, Object> parameters, List<BaseInterceptor> incomingInterceptors, List<BaseInterceptor> outgoingInterceptors) throws Exception {
        List hqIncoming = this.filterInterceptors(incomingInterceptors);
        List hqOutgoing = this.filterInterceptors(outgoingInterceptors);
        hqIncoming.add(new HQPropertiesConversionInterceptor(true));
        hqIncoming.add(new HQFilterConversionInterceptor());
        hqOutgoing.add(new HQPropertiesConversionInterceptor(false));
        BeanSupport.stripPasswords(parameters);
        return (ProtocolManager)BeanSupport.setData((Object)((Object)new HornetQProtocolManager(this, server, hqIncoming, hqOutgoing)), parameters);
    }

    public String[] getProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

