/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire;

import java.util.Map;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireConnection;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManager;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireRoutingContext;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.routing.RoutingHandler;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionInfo;

public class OpenWireRoutingHandler
extends RoutingHandler<OpenWireRoutingContext> {
    private final OpenWireProtocolManager protocolManager;

    protected OpenWireRoutingHandler(ActiveMQServer server, OpenWireProtocolManager protocolManager) {
        super(server);
        this.protocolManager = protocolManager;
    }

    public boolean route(OpenWireConnection openWireConnection, ConnectionInfo connectionInfo) throws Exception {
        if (!connectionInfo.isFaultTolerant()) {
            throw new IllegalStateException("Client not fault tolerant");
        }
        return this.route(new OpenWireRoutingContext(openWireConnection, connectionInfo));
    }

    protected void refuse(OpenWireRoutingContext context) throws Exception {
    }

    protected void redirect(OpenWireRoutingContext context) throws Exception {
        String host = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", (Map)context.getTarget().getConnector().getParams());
        int port = ConfigurationHelper.getIntProperty((String)"port", (int)61616, (Map)context.getTarget().getConnector().getParams());
        ConnectionControl command = this.protocolManager.newConnectionControl();
        command.setConnectedBrokers(String.format("tcp://%s:%d", host, port));
        command.setRebalanceConnection(true);
        context.getOpenWireConnection().dispatchSync((Command)command);
    }
}

