/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacket;

public class SessionReceiveMessage
extends MessagePacket {
    protected long consumerID;
    protected int deliveryCount;

    public SessionReceiveMessage(long consumerID, ICoreMessage message, int deliveryCount) {
        super((byte)75, message);
        this.consumerID = consumerID;
        this.deliveryCount = deliveryCount;
    }

    public SessionReceiveMessage(CoreMessage message) {
        super((byte)75, message);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    @Override
    public int expectedEncodeSize() {
        return this.message.getEncodeSize() + 13 + 8 + 4;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        this.message.sendBuffer(buffer.byteBuf(), this.deliveryCount);
        buffer.writeLong(this.consumerID);
        buffer.writeInt(this.deliveryCount);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.receiveMessage(SessionReceiveMessage.copyMessageBuffer(buffer.byteBuf(), 12));
        buffer.readerIndex(buffer.capacity() - 8 - 4);
        this.consumerID = buffer.readLong();
        this.deliveryCount = buffer.readInt();
    }

    protected void receiveMessage(ByteBuf buffer) {
        this.message.receiveBuffer(buffer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.consumerID, this.deliveryCount);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", consumerID=" + this.consumerID);
        sb.append(", deliveryCount=" + this.deliveryCount);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionReceiveMessage)) {
            return false;
        }
        SessionReceiveMessage other = (SessionReceiveMessage)obj;
        return this.consumerID == other.consumerID && this.deliveryCount == other.deliveryCount;
    }
}

