/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.impl.QueueQueryImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.server.QueueQueryResult;

public class SessionQueueQueryResponseMessage
extends PacketImpl {
    protected SimpleString name;
    protected boolean exists;
    protected boolean durable;
    protected int consumerCount;
    protected long messageCount;
    protected SimpleString filterString;
    protected SimpleString address;
    protected boolean temporary;

    public SessionQueueQueryResponseMessage(QueueQueryResult result) {
        this(result.getName(), result.getAddress(), result.isDurable(), result.isTemporary(), result.getFilterString(), result.getConsumerCount(), result.getMessageCount(), result.isExists());
    }

    public SessionQueueQueryResponseMessage() {
        this(null, null, false, false, null, 0, 0L, false);
    }

    public SessionQueueQueryResponseMessage(byte v) {
        super(v);
    }

    private SessionQueueQueryResponseMessage(SimpleString name, SimpleString address, boolean durable, boolean temporary, SimpleString filterString, int consumerCount, long messageCount, boolean exists) {
        super((byte)46);
        this.durable = durable;
        this.temporary = temporary;
        this.consumerCount = consumerCount;
        this.messageCount = messageCount;
        this.filterString = filterString;
        this.address = address;
        this.name = name;
        this.exists = exists;
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public boolean isExists() {
        return this.exists;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public int getConsumerCount() {
        return this.consumerCount;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public SimpleString getName() {
        return this.name;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeBoolean(this.exists);
        buffer.writeBoolean(this.durable);
        buffer.writeBoolean(this.temporary);
        buffer.writeInt(this.consumerCount);
        buffer.writeLong(this.messageCount);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeNullableSimpleString(this.address);
        buffer.writeNullableSimpleString(this.name);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.exists = buffer.readBoolean();
        this.durable = buffer.readBoolean();
        this.temporary = buffer.readBoolean();
        this.consumerCount = buffer.readInt();
        this.messageCount = buffer.readLong();
        this.filterString = buffer.readNullableSimpleString();
        this.address = buffer.readNullableSimpleString();
        this.name = buffer.readNullableSimpleString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.address, this.consumerCount, this.durable, this.exists, this.filterString, this.messageCount, this.name, this.temporary);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", address=" + String.valueOf(this.address));
        sb.append(", name=" + String.valueOf(this.name));
        sb.append(", consumerCount=" + this.consumerCount);
        sb.append(", filterString=" + String.valueOf(this.filterString));
        sb.append(", durable=" + this.durable);
        sb.append(", exists=" + this.exists);
        sb.append(", temporary=" + this.temporary);
        sb.append(", messageCount=" + this.messageCount);
        return sb.toString();
    }

    public ClientSession.QueueQuery toQueueQuery() {
        return new QueueQueryImpl(this.isDurable(), this.isTemporary(), this.getConsumerCount(), this.getMessageCount(), this.getFilterString(), this.getAddress(), this.getName(), this.isExists());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionQueueQueryResponseMessage)) {
            return false;
        }
        SessionQueueQueryResponseMessage other = (SessionQueueQueryResponseMessage)obj;
        return Objects.equals(this.address, other.address) && this.consumerCount == other.consumerCount && this.durable == other.durable && this.exists == other.exists && Objects.equals(this.filterString, other.filterString) && this.messageCount == other.messageCount && Objects.equals(this.name, other.name) && this.temporary == other.temporary;
    }
}

