/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.drivers.OperationTrace;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModeBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModePathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModeStatBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.CreateBackgroundModeACLable;
import org.apache.curator.framework.api.CreateBackgroundModeStatACLable;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.CreateBuilder2;
import org.apache.curator.framework.api.CreateBuilderMain;
import org.apache.curator.framework.api.CreateProtectACLCreateModePathAndBytesable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.ProtectACLCreateModePathAndBytesable;
import org.apache.curator.framework.api.ProtectACLCreateModeStatPathAndBytesable;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.api.transaction.OperationType;
import org.apache.curator.framework.api.transaction.TransactionCreateBuilder;
import org.apache.curator.framework.api.transaction.TransactionCreateBuilder2;
import org.apache.curator.framework.imps.ACLing;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkBase;
import org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import org.apache.curator.framework.imps.FindAndDeleteProtectedNodeInBackground;
import org.apache.curator.framework.imps.IdempotentUtils;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.PathAndBytes;
import org.apache.curator.framework.imps.ProtectedMode;
import org.apache.curator.framework.imps.ProtectedUtils;
import org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.curator.shaded.com.google.common.base.Predicate;
import org.apache.curator.shaded.com.google.common.collect.Iterables;
import org.apache.curator.utils.InternalACLProvider;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.DataTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBuilderImpl
implements CreateBuilder,
CreateBuilder2,
BackgroundOperation<PathAndBytes>,
ErrorListenerPathAndBytesable<String> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFrameworkBase client;
    private final ProtectedMode protectedMode = new ProtectedMode();
    private CreateMode createMode;
    private Backgrounding backgrounding;
    private boolean createParentsIfNeeded;
    private boolean createParentsAsContainers;
    private boolean compress;
    private boolean setDataIfExists;
    private int setDataIfExistsVersion = -1;
    private boolean idempotent = false;
    private ACLing acling;
    private Stat storingStat;
    private long ttl;
    @VisibleForTesting
    boolean failNextCreateForTesting = false;
    @VisibleForTesting
    boolean failBeforeNextCreateForTesting = false;
    @VisibleForTesting
    boolean failNextIdempotentCheckForTesting = false;
    @VisibleForTesting
    volatile boolean debugForceFindProtectedNode = false;

    CreateBuilderImpl(CuratorFrameworkBase client) {
        this.client = client;
        this.createMode = CreateMode.PERSISTENT;
        this.backgrounding = new Backgrounding();
        this.acling = new ACLing(client.getAclProvider());
        this.createParentsIfNeeded = false;
        this.createParentsAsContainers = false;
        this.compress = client.compressionEnabled();
        this.setDataIfExists = false;
        this.storingStat = null;
        this.ttl = -1L;
    }

    public CreateBuilderImpl(CuratorFrameworkBase client, CreateMode createMode, Backgrounding backgrounding, boolean createParentsIfNeeded, boolean createParentsAsContainers, boolean doProtected, boolean compress, boolean setDataIfExists, List<ACL> aclList, Stat storingStat, long ttl) {
        this.client = client;
        this.createMode = createMode;
        this.backgrounding = backgrounding;
        this.createParentsIfNeeded = createParentsIfNeeded;
        this.createParentsAsContainers = createParentsAsContainers;
        this.compress = compress;
        this.setDataIfExists = setDataIfExists;
        this.acling = new ACLing(client.getAclProvider(), aclList);
        this.storingStat = storingStat;
        this.ttl = ttl;
        if (doProtected) {
            this.protectedMode.setProtectedMode();
        }
    }

    public void setSetDataIfExistsVersion(int version) {
        this.setDataIfExistsVersion = version;
    }

    @Override
    public CreateBuilder2 orSetData() {
        return this.orSetData(-1);
    }

    @Override
    public CreateBuilder2 orSetData(int version) {
        this.setDataIfExists = true;
        this.setDataIfExistsVersion = version;
        return this;
    }

    @Override
    public CreateBuilder2 idempotent() {
        this.idempotent = true;
        return this;
    }

    @Override
    public CreateBuilderMain withTtl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    <T> TransactionCreateBuilder<T> asTransactionCreateBuilder(final T context, final CuratorMultiTransactionRecord transaction) {
        return new TransactionCreateBuilder<T>(){
            final /* synthetic */ CreateBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public PathAndBytesable<T> withACL(List<ACL> aclList) {
                return this.withACL((List)aclList, false);
            }

            @Override
            public PathAndBytesable<T> withACL(List<ACL> aclList, boolean applyToParents) {
                this.this$0.withACL((List)aclList, applyToParents);
                return this;
            }

            @Override
            public TransactionCreateBuilder2<T> withTtl(long ttl) {
                this.this$0.withTtl(ttl);
                return this;
            }

            @Override
            public ACLPathAndBytesable<T> withMode(CreateMode mode) {
                this.this$0.withMode(mode);
                return this;
            }

            @Override
            public ACLCreateModePathAndBytesable<T> compressed() {
                this.this$0.compressed();
                return this;
            }

            @Override
            public ACLCreateModePathAndBytesable<T> uncompressed() {
                this.this$0.uncompressed();
                return this;
            }

            @Override
            public T forPath(String path) throws Exception {
                return this.forPath(path, this.this$0.client.getDefaultData());
            }

            @Override
            public T forPath(String path, byte[] data) throws Exception {
                if (this.this$0.compress) {
                    data = this.this$0.client.getCompressionProvider().compress(path, data);
                }
                String fixedPath = this.this$0.client.fixForNamespace(path);
                transaction.add(Op.create((String)fixedPath, (byte[])data, this.this$0.acling.getAclList(path), (CreateMode)this.this$0.createMode, (long)this.this$0.ttl), OperationType.CREATE, path);
                return context;
            }
        };
    }

    @Override
    public CreateBackgroundModeStatACLable compressed() {
        return this.withCompression(true);
    }

    @Override
    public CreateBackgroundModeStatACLable uncompressed() {
        return this.withCompression(false);
    }

    private CreateBackgroundModeStatACLable withCompression(boolean compress) {
        this.compress = compress;
        return new CreateBackgroundModeStatACLable(){

            @Override
            public CreateBackgroundModeACLable storingStatIn(Stat stat) {
                CreateBuilderImpl.this.storingStat = stat;
                return CreateBuilderImpl.this.asCreateBackgroundModeACLable();
            }

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
                CreateBuilderImpl.this.createParentsIfNeeded = true;
                return CreateBuilderImpl.this.asACLCreateModePathAndBytesable();
            }

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentContainersIfNeeded() {
                CreateBuilderImpl.this.setCreateParentsAsContainers();
                return this.creatingParentsIfNeeded();
            }

            @Override
            public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
                return CreateBuilderImpl.this.withProtectedEphemeralSequential();
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
        return this.withACL((List)aclList, false);
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
        this.acling = new ACLing(this.client.getAclProvider(), aclList, applyToParents);
        return new ACLBackgroundPathAndBytesable<String>(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    @Override
    public ProtectACLCreateModeStatPathAndBytesable<String> creatingParentContainersIfNeeded() {
        this.setCreateParentsAsContainers();
        return this.creatingParentsIfNeeded();
    }

    private void setCreateParentsAsContainers() {
        if (this.client.useContainerParentsIfAvailable()) {
            this.createParentsAsContainers = true;
        }
    }

    @Override
    public ProtectACLCreateModeStatPathAndBytesable<String> creatingParentsIfNeeded() {
        this.createParentsIfNeeded = true;
        return new ProtectACLCreateModeStatPathAndBytesable<String>(){

            @Override
            public ACLCreateModeBackgroundPathAndBytesable<String> withProtection() {
                return CreateBuilderImpl.this.withProtection();
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return this.withACL((List)aclList, false);
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> storingStatIn(Stat stat) {
                CreateBuilderImpl.this.storingStat = stat;
                return CreateBuilderImpl.this;
            }
        };
    }

    @Override
    public ACLCreateModeStatBackgroundPathAndBytesable<String> withProtection() {
        this.protectedMode.setProtectedMode();
        return this.asACLCreateModeStatBackgroundPathAndBytesable();
    }

    @Override
    public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
        this.protectedMode.setProtectedMode();
        this.createMode = CreateMode.EPHEMERAL_SEQUENTIAL;
        return new ACLPathAndBytesable<String>(){

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
        this.createMode = mode;
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<String> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public PathAndBytesable<String> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public String forPath(String path) throws Exception {
        return this.forPath(path, this.client.getDefaultData());
    }

    @Override
    public String forPath(String givenPath, byte[] data) throws Exception {
        if (this.compress) {
            data = this.client.getCompressionProvider().compress(givenPath, data);
        }
        String adjustedPath = this.adjustPath(this.client.fixForNamespace(givenPath, this.createMode.isSequential()));
        List<ACL> aclList = this.acling.getAclList(adjustedPath);
        this.client.getSchemaSet().getSchema(givenPath).validateCreate(this.createMode, givenPath, data, aclList);
        String returnPath = null;
        if (this.backgrounding.inBackground()) {
            this.pathInBackground(adjustedPath, data, givenPath);
        } else {
            String path = this.protectedPathInForeground(adjustedPath, data, aclList);
            returnPath = this.client.unfixForNamespace(path);
        }
        return returnPath;
    }

    private String protectedPathInForeground(String adjustedPath, byte[] data, List<ACL> aclList) throws Exception {
        try {
            return this.pathInForeground(adjustedPath, data, aclList);
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            if ((e instanceof KeeperException.ConnectionLossException || !(e instanceof KeeperException)) && this.protectedMode.doProtected()) {
                new FindAndDeleteProtectedNodeInBackground(this.client, ZKPaths.getPathAndNode((String)adjustedPath).getPath(), this.protectedMode.protectedId()).execute();
                this.protectedMode.resetProtectedId();
            }
            throw e;
        }
    }

    @Override
    public CuratorEventType getBackgroundEventType() {
        return CuratorEventType.CREATE;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<PathAndBytes> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("CreateBuilderImpl-Background");
            final byte[] data = operationAndData.getData().getData();
            AsyncCallback.Create2Callback callback = new AsyncCallback.Create2Callback(){
                final /* synthetic */ CreateBuilderImpl this$0;
                {
                    this.this$0 = this$0;
                }

                public void processResult(int rc, String path, Object ctx, String name, Stat stat) {
                    trace.setReturnCode(rc).setRequestBytesLength(data).setPath(path).commit();
                    if (stat != null && this.this$0.storingStat != null) {
                        DataTree.copyStat((Stat)stat, (Stat)this.this$0.storingStat);
                    }
                    if (rc == KeeperException.Code.NONODE.intValue() && this.this$0.createParentsIfNeeded) {
                        CreateBuilderImpl.backgroundCreateParentsThenNode(this.this$0.client, operationAndData, ((PathAndBytes)operationAndData.getData()).getPath(), this.this$0.acling.getACLProviderForParents(), this.this$0.createParentsAsContainers);
                    } else if (rc == KeeperException.Code.NODEEXISTS.intValue() && this.this$0.setDataIfExists) {
                        this.this$0.backgroundSetData(this.this$0.client, operationAndData, ((PathAndBytes)operationAndData.getData()).getPath(), this.this$0.backgrounding);
                    } else if (rc == KeeperException.Code.NODEEXISTS.intValue() && this.this$0.idempotent) {
                        this.this$0.backgroundCheckIdempotent(this.this$0.client, operationAndData, ((PathAndBytes)operationAndData.getData()).getPath(), this.this$0.backgrounding);
                    } else {
                        this.this$0.sendBackgroundResponse(rc, path, ctx, name, stat, operationAndData);
                    }
                }
            };
            this.client.getZooKeeper().create(operationAndData.getData().getPath(), data, this.acling.getAclList(operationAndData.getData().getPath()), this.createMode, callback, this.backgrounding.getContext(), this.ttl);
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e, null);
        }
    }

    @Override
    public CreateProtectACLCreateModePathAndBytesable<String> storingStatIn(Stat stat) {
        this.storingStat = stat;
        return new CreateProtectACLCreateModePathAndBytesable<String>(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public ACLCreateModeBackgroundPathAndBytesable<String> withProtection() {
                return CreateBuilderImpl.this.withProtection();
            }

            @Override
            public ProtectACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
                return CreateBuilderImpl.this.creatingParentsIfNeeded();
            }

            @Override
            public ProtectACLCreateModePathAndBytesable<String> creatingParentContainersIfNeeded() {
                return CreateBuilderImpl.this.creatingParentContainersIfNeeded();
            }
        };
    }

    static <T> void backgroundCreateParentsThenNode(final CuratorFrameworkBase client, final OperationAndData<T> mainOperationAndData, final String path, final InternalACLProvider aclProvider, final boolean createParentsAsContainers) {
        BackgroundOperation operation = new BackgroundOperation<T>(){

            @Override
            public void performBackgroundOperation(OperationAndData<T> dummy) throws Exception {
                block2: {
                    try {
                        ZKPaths.mkdirs((ZooKeeper)client.getZooKeeper(), (String)path, (boolean)false, (InternalACLProvider)aclProvider, (boolean)createParentsAsContainers);
                    }
                    catch (KeeperException e) {
                        if (client.getZookeeperClient().getRetryPolicy().allowRetry((Throwable)e)) break block2;
                        throw e;
                    }
                }
                client.queueOperation(mainOperationAndData);
            }

            @Override
            public CuratorEventType getBackgroundEventType() {
                return CuratorEventType.CREATE;
            }
        };
        OperationAndData<T> parentOperation = new OperationAndData<T>(operation, mainOperationAndData);
        client.queueOperation(parentOperation);
    }

    private void backgroundSetData(final CuratorFrameworkBase client, final OperationAndData<PathAndBytes> mainOperationAndData, final String path, final Backgrounding backgrounding) {
        final AsyncCallback.StatCallback statCallback = new AsyncCallback.StatCallback(){
            final /* synthetic */ CreateBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    client.queueOperation(mainOperationAndData);
                } else {
                    this.this$0.sendBackgroundResponse(rc, path, ctx, path, stat, mainOperationAndData);
                }
            }
        };
        BackgroundOperation<PathAndBytes> operation = new BackgroundOperation<PathAndBytes>(){
            final /* synthetic */ CreateBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void performBackgroundOperation(OperationAndData<PathAndBytes> op) throws Exception {
                client.getZooKeeper().setData(path, ((PathAndBytes)mainOperationAndData.getData()).getData(), this.this$0.setDataIfExistsVersion, statCallback, backgrounding.getContext());
            }

            @Override
            public CuratorEventType getBackgroundEventType() {
                return CuratorEventType.CREATE;
            }
        };
        client.queueOperation(new OperationAndData<PathAndBytes>(operation, mainOperationAndData));
    }

    private void backgroundCheckIdempotent(final CuratorFrameworkBase client, final OperationAndData<PathAndBytes> mainOperationAndData, final String path, final Backgrounding backgrounding) {
        final AsyncCallback.DataCallback dataCallback = new AsyncCallback.DataCallback(){
            final /* synthetic */ CreateBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    client.queueOperation(mainOperationAndData);
                } else {
                    if (rc == KeeperException.Code.OK.intValue()) {
                        if (this.this$0.failNextIdempotentCheckForTesting) {
                            this.this$0.failNextIdempotentCheckForTesting = false;
                            rc = KeeperException.Code.CONNECTIONLOSS.intValue();
                        } else if (!IdempotentUtils.matches(0, ((PathAndBytes)mainOperationAndData.getData()).getData(), stat.getVersion(), data)) {
                            rc = KeeperException.Code.NODEEXISTS.intValue();
                        }
                    }
                    this.this$0.sendBackgroundResponse(rc, path, ctx, path, stat, mainOperationAndData);
                }
            }
        };
        BackgroundOperation<PathAndBytes> operation = new BackgroundOperation<PathAndBytes>(){
            final /* synthetic */ CreateBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void performBackgroundOperation(OperationAndData<PathAndBytes> op) throws Exception {
                client.getZooKeeper().getData(path, false, dataCallback, backgrounding.getContext());
            }

            @Override
            public CuratorEventType getBackgroundEventType() {
                return CuratorEventType.CREATE;
            }
        };
        client.queueOperation(new OperationAndData<PathAndBytes>(operation, mainOperationAndData));
    }

    private void sendBackgroundResponse(int rc, String path, Object ctx, String name, Stat stat, OperationAndData<PathAndBytes> operationAndData) {
        CreateBuilderImpl.sendBackgroundResponse(this.client, rc, path, ctx, name, stat, operationAndData);
    }

    private static <T> void sendBackgroundResponse(CuratorFrameworkBase client, int rc, String path, Object ctx, String name, Stat stat, OperationAndData<T> operationAndData) {
        CuratorEventImpl event = new CuratorEventImpl(client, CuratorEventType.CREATE, rc, path, name, ctx, stat, null, null, null, null, null);
        client.processBackgroundOperation(operationAndData, event);
    }

    private ACLCreateModePathAndBytesable<String> asACLCreateModePathAndBytesable() {
        return new ACLCreateModePathAndBytesable<String>(){

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
                return this;
            }

            @Override
            public ACLPathAndBytesable<String> withMode(CreateMode mode) {
                CreateBuilderImpl.this.createMode = mode;
                return new ACLPathAndBytesable<String>(){

                    @Override
                    public PathAndBytesable<String> withACL(List<ACL> aclList) {
                        return CreateBuilderImpl.this.withACL((List)aclList);
                    }

                    @Override
                    public PathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                        return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
                    }

                    @Override
                    public String forPath(String path, byte[] data) throws Exception {
                        return CreateBuilderImpl.this.forPath(path, data);
                    }

                    @Override
                    public String forPath(String path) throws Exception {
                        return CreateBuilderImpl.this.forPath(path);
                    }
                };
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    private CreateBackgroundModeACLable asCreateBackgroundModeACLable() {
        return new CreateBackgroundModeACLable(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
                return CreateBuilderImpl.this.withProtectedEphemeralSequential();
            }

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
                CreateBuilderImpl.this.createParentsIfNeeded = true;
                return CreateBuilderImpl.this.asACLCreateModePathAndBytesable();
            }

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentContainersIfNeeded() {
                CreateBuilderImpl.this.setCreateParentsAsContainers();
                return CreateBuilderImpl.this.asACLCreateModePathAndBytesable();
            }
        };
    }

    private ACLCreateModeStatBackgroundPathAndBytesable<String> asACLCreateModeStatBackgroundPathAndBytesable() {
        return new ACLCreateModeStatBackgroundPathAndBytesable<String>(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
                return this;
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public ACLCreateModeBackgroundPathAndBytesable<String> storingStatIn(Stat stat) {
                CreateBuilderImpl.this.storingStat = stat;
                return CreateBuilderImpl.this;
            }
        };
    }

    private void pathInBackground(final String path, final byte[] data, final String givenPath) {
        final AtomicBoolean firstTime = new AtomicBoolean(true);
        OperationAndData<PathAndBytes> operationAndData = new OperationAndData<PathAndBytes>(this, (BackgroundOperation)this, new PathAndBytes(path, data), this.backgrounding.getCallback(), (OperationAndData.ErrorCallback)new OperationAndData.ErrorCallback<PathAndBytes>(){
            final /* synthetic */ CreateBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void retriesExhausted(OperationAndData<PathAndBytes> operationAndData) {
                if (this.this$0.protectedMode.doProtected()) {
                    new FindAndDeleteProtectedNodeInBackground(this.this$0.client, ZKPaths.getPathAndNode((String)path).getPath(), this.this$0.protectedMode.protectedId()).execute();
                    this.this$0.protectedMode.resetProtectedId();
                }
            }
        }, this.backgrounding.getContext(), null){
            final /* synthetic */ CreateBuilderImpl this$0;
            {
                this.this$0 = this$0;
                super(operation, data2, callback, errorCallback, context, watching);
            }

            @Override
            void callPerformBackgroundOperation() throws Exception {
                boolean callSuper = true;
                boolean localFirstTime = firstTime.getAndSet(false) && !this.this$0.debugForceFindProtectedNode;
                this.this$0.protectedMode.checkSetSessionId(this.this$0.client, this.this$0.createMode);
                if (!localFirstTime && this.this$0.protectedMode.doProtected()) {
                    this.this$0.debugForceFindProtectedNode = false;
                    String createdPath = null;
                    try {
                        createdPath = this.this$0.findProtectedNodeInForeground(path);
                    }
                    catch (KeeperException.ConnectionLossException e) {
                        this.this$0.sendBackgroundResponse(KeeperException.Code.CONNECTIONLOSS.intValue(), path, this.this$0.backgrounding.getContext(), null, null, this);
                        callSuper = false;
                    }
                    if (createdPath != null) {
                        try {
                            this.this$0.sendBackgroundResponse(KeeperException.Code.OK.intValue(), createdPath, this.this$0.backgrounding.getContext(), createdPath, null, this);
                        }
                        catch (Exception e) {
                            ThreadUtils.checkInterrupted((Throwable)e);
                            this.this$0.client.logError("Processing protected create for path: " + givenPath, e);
                        }
                        callSuper = false;
                    }
                }
                if (this.this$0.failBeforeNextCreateForTesting) {
                    this.this$0.failBeforeNextCreateForTesting = false;
                    throw new KeeperException.ConnectionLossException();
                }
                if (this.this$0.failNextCreateForTesting) {
                    this.this$0.failNextCreateForTesting = false;
                    try {
                        this.this$0.pathInForeground(path, data, this.this$0.acling.getAclList(path));
                    }
                    catch (KeeperException.NodeExistsException e) {
                        this.this$0.client.logError("NodeExists while injecting failure after create, ignoring: " + givenPath, e);
                    }
                    throw new KeeperException.ConnectionLossException();
                }
                if (callSuper) {
                    super.callPerformBackgroundOperation();
                }
            }
        };
        this.client.processBackgroundOperation(operationAndData, null);
    }

    private String pathInForeground(final String path, final byte[] data, final List<ACL> aclList) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("CreateBuilderImpl-Foreground");
        final AtomicBoolean firstTime = new AtomicBoolean(true);
        String returnPath = (String)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<String>(){
            final /* synthetic */ CreateBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String call() throws Exception {
                String createdPath;
                block15: {
                    boolean localFirstTime = firstTime.getAndSet(false) && !this.this$0.debugForceFindProtectedNode;
                    this.this$0.protectedMode.checkSetSessionId(this.this$0.client, this.this$0.createMode);
                    createdPath = null;
                    if (!localFirstTime && this.this$0.protectedMode.doProtected()) {
                        this.this$0.debugForceFindProtectedNode = false;
                        createdPath = this.this$0.findProtectedNodeInForeground(path);
                    }
                    if (createdPath == null) {
                        try {
                            try {
                                if (this.this$0.failBeforeNextCreateForTesting) {
                                    this.this$0.failBeforeNextCreateForTesting = false;
                                    throw new KeeperException.ConnectionLossException();
                                }
                                createdPath = this.this$0.client.getZooKeeper().create(path, data, aclList, this.this$0.createMode, this.this$0.storingStat, this.this$0.ttl);
                            }
                            catch (KeeperException.NoNodeException e) {
                                if (this.this$0.createParentsIfNeeded) {
                                    ZKPaths.mkdirs((ZooKeeper)this.this$0.client.getZooKeeper(), (String)path, (boolean)false, (InternalACLProvider)this.this$0.acling.getACLProviderForParents(), (boolean)this.this$0.createParentsAsContainers);
                                    createdPath = this.this$0.client.getZooKeeper().create(path, data, this.this$0.acling.getAclList(path), this.this$0.createMode, this.this$0.storingStat, this.this$0.ttl);
                                    break block15;
                                }
                                throw e;
                            }
                        }
                        catch (KeeperException.NodeExistsException e) {
                            if (this.this$0.setDataIfExists) {
                                Stat setStat = this.this$0.client.getZooKeeper().setData(path, data, this.this$0.setDataIfExistsVersion);
                                if (this.this$0.storingStat != null) {
                                    DataTree.copyStat((Stat)setStat, (Stat)this.this$0.storingStat);
                                }
                                createdPath = path;
                            }
                            if (this.this$0.idempotent) {
                                if (this.this$0.failNextIdempotentCheckForTesting) {
                                    this.this$0.failNextIdempotentCheckForTesting = false;
                                    throw new KeeperException.ConnectionLossException();
                                }
                                Stat getStat = new Stat();
                                byte[] existingData = this.this$0.client.getZooKeeper().getData(path, false, getStat);
                                if (IdempotentUtils.matches(0, data, getStat.getVersion(), existingData)) {
                                    if (this.this$0.storingStat != null) {
                                        DataTree.copyStat((Stat)getStat, (Stat)this.this$0.storingStat);
                                    }
                                    createdPath = path;
                                }
                                throw e;
                            }
                            throw e;
                        }
                    }
                }
                if (this.this$0.failNextCreateForTesting) {
                    this.this$0.failNextCreateForTesting = false;
                    throw new KeeperException.ConnectionLossException();
                }
                return createdPath;
            }
        });
        trace.setRequestBytesLength(data).setPath(path).commit();
        return returnPath;
    }

    private String findProtectedNodeInForeground(final String path) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("CreateBuilderImpl-findProtectedNodeInForeground");
        String returnPath = (String)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<String>(){
            final /* synthetic */ CreateBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String call() throws Exception {
                String foundNode = null;
                try {
                    ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode((String)path);
                    List children = this.this$0.client.getZooKeeper().getChildren(pathAndNode.getPath(), false);
                    foundNode = CreateBuilderImpl.findNode(children, pathAndNode.getPath(), this.this$0.protectedMode.protectedId());
                    this.this$0.log.debug("Protected mode findNode result: {}", (Object)foundNode);
                    foundNode = this.this$0.protectedMode.validateFoundNode(this.this$0.client, this.this$0.createMode, foundNode);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
                return foundNode;
            }
        });
        trace.setPath(path).commit();
        return returnPath;
    }

    @VisibleForTesting
    String adjustPath(String path) throws Exception {
        return ProtectedUtils.toProtectedZNodePath(path, this.protectedMode.protectedId());
    }

    static String findNode(List<String> children, String path, String protectedId) {
        final String protectedPrefix = ProtectedUtils.getProtectedPrefix(protectedId);
        String foundNode = (String)Iterables.find(children, (Predicate)new Predicate<String>(){

            public boolean apply(String node) {
                return node.startsWith(protectedPrefix);
            }
        }, null);
        if (foundNode != null) {
            foundNode = ZKPaths.makePath((String)path, (String)foundNode);
        }
        return foundNode;
    }
}

