/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.filters;

import io.hawt.web.filters.HttpHeaderFilter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrictTransportSecurityFilter
extends HttpHeaderFilter {
    private static final Logger LOG = LoggerFactory.getLogger(StrictTransportSecurityFilter.class);
    private static final String STRICT_TRANSPORT_SECURITY = "http.strictTransportSecurity";
    private String headerValue;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.headerValue = this.getConfigParameter(STRICT_TRANSPORT_SECURITY);
        if (this.headerValue != null) {
            LOG.debug("HTTP Strict Transport Security is enabled: {}", (Object)this.headerValue);
        } else {
            LOG.debug("HTTP Strict Transport Security is disabled");
        }
    }

    @Override
    protected void addHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (this.headerValue != null) {
            response.addHeader("Strict-Transport-Security", this.headerValue);
        }
    }
}

