/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.nio;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.core.io.AbstractSequentialFile;
import org.apache.activemq.artemis.core.io.DelegateCallback;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.buffer.TimedBufferObserver;
import org.apache.activemq.artemis.journal.ActiveMQJournalBundle;
import org.apache.activemq.artemis.utils.Env;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOSequentialFile
extends AbstractSequentialFile {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean DEBUG_OPENS = false;
    private static final int CHUNK_SIZE = 0x200000;
    protected volatile FileChannel channel;
    protected volatile RandomAccessFile rfile;
    protected final int maxIO;
    private static Map<String, AtomicInteger> counters = new ConcurrentHashMap<String, AtomicInteger>();

    public NIOSequentialFile(SequentialFileFactory factory, File directory, String file, int maxIO, Executor writerExecutor) {
        super(directory, file, factory, writerExecutor);
        this.maxIO = maxIO;
    }

    @Override
    protected TimedBufferObserver createTimedBufferObserver() {
        return new SyncLocalBufferObserver();
    }

    @Override
    public int calculateBlockStart(int position) {
        return position;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.channel != null;
    }

    @Override
    public synchronized void open() throws IOException {
        this.open(this.maxIO, true);
    }

    @Override
    public ByteBuffer map(int position, long size) throws IOException {
        return this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
    }

    public static void clearDebug() {
        counters.clear();
    }

    public static void printDebug() {
        for (Map.Entry<String, AtomicInteger> entry : counters.entrySet()) {
            System.out.println(String.valueOf(entry.getValue()) + " " + entry.getKey());
        }
    }

    public static AtomicInteger getDebugCounter(Exception location) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        location.printStackTrace(printWriter);
        String strLocation = writer.toString();
        return NIOSequentialFile.getDebugCounter(strLocation);
    }

    public static AtomicInteger getDebugCounter(String strLocation) {
        AtomicInteger oldvalue;
        AtomicInteger value = counters.get(strLocation);
        if (value == null && (oldvalue = counters.putIfAbsent(strLocation, value = new AtomicInteger(0))) != null) {
            value = oldvalue;
        }
        return value;
    }

    @Override
    public void open(int maxIO, boolean useExecutor) throws IOException {
        try {
            this.rfile = new RandomAccessFile(this.getFile(), "rw");
            this.channel = this.rfile.getChannel();
            this.fileSize = this.channel.size();
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            this.factory.onIOError((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(int size) throws IOException {
        try {
            int zeroPageCapacity = Env.osPageSize();
            ByteBuffer zeroPage = this.factory.newBuffer(zeroPageCapacity);
            try {
                int bytesToWrite = size;
                long writePosition = 0L;
                while (bytesToWrite > 0) {
                    zeroPage.clear();
                    int zeroPageLimit = Math.min(bytesToWrite, zeroPageCapacity);
                    zeroPage.limit(zeroPageLimit);
                    int writtenBytes = this.channel.write(zeroPage, writePosition);
                    bytesToWrite -= writtenBytes;
                    writePosition += (long)writtenBytes;
                }
                if (this.factory.isDatasync()) {
                    this.channel.force(true);
                }
                this.channel.position(0L);
                this.fileSize = this.channel.size();
            }
            finally {
                this.factory.releaseBuffer(zeroPage);
            }
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            this.factory.onIOError((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
    }

    @Override
    public synchronized void close() throws IOException, InterruptedException, ActiveMQException {
        this.close(true, true);
    }

    @Override
    public synchronized void close(boolean waitSync, boolean blockOnPending) throws IOException, InterruptedException, ActiveMQException {
        super.close();
        try {
            try {
                if (this.channel != null) {
                    if (waitSync && this.factory.isDatasync()) {
                        this.channel.force(false);
                    }
                    this.channel.close();
                }
            }
            finally {
                if (this.rfile != null) {
                    this.rfile.close();
                }
            }
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            this.factory.onIOError((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
        finally {
            this.channel = null;
            this.rfile = null;
        }
        this.notifyAll();
    }

    @Override
    public int read(ByteBuffer bytes) throws Exception {
        return this.read(bytes, null);
    }

    private static int readRafInChunks(RandomAccessFile raf, byte[] b, int off, int len) throws IOException {
        int remaining;
        int read;
        int offset = off;
        for (remaining = len; remaining > 0; remaining -= read) {
            int chunkSize = Math.min(0x200000, remaining);
            read = raf.read(b, offset, chunkSize);
            assert (read != 0);
            if (read == -1) {
                if (len != remaining) break;
                return -1;
            }
            offset += read;
        }
        return len - remaining;
    }

    private static void writeRafInChunks(RandomAccessFile raf, byte[] b, int off, int len) throws IOException {
        int chunkSize;
        int offset = off;
        for (int remaining = len; remaining > 0; remaining -= chunkSize) {
            chunkSize = Math.min(0x200000, remaining);
            raf.write(b, offset, chunkSize);
            offset += chunkSize;
        }
    }

    @Override
    public synchronized int read(ByteBuffer bytes, IOCallback callback) throws IOException, ActiveMQIllegalStateException {
        try {
            int bytesRead;
            if (this.channel == null) {
                throw new ActiveMQIllegalStateException("File " + this.getFileName() + " has a null channel");
            }
            if (bytes.hasArray()) {
                bytesRead = bytes.remaining() > 0x200000 ? NIOSequentialFile.readRafInChunks(this.rfile, bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining()) : this.rfile.read(bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining());
                if (bytesRead > 0) {
                    bytes.position(bytes.position() + bytesRead);
                }
            } else {
                bytesRead = this.channel.read(bytes);
            }
            if (callback != null) {
                callback.done();
            }
            bytes.flip();
            return bytesRead;
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            if (callback != null) {
                callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), String.valueOf(e.getClass()) + " during read: " + e.getLocalizedMessage());
            }
            this.factory.onIOError((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
    }

    @Override
    public void sync() throws IOException {
        FileChannel channel1 = this.channel;
        if (this.factory.isDatasync() && channel1 != null && channel1.isOpen()) {
            try {
                this.syncChannel(channel1);
            }
            catch (IOException e) {
                if (e instanceof ClosedChannelException) {
                    logger.debug("ClosedChannelException for file {}", (Object)this.file, (Object)e);
                }
                this.factory.onIOError((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
                throw e;
            }
        }
    }

    protected void syncChannel(FileChannel syncChannel) throws IOException {
        syncChannel.force(false);
    }

    @Override
    public long size() throws IOException {
        if (this.channel == null) {
            return this.getFile().length();
        }
        try {
            return this.channel.size();
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            this.factory.onIOError((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
    }

    @Override
    public void position(long pos) throws IOException {
        try {
            super.position(pos);
            this.channel.position(pos);
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            this.factory.onIOError((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
    }

    public String toString() {
        return "NIOSequentialFile " + String.valueOf(this.getFile());
    }

    @Override
    public SequentialFile cloneFile() {
        return new NIOSequentialFile(this.factory, this.directory, this.getFileName(), this.maxIO, null);
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync, IOCallback callback) {
        try {
            this.internalWrite(bytes, sync, callback, true);
        }
        catch (Exception e) {
            callback.onError(ActiveMQExceptionType.GENERIC_EXCEPTION.getCode(), String.valueOf(e.getClass()) + " during write direct: " + e.getMessage());
        }
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync) throws Exception {
        this.internalWrite(bytes, sync, null, true);
    }

    @Override
    public void blockingWriteDirect(ByteBuffer bytes, boolean sync, boolean releaseBuffer) throws Exception {
        this.internalWrite(bytes, sync, null, releaseBuffer);
    }

    private synchronized void internalWrite(ByteBuffer bytes, boolean sync, IOCallback callback, boolean releaseBuffer) throws IOException, ActiveMQIOErrorException, InterruptedException {
        if (!this.isOpen()) {
            if (callback == null) {
                throw ActiveMQJournalBundle.BUNDLE.fileNotOpened();
            }
            callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), "File not opened. Cannot write to " + this.getFileName());
            return;
        }
        this.position.addAndGet(bytes.limit());
        try {
            this.doInternalWrite(bytes, sync, callback, releaseBuffer);
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            this.factory.onIOError((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInternalWrite(ByteBuffer bytes, boolean sync, IOCallback callback, boolean releaseBuffer) throws IOException {
        try {
            if (bytes.hasArray()) {
                if (bytes.remaining() > 0x200000) {
                    NIOSequentialFile.writeRafInChunks(this.rfile, bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining());
                } else {
                    this.rfile.write(bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining());
                }
                bytes.position(bytes.limit());
            } else {
                this.channel.write(bytes);
            }
            if (sync) {
                this.sync();
            }
            if (callback != null) {
                callback.done();
            }
        }
        finally {
            if (releaseBuffer) {
                this.factory.releaseBuffer(bytes);
            }
        }
    }

    @Override
    public void copyTo(SequentialFile dstFile) throws IOException {
        logger.debug("Copying {} as {}", (Object)this, (Object)dstFile);
        if (this.isOpen()) {
            throw new IllegalStateException("File opened!");
        }
        if (dstFile.isOpen()) {
            throw new IllegalArgumentException("dstFile must be closed too");
        }
        SequentialFile.appendTo(this.getFile().toPath(), dstFile.getJavaFile().toPath());
    }

    private class SyncLocalBufferObserver
    extends AbstractSequentialFile.LocalBufferObserver {
        private SyncLocalBufferObserver() {
        }

        @Override
        public void flushBuffer(ByteBuf byteBuf, boolean requestedSync, List<IOCallback> callbacks) {
            int bytes = byteBuf.readableBytes();
            if (bytes == 0) {
                IOCallback.done(callbacks);
            } else if (byteBuf.nioBufferCount() == 1 && byteBuf.isDirect()) {
                ByteBuffer buffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), bytes);
                DelegateCallback callback = DelegateCallback.wrap(callbacks);
                try {
                    NIOSequentialFile.this.internalWrite(buffer, requestedSync, callback, false);
                }
                catch (Exception e) {
                    if (callbacks != null) {
                        callbacks.forEach(c -> c.onError(ActiveMQExceptionType.GENERIC_EXCEPTION.getCode(), String.valueOf(e.getClass()) + " while flushing buffer: " + e.getMessage()));
                    }
                }
            } else {
                super.flushBuffer(byteBuf, requestedSync, callbacks);
            }
        }
    }
}

