/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import org.apache.qpid.jms.meta.JmsAbstractResourceId;
import org.apache.qpid.jms.meta.JmsSessionId;

public final class JmsConsumerId
extends JmsAbstractResourceId
implements Comparable<JmsConsumerId> {
    private String connectionId;
    private long sessionId;
    private long value;
    private transient String key;
    private transient JmsSessionId parentId;

    public JmsConsumerId(String connectionId, long sessionId, long consumerId) {
        if (connectionId == null || connectionId.isEmpty()) {
            throw new IllegalArgumentException("Connection ID cannot be null or an empty string");
        }
        this.connectionId = connectionId;
        this.sessionId = sessionId;
        this.value = consumerId;
    }

    public JmsConsumerId(JmsSessionId sessionId, long consumerId) {
        if (sessionId == null) {
            throw new IllegalArgumentException("Session ID cannot be null");
        }
        this.connectionId = sessionId.getConnectionId();
        this.sessionId = sessionId.getValue();
        this.value = consumerId;
        this.parentId = sessionId;
    }

    public JmsConsumerId(JmsConsumerId consumerId) {
        if (consumerId == null) {
            throw new IllegalArgumentException("Consumer ID cannot be null");
        }
        this.connectionId = consumerId.getConnectionId();
        this.sessionId = consumerId.getSessionId();
        this.value = consumerId.getValue();
        this.parentId = consumerId.getParentId();
    }

    public JmsConsumerId(String consumerKey) throws IllegalArgumentException {
        if (consumerKey == null || consumerKey.isEmpty()) {
            throw new IllegalArgumentException("Consumer Key cannot be null or empty");
        }
        int p = consumerKey.lastIndexOf(":");
        if (p >= 0) {
            this.value = Long.parseLong(consumerKey.substring(p + 1));
            consumerKey = consumerKey.substring(0, p);
        }
        this.setConsumerSessionKey(consumerKey);
    }

    public JmsSessionId getParentId() {
        if (this.parentId == null) {
            this.parentId = new JmsSessionId(this);
        }
        return this.parentId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public long getValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = 31 * this.hashCode + this.connectionId.hashCode();
            this.hashCode = 31 * this.hashCode + (int)(this.sessionId ^ this.sessionId >>> 32);
            this.hashCode = 31 * this.hashCode + (int)(this.value ^ this.value >>> 32);
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != JmsConsumerId.class) {
            return false;
        }
        JmsConsumerId id = (JmsConsumerId)o;
        return this.sessionId == id.sessionId && this.value == id.value && this.connectionId.equals(id.connectionId);
    }

    public String toString() {
        if (this.key == null) {
            this.key = this.connectionId + ":" + this.sessionId + ":" + this.value;
        }
        return this.key;
    }

    @Override
    public int compareTo(JmsConsumerId other) {
        return this.toString().compareTo(other.toString());
    }

    private void setConsumerSessionKey(String sessionKey) {
        int p = sessionKey.lastIndexOf(":");
        if (p >= 0) {
            this.sessionId = Long.parseLong(sessionKey.substring(p + 1));
            sessionKey = sessionKey.substring(0, p);
        }
        this.connectionId = sessionKey;
    }
}

