/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.rewrite.handler.Rule;

public abstract class RegexRule
extends Rule {
    protected Pattern _regex;

    protected RegexRule() {
    }

    protected RegexRule(String pattern) {
        this.setRegex(pattern);
    }

    public void setRegex(String regex) {
        this._regex = regex == null ? null : Pattern.compile(regex);
    }

    public String getRegex() {
        return this._regex == null ? null : this._regex.pattern();
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Matcher matcher = this._regex.matcher(target);
        boolean matches = matcher.matches();
        if (matches) {
            return this.apply(target, request, response, matcher);
        }
        return null;
    }

    protected abstract String apply(String var1, HttpServletRequest var2, HttpServletResponse var3, Matcher var4) throws IOException;

    @Override
    public String toString() {
        return super.toString() + "[" + String.valueOf(this._regex) + "]";
    }
}

