#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::BuyerProtectionCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BuyerProtectionCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::BuyerProtectionCodeType

=head1 DESCRIPTION

Indicates the status of the item's eligibility for the Buyer
Protection Program.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 ItemIneligible

(out) Item is ineligible (e.g., category not applicable).



=cut


use constant ItemIneligible => scalar('ItemIneligible');


=head2 ItemEligible

(out) Item is eligible per standard criteria.



=cut


use constant ItemEligible => scalar('ItemEligible');


=head2 ItemMarkedIneligible

(out) Item marked ineligible per special criteria (e.g., seller's account closed).



=cut


use constant ItemMarkedIneligible => scalar('ItemMarkedIneligible');


=head2 ItemMarkedEligible

(out) Item marked eligible per other criteria.



=cut


use constant ItemMarkedEligible => scalar('ItemMarkedEligible');


=head2 NoCoverage

(out) For the Australia site, indicates that there is 
no PayPal Buyer Protection coverage.
Coverage details would be in the following sections
of the View Item page: the Buy Safely section and the Payment Details section.



=cut


use constant NoCoverage => scalar('NoCoverage');


=head2 CustomCode

(out) Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
